/*
 * Decompiled with CFR 0.152.
 */
package org.gbase.geometric;

import java.io.Serializable;
import java.sql.SQLException;
import org.gbase.geometric.PGpoint;
import org.gbase.util.GT;
import org.gbase.util.PGobject;
import org.gbase.util.PGtokenizer;
import org.gbase.util.PSQLException;
import org.gbase.util.PSQLState;

public class PGcircle
extends PGobject
implements Serializable,
Cloneable {
    public PGpoint center;
    public double radius;

    public PGcircle(double x, double y, double r) {
        this(new PGpoint(x, y), r);
    }

    public PGcircle(PGpoint c, double r) {
        this();
        this.center = c;
        this.radius = r;
    }

    public PGcircle(String s) throws SQLException {
        this();
        this.setValue(s);
    }

    public PGcircle() {
        this.setType("circle");
    }

    @Override
    public void setValue(String s) throws SQLException {
        if (s == null) {
            throw new PSQLException(GT.tr("Conversion to type Circle failed, null info: {0}.", new Object[0]), PSQLState.DATA_TYPE_MISMATCH);
        }
        PGtokenizer t = new PGtokenizer(PGtokenizer.removeAngle(s), ',');
        if (t.getSize() != 2) {
            throw new PSQLException(GT.tr("Conversion to type {0} failed: {1}.", this.type, s), PSQLState.DATA_TYPE_MISMATCH);
        }
        try {
            this.center = new PGpoint(t.getToken(0));
            this.radius = Double.parseDouble(t.getToken(1));
        }
        catch (NumberFormatException e) {
            throw new PSQLException(GT.tr("Conversion to type {0} failed: {1}.", this.type, s), PSQLState.DATA_TYPE_MISMATCH, (Throwable)e);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof PGcircle) {
            PGcircle p = (PGcircle)obj;
            return p.center.equals(this.center) && p.radius == this.radius;
        }
        return false;
    }

    @Override
    public int hashCode() {
        long v = Double.doubleToLongBits(this.radius);
        return (int)((long)this.center.hashCode() ^ v ^ v >>> 32);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        PGcircle newPGcircle = (PGcircle)super.clone();
        if (newPGcircle.center != null) {
            newPGcircle.center = (PGpoint)newPGcircle.center.clone();
        }
        return newPGcircle;
    }

    @Override
    public String getValue() {
        return "<" + this.center + "," + this.radius + ">";
    }
}

