/*
 * Decompiled with CFR 0.152.
 */
package org.gbase.gss;

import java.io.IOException;
import java.security.PrivilegedAction;
import org.gbase.core.PGStream;
import org.gbase.log.Log;
import org.gbase.log.Logger;
import org.gbase.util.GT;
import org.gbase.util.PSQLException;
import org.gbase.util.PSQLState;
import org.gbase.util.ServerErrorMessage;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

class GssAction
implements PrivilegedAction<Exception> {
    private static Log LOGGER = Logger.getLogger(GssAction.class.getName());
    private final PGStream pgStream;
    private final String host;
    private final String user;
    private final String kerberosServerName;
    private final boolean useSpnego;
    private final GSSCredential clientCredentials;
    private final String socketAddress;

    GssAction(PGStream pgStream, GSSCredential clientCredentials, String host, String user, String kerberosServerName, boolean useSpnego) {
        this.pgStream = pgStream;
        this.clientCredentials = clientCredentials;
        this.host = host;
        this.user = user;
        this.kerberosServerName = kerberosServerName;
        this.useSpnego = useSpnego;
        this.socketAddress = pgStream.getConnectInfo();
    }

    private static boolean hasSpnegoSupport(GSSManager manager) throws GSSException {
        Oid[] mechs;
        Oid spnego = new Oid("1.3.6.1.5.5.2");
        for (Oid mech : mechs = manager.getMechs()) {
            if (!mech.equals(spnego)) continue;
            return true;
        }
        return false;
    }

    private GSSContext getSecContext() throws GSSException {
        GSSManager manager = GSSManager.getInstance();
        GSSCredential clientCreds = null;
        Oid[] desiredMechs = new Oid[1];
        if (this.clientCredentials == null) {
            desiredMechs[0] = this.useSpnego && GssAction.hasSpnegoSupport(manager) ? new Oid("1.3.6.1.5.5.2") : new Oid("1.2.840.113554.1.2.2");
            GSSName clientName = manager.createName(this.user, GSSName.NT_USER_NAME);
            clientCreds = manager.createCredential(clientName, 28800, desiredMechs, 1);
        } else {
            desiredMechs[0] = new Oid("1.2.840.113554.1.2.2");
            clientCreds = this.clientCredentials;
        }
        String kerberosServerHostname = System.getProperty("kerberosServerHostname");
        if (kerberosServerHostname == null || kerberosServerHostname.equals("")) {
            kerberosServerHostname = this.host;
        }
        GSSName serverName = manager.createName(this.kerberosServerName + "@" + kerberosServerHostname, GSSName.NT_HOSTBASED_SERVICE);
        GSSContext secContext = manager.createContext(serverName, desiredMechs[0], clientCreds, 0);
        return secContext;
    }

    @Override
    public Exception run() {
        try {
            GSSContext secContext = this.getSecContext();
            secContext.requestMutualAuth(true);
            byte[] inToken = new byte[]{};
            byte[] outToken = null;
            boolean established = false;
            block7: while (!established) {
                outToken = secContext.initSecContext(inToken, 0, inToken.length);
                if (outToken != null) {
                    LOGGER.trace(" FE=> Password(GSS Authentication Token)");
                    this.pgStream.sendChar(112);
                    this.pgStream.sendInteger4(4 + outToken.length);
                    this.pgStream.send(outToken);
                    this.pgStream.flush();
                }
                if (!secContext.isEstablished()) {
                    int response = this.pgStream.receiveChar();
                    switch (response) {
                        case 69: {
                            int l_elen = this.pgStream.receiveInteger4();
                            ServerErrorMessage l_errorMsg = new ServerErrorMessage(this.pgStream.receiveErrorString(l_elen - 4), this.socketAddress);
                            LOGGER.trace(" <=BE ErrorMessage(" + l_errorMsg + ")");
                            return new PSQLException(l_errorMsg);
                        }
                        case 82: {
                            LOGGER.trace(" <=BE AuthenticationGSSContinue");
                            int len = this.pgStream.receiveInteger4();
                            int type = this.pgStream.receiveInteger4();
                            inToken = this.pgStream.receive(len - 8);
                            continue block7;
                        }
                    }
                    return new PSQLException(GT.tr("Protocol error.  Session setup failed.", new Object[0]), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
                }
                established = true;
            }
        }
        catch (IOException e) {
            return e;
        }
        catch (GSSException gsse) {
            return new PSQLException(GT.tr("GSS Authentication failed", new Object[0]), PSQLState.CONNECTION_FAILURE, (Throwable)gsse);
        }
        return null;
    }
}

