/*
 * Decompiled with CFR 0.152.
 */
package org.gbase.jdbc;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.net.URISyntaxException;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.ClientInfoStatus;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLPermission;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.gbase.Driver;
import org.gbase.PGNotification;
import org.gbase.PGProperty;
import org.gbase.copy.CopyManager;
import org.gbase.core.BaseConnection;
import org.gbase.core.BaseStatement;
import org.gbase.core.CachedQuery;
import org.gbase.core.ConnectionFactory;
import org.gbase.core.Encoding;
import org.gbase.core.Oid;
import org.gbase.core.Provider;
import org.gbase.core.Query;
import org.gbase.core.QueryExecutor;
import org.gbase.core.ReplicationProtocol;
import org.gbase.core.ResultHandlerBase;
import org.gbase.core.ServerVersion;
import org.gbase.core.SqlCommand;
import org.gbase.core.TransactionState;
import org.gbase.core.TypeInfo;
import org.gbase.core.Utils;
import org.gbase.core.Version;
import org.gbase.core.types.PGBlob;
import org.gbase.core.types.PGClob;
import org.gbase.fastpath.Fastpath;
import org.gbase.geometric.PGbox;
import org.gbase.geometric.PGcircle;
import org.gbase.geometric.PGline;
import org.gbase.geometric.PGlseg;
import org.gbase.geometric.PGpath;
import org.gbase.geometric.PGpoint;
import org.gbase.geometric.PGpolygon;
import org.gbase.jdbc.AutoSave;
import org.gbase.jdbc.ClientLogic;
import org.gbase.jdbc.ClientLogicException;
import org.gbase.jdbc.FieldMetadata;
import org.gbase.jdbc.PSQLSavepoint;
import org.gbase.jdbc.PgArray;
import org.gbase.jdbc.PgBlob;
import org.gbase.jdbc.PgCallableStatement;
import org.gbase.jdbc.PgClob;
import org.gbase.jdbc.PgDatabaseMetaData;
import org.gbase.jdbc.PgPreparedStatement;
import org.gbase.jdbc.PgSQLXML;
import org.gbase.jdbc.PgStatement;
import org.gbase.jdbc.PreferQueryMode;
import org.gbase.jdbc.PrimitiveArraySupport;
import org.gbase.jdbc.TimestampUtils;
import org.gbase.jdbc.TypeInfoCache;
import org.gbase.largeobject.LargeObjectManager;
import org.gbase.log.Log;
import org.gbase.log.Logger;
import org.gbase.replication.PGReplicationConnection;
import org.gbase.replication.PGReplicationConnectionImpl;
import org.gbase.util.GT;
import org.gbase.util.HostSpec;
import org.gbase.util.LruCache;
import org.gbase.util.PGBinaryObject;
import org.gbase.util.PGInterval;
import org.gbase.util.PGmoney;
import org.gbase.util.PGobject;
import org.gbase.util.PSQLException;
import org.gbase.util.PSQLState;
import org.gbase.xml.DefaultPGXmlFactoryFactory;
import org.gbase.xml.LegacyInsecurePGXmlFactoryFactory;
import org.gbase.xml.PGXmlFactoryFactory;

public class PgConnection
implements BaseConnection {
    private static Log LOGGER = Logger.getLogger(PgConnection.class.getName());
    private static final SQLPermission SQL_PERMISSION_ABORT = new SQLPermission("callAbort");
    private static final SQLPermission SQL_PERMISSION_NETWORK_TIMEOUT = new SQLPermission("setNetworkTimeout");
    private static final Map<String, String> CONNECTION_INFO_REPORT_BLACK_LIST = new HashMap<String, String>();
    private AtomicReferenceFieldUpdater<PgStatement, TimerTask> CANCEL_TIMER_UPDATER = AtomicReferenceFieldUpdater.newUpdater(PgStatement.class, TimerTask.class, "cancelTimerTask");
    private final Properties _clientInfo;
    private final String creatingURL;
    private Throwable openStackTrace;
    private final QueryExecutor queryExecutor;
    private final Query commitQuery;
    private final Query rollbackQuery;
    private ClientLogic clientLogic = null;
    private final TypeInfo _typeCache;
    private boolean disableColumnSanitiser = false;
    protected int prepareThreshold;
    protected int defaultFetchSize;
    protected boolean forcebinary = false;
    private int rsHoldability = 2;
    private int savepointId = 0;
    private boolean autoCommit = true;
    private boolean readOnly = false;
    private boolean allowReadOnly = true;
    public boolean batchInsert = true;
    public boolean blobmode = true;
    private int fetchSize = -1;
    private final boolean bindStringAsVarchar;
    private SQLWarning firstWarning = null;
    private boolean bitToString = false;
    private volatile Timer cancelTimer = null;
    private PreparedStatement checkConnectionQuery;
    private final boolean replicationConnection;
    private final LruCache<FieldMetadata.Key, FieldMetadata> fieldMetadataCache;
    private final String xmlFactoryFactoryClass;
    private PGXmlFactoryFactory xmlFactoryFactory;
    private String socketAddress;
    private final TimestampUtils timestampUtils;
    protected Map<String, Class<?>> typemap;
    private Fastpath fastpath = null;
    private LargeObjectManager largeobject = null;
    protected DatabaseMetaData metadata;
    private CopyManager copyManager = null;

    final CachedQuery borrowQuery(String sql) throws SQLException {
        return this.queryExecutor.borrowQuery(sql);
    }

    final CachedQuery borrowCallableQuery(String sql) throws SQLException {
        return this.queryExecutor.borrowCallableQuery(sql);
    }

    private CachedQuery borrowReturningQuery(String sql, String[] columnNames) throws SQLException {
        return this.queryExecutor.borrowReturningQuery(sql, columnNames);
    }

    @Override
    public CachedQuery createQuery(String sql, boolean escapeProcessing, boolean isParameterized, String ... columnNames) throws SQLException {
        return this.queryExecutor.createQuery(sql, escapeProcessing, isParameterized, columnNames);
    }

    void releaseQuery(CachedQuery cachedQuery) {
        this.queryExecutor.releaseQuery(cachedQuery);
    }

    @Override
    public void setFlushCacheOnDeallocate(boolean flushCacheOnDeallocate) {
        this.queryExecutor.setFlushCacheOnDeallocate(flushCacheOnDeallocate);
        LOGGER.debug("  setFlushCacheOnDeallocate = " + flushCacheOnDeallocate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PgConnection(HostSpec[] hostSpecs, String user, String database, Properties info, String url) throws SQLException {
        String batchString;
        String appType;
        LOGGER.debug("PostgreSQL JDBC Driver /*$mvn.project.property.parsedversion.osgiversion$*/");
        try {
            if (info.getProperty("fetchsize") != null) {
                this.fetchSize = Integer.parseInt(info.getProperty("fetchsize"));
                if (this.fetchSize < 0) {
                    this.fetchSize = -1;
                }
            }
        }
        catch (Exception e) {
            LOGGER.trace("Catch Exception while transfor fetchsize to integer. ", e);
        }
        try {
            String allow = info.getProperty("allowReadOnly");
            if (allow != null && !allow.trim().equals("") && allow.equalsIgnoreCase("FALSE")) {
                this.allowReadOnly = false;
            }
        }
        catch (Exception e) {
            LOGGER.trace("Catch Exception while compare allow and FALSE. ", e);
        }
        this.creatingURL = url;
        this.bitToString = PGProperty.BIT_TO_STRING.getBoolean(info);
        this.setDefaultFetchSize(PGProperty.DEFAULT_ROW_FETCH_SIZE.getInt(info));
        this.setPrepareThreshold(PGProperty.PREPARE_THRESHOLD.getInt(info));
        if (this.prepareThreshold == -1) {
            this.setForceBinary(true);
        }
        this.queryExecutor = ConnectionFactory.openConnection(hostSpecs, user, database, info);
        this.socketAddress = this.queryExecutor.getSocketAddress();
        if (LOGGER.isWarnEnabled() && !this.haveMinimumServerVersion(ServerVersion.v8_2)) {
            LOGGER.warn("Unsupported Server Version: " + this.queryExecutor.getServerVersion());
        }
        Set<Integer> binaryOids = PgConnection.getBinaryOids(info);
        HashSet<Integer> useBinarySendForOids = new HashSet<Integer>(binaryOids);
        HashSet<Integer> useBinaryReceiveForOids = new HashSet<Integer>(binaryOids);
        useBinarySendForOids.remove(1082);
        this.queryExecutor.setBinaryReceiveOids(useBinaryReceiveForOids);
        this.queryExecutor.setBinarySendOids(useBinarySendForOids);
        String stringType = PGProperty.STRING_TYPE.get(info);
        if (stringType != null) {
            if (stringType.equalsIgnoreCase("unspecified")) {
                this.bindStringAsVarchar = false;
            } else {
                if (!stringType.equalsIgnoreCase("varchar")) throw new PSQLException(GT.tr("Unsupported value for stringtype parameter: " + stringType, new Object[0]), PSQLState.INVALID_PARAMETER_VALUE);
                this.bindStringAsVarchar = true;
            }
        } else {
            this.bindStringAsVarchar = true;
        }
        this.timestampUtils = new TimestampUtils(!this.queryExecutor.getIntegerDateTimes(), new Provider<TimeZone>(){

            @Override
            public TimeZone get() {
                return PgConnection.this.queryExecutor.getTimeZone();
            }
        });
        this.commitQuery = this.createQuery((String)"COMMIT", (boolean)false, (boolean)true, (String[])new String[0]).query;
        this.rollbackQuery = this.createQuery((String)"ROLLBACK", (boolean)false, (boolean)true, (String[])new String[0]).query;
        int unknownLength = PGProperty.UNKNOWN_LENGTH.getInt(info);
        this._typeCache = this.createTypeInfo(this, unknownLength);
        this.initObjectTypes(info);
        if (PGProperty.LOG_UNCLOSED_CONNECTIONS.getBoolean(info)) {
            this.openStackTrace = new Throwable("Connection was created at this point:");
        }
        this.disableColumnSanitiser = PGProperty.DISABLE_COLUMN_SANITISER.getBoolean(info);
        if (this.haveMinimumServerVersion(ServerVersion.v8_3)) {
            this._typeCache.addCoreType("uuid", 2950, 1111, "java.util.UUID", 2951);
            this._typeCache.addCoreType("xml", 142, 2009, "java.sql.SQLXML", 143);
        }
        this._typeCache.addCoreType("clob", 90, 2005, "java.sql.CLOB", 0);
        this._typeCache.addCoreType("blob", 88, 2004, "java.sql.BLOB", 0);
        this._clientInfo = new Properties();
        if (this.haveMinimumServerVersion(ServerVersion.v9_0)) {
            String appName = PGProperty.APPLICATION_NAME.get(info);
            if (appName == null) {
                appName = "";
            }
            this._clientInfo.put("ApplicationName", appName);
        }
        if ((appType = PGProperty.APPLICATION_TYPE.get(info)) == null) {
            appType = "";
        }
        this._clientInfo.put("ApplicationType", appType);
        this.fieldMetadataCache = new LruCache(Math.max(0, PGProperty.DATABASE_METADATA_CACHE_FIELDS.getInt(info)), Math.max(0, PGProperty.DATABASE_METADATA_CACHE_FIELDS_MIB.getInt(info) * 1024 * 1024), false);
        this.xmlFactoryFactoryClass = PGProperty.XML_FACTORY_FACTORY.get(info);
        boolean bl = this.replicationConnection = PGProperty.REPLICATION.get(info) != null;
        if (this.replicationConnection) {
            return;
        }
        Statement stmtGetGuc = null;
        ResultSet rsGetGuc = null;
        Statement stmtSetGuc = null;
        try {
            String connectionExtraInfo = info.getProperty("connectionExtraInfo");
            String getGucSQL = "select name, setting from pg_settings where name in ('connection_info')";
            stmtGetGuc = this.createStatement();
            rsGetGuc = stmtGetGuc.executeQuery(getGucSQL);
            boolean useConnectionInfo = false;
            boolean useConnectionExtraInfo = false;
            while (rsGetGuc.next()) {
                if (!rsGetGuc.getString(1).equalsIgnoreCase("connection_info")) continue;
                useConnectionInfo = true;
                useConnectionExtraInfo = Boolean.valueOf(connectionExtraInfo);
            }
            if (useConnectionInfo) {
                String connectionInfo = this.getConnectionInfo(useConnectionExtraInfo, info);
                String setConnectionInfoSql = "set connection_info = '" + connectionInfo.replace("'", "''") + "'";
                if (!setConnectionInfoSql.contains(";")) {
                    stmtSetGuc = this.createStatement();
                    stmtSetGuc.executeUpdate(setConnectionInfoSql);
                } else {
                    LOGGER.debug("connection_info contains \";\", which is not allowed.");
                }
            }
        }
        catch (SQLException e) {
            LOGGER.trace("Catch SQLException while connection. ", e);
        }
        finally {
            if (stmtGetGuc != null) {
                stmtGetGuc.close();
            }
            if (rsGetGuc != null) {
                rsGetGuc.close();
            }
            if (stmtSetGuc != null) {
                stmtSetGuc.close();
            }
        }
        String blobString = info.getProperty("blobMode");
        if (blobString != null && blobString.equalsIgnoreCase("OFF")) {
            this.blobmode = false;
        }
        if ((batchString = info.getProperty("batchMode")) == null || batchString.equalsIgnoreCase("AUTO")) {
            if (this.batchInsert) {
                String sql = "select count(*) from pg_settings where name = 'support_batch_bind' and setting = 'on';";
                boolean flag = false;
                Statement stmt = null;
                ResultSet rs = null;
                try {
                    stmt = this.createStatement();
                    rs = stmt.executeQuery("select count(*) from pg_settings where name = 'support_batch_bind' and setting = 'on';");
                    while (rs.next()) {
                        if (rs.getInt(1) != 1) continue;
                        flag = true;
                    }
                }
                catch (SQLException e) {
                    LOGGER.trace("Failed to create statement or execute query, Error: " + e.getMessage());
                }
                finally {
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                    catch (SQLException e) {
                        LOGGER.trace("Failed to close resultset,Error:" + e.getMessage());
                    }
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (SQLException e) {
                        LOGGER.trace("Failed to close statement,Error:" + e.getMessage());
                    }
                }
                if (!flag) {
                    LOGGER.trace("WARNING, client suggest to use batch mode while the server is not supported");
                    this.batchInsert = false;
                }
            }
        } else if (batchString.equalsIgnoreCase("OFF")) {
            this.batchInsert = false;
        } else if (batchString.equalsIgnoreCase("ON")) {
            this.batchInsert = true;
        } else {
            LOGGER.trace("WARNING, unrecognized batchmode type");
            this.batchInsert = false;
        }
        this.initClientLogic(info);
    }

    private void initClientLogic(Properties info) throws SQLException {
        if (PGProperty.PG_CLIENT_LOGIC.get(info) != null && PGProperty.PG_CLIENT_LOGIC.get(info).equals("1")) {
            String autoBalance = info.getProperty("autoBalance");
            String targetType = info.getProperty("targetServerType");
            if (autoBalance != null && !autoBalance.equals("false") || targetType != null) {
                LOGGER.error("[client encryption] Failed connecting to client logic as autobalance or targetType is set");
                this.clientLogic = null;
                throw new PSQLException(GT.tr("Failed connecting to client logic", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE);
            }
            LOGGER.trace("Initiating client logic");
            try {
                this.clientLogic = new ClientLogic();
                String databaseName = PGProperty.PG_DBNAME.get(info);
                this.clientLogic.linkClientLogic(databaseName, this);
            }
            catch (ClientLogicException e) {
                this.clientLogic = null;
                LOGGER.error("Failed connecting to client logic");
                throw new PSQLException(GT.tr("Failed connecting to client logic" + e.getMessage(), new Object[0]), PSQLState.INVALID_PARAMETER_VALUE);
            }
        } else {
            LOGGER.trace("Client logic is off");
        }
    }

    private static Set<Integer> getBinaryOids(Properties info) throws PSQLException {
        boolean binaryTransfer = false;
        binaryTransfer = PGProperty.BINARY_TRANSFER.getBoolean(info);
        HashSet<Integer> binaryOids = new HashSet<Integer>(32);
        if (binaryTransfer) {
            binaryOids.add(17);
            binaryOids.add(21);
            binaryOids.add(23);
            binaryOids.add(20);
            binaryOids.add(700);
            binaryOids.add(701);
            binaryOids.add(1083);
            binaryOids.add(1082);
            binaryOids.add(1266);
            binaryOids.add(1114);
            binaryOids.add(1184);
            binaryOids.add(1005);
            binaryOids.add(1007);
            binaryOids.add(1016);
            binaryOids.add(1021);
            binaryOids.add(1022);
            binaryOids.add(1015);
            binaryOids.add(1009);
            binaryOids.add(600);
            binaryOids.add(603);
            binaryOids.add(2950);
        }
        binaryOids.addAll(PgConnection.getOidSet(PGProperty.BINARY_TRANSFER_ENABLE.get(info)));
        binaryOids.removeAll(PgConnection.getOidSet(PGProperty.BINARY_TRANSFER_DISABLE.get(info)));
        return binaryOids;
    }

    private static Set<Integer> getOidSet(String oidList) throws PSQLException {
        HashSet<Integer> oids = new HashSet<Integer>();
        StringTokenizer tokenizer = new StringTokenizer(oidList, ",");
        while (tokenizer.hasMoreTokens()) {
            String oid = tokenizer.nextToken();
            oids.add(Oid.valueOf(oid));
        }
        return oids;
    }

    private String oidsToString(Set<Integer> oids) {
        StringBuilder sb = new StringBuilder();
        for (Integer oid : oids) {
            sb.append(Oid.toString(oid));
            sb.append(',');
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        } else {
            sb.append(" <none>");
        }
        return sb.toString();
    }

    private String getConnectionInfo(boolean withExtraInfo, Properties info) {
        String connectionInfo = "";
        String gsVersion = null;
        String driverPath = null;
        String OSUser = null;
        String urlConfiguration = null;
        gsVersion = Driver.getGSVersion();
        if (withExtraInfo) {
            OSUser = System.getProperty("user.name");
            try {
                File jarDir = new File(Driver.class.getProtectionDomain().getCodeSource().getLocation().toURI());
                driverPath = jarDir.getCanonicalPath();
            }
            catch (IOException | IllegalArgumentException | URISyntaxException e) {
                driverPath = "";
                LOGGER.trace("Failed to make connection_info as there is an exception: " + e.getMessage());
            }
            urlConfiguration = this.reassembleUrl(info);
        }
        connectionInfo = "{\"driver_name\":\"JDBC\",\"driver_version\":\"" + gsVersion.replace("\"", "\\\"") + "\"";
        if (withExtraInfo && driverPath != null) {
            connectionInfo = connectionInfo + ",\"driver_path\":\"" + driverPath.replace("\\", "\\\\").replace("\"", "\\\"") + "\",\"os_user\":\"" + OSUser.replace("\"", "\\\"") + "\",\"urlConfiguration\":\"" + urlConfiguration.replace("\"", "\\\"") + "\"";
        }
        connectionInfo = connectionInfo + "}";
        return connectionInfo;
    }

    private String reassembleUrl(Properties info) {
        StringBuffer urlConfiguration = new StringBuffer();
        if (this.creatingURL.startsWith("jdbc:gbase:")) {
            urlConfiguration.append("jdbc:gbase://");
        } else if (this.creatingURL.startsWith("jdbc:dws:iam:")) {
            urlConfiguration.append("jdbc:dws:iam://");
        } else if (this.creatingURL.startsWith("jdbc:opengauss:")) {
            urlConfiguration.append("jdbc:opengauss://");
        } else {
            urlConfiguration.append("jdbc:gaussdb://");
        }
        String[] ports = info.getProperty("PGPORTURL").split(",");
        String[] hosts = info.getProperty("PGHOSTURL").split(",", ports.length);
        for (int i = 0; i < hosts.length; ++i) {
            urlConfiguration.append(hosts[i] + ":" + ports[i] + ",");
        }
        urlConfiguration.deleteCharAt(urlConfiguration.length() - 1);
        urlConfiguration.append("/" + info.getProperty("PGDBNAME") + "?");
        for (String propertyName : info.stringPropertyNames()) {
            if (CONNECTION_INFO_REPORT_BLACK_LIST.get(propertyName) != null) continue;
            urlConfiguration.append(propertyName + "=" + info.getProperty(propertyName) + "&");
        }
        urlConfiguration.deleteCharAt(urlConfiguration.length() - 1);
        return urlConfiguration.toString();
    }

    @Override
    public TimestampUtils getTimestampUtils() {
        return this.timestampUtils;
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, 1003, 1007);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.prepareCall(sql, 1003, 1007);
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        this.checkClosed();
        return this.typemap;
    }

    @Override
    public QueryExecutor getQueryExecutor() {
        return this.queryExecutor;
    }

    @Override
    public ReplicationProtocol getReplicationProtocol() {
        return this.queryExecutor.getReplicationProtocol();
    }

    public void addWarning(SQLWarning warn) {
        if (this.firstWarning != null) {
            this.firstWarning.setNextWarning(warn);
        } else {
            this.firstWarning = warn;
        }
    }

    @Override
    public ResultSet execSQLQuery(String s) throws SQLException {
        return this.execSQLQuery(s, 1003, 1007);
    }

    @Override
    public ResultSet execSQLQuery(String s, int resultSetType, int resultSetConcurrency) throws SQLException {
        BaseStatement stat = (BaseStatement)this.createStatement(resultSetType, resultSetConcurrency);
        boolean hasResultSet = stat.executeWithFlags(s, 16);
        while (!hasResultSet && stat.getUpdateCount() != -1) {
            hasResultSet = stat.getMoreResults();
        }
        if (!hasResultSet) {
            throw new PSQLException(GT.tr("No results were returned by the query.", new Object[0]), PSQLState.NO_DATA);
        }
        SQLWarning warnings = stat.getWarnings();
        if (warnings != null) {
            this.addWarning(warnings);
        }
        return stat.getResultSet();
    }

    @Override
    public void execSQLUpdate(String s) throws SQLException {
        BaseStatement stmt = (BaseStatement)this.createStatement();
        if (stmt.executeWithFlags(s, 22)) {
            throw new PSQLException(GT.tr("A result was returned when none was expected.", new Object[0]), PSQLState.TOO_MANY_RESULTS);
        }
        SQLWarning warnings = stmt.getWarnings();
        if (warnings != null) {
            this.addWarning(warnings);
        }
        stmt.close();
    }

    public void setCursorName(String cursor) throws SQLException {
        this.checkClosed();
    }

    public String getCursorName() throws SQLException {
        this.checkClosed();
        return null;
    }

    public String getURL() throws SQLException {
        return this.creatingURL;
    }

    public String getUserName() throws SQLException {
        return this.queryExecutor.getUser();
    }

    @Override
    public Fastpath getFastpathAPI() throws SQLException {
        this.checkClosed();
        if (this.fastpath == null) {
            this.fastpath = new Fastpath(this);
        }
        return this.fastpath;
    }

    @Override
    public LargeObjectManager getLargeObjectAPI() throws SQLException {
        this.checkClosed();
        if (this.largeobject == null) {
            this.largeobject = new LargeObjectManager(this);
        }
        return this.largeobject;
    }

    @Override
    public Object getObject(String type, String value, byte[] byteValue) throws SQLException {
        Class<?> c;
        if (this.typemap != null && (c = this.typemap.get(type)) != null) {
            throw new PSQLException(GT.tr("Custom type maps are not supported.", new Object[0]), PSQLState.NOT_IMPLEMENTED);
        }
        PGobject obj = null;
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Constructing object from type=" + type + " value=<" + value + ">");
        }
        try {
            Class<? extends PGobject> klass = this._typeCache.getPGobject(type);
            if (klass != null) {
                obj = klass.newInstance();
                obj.setType(type);
                if (byteValue != null && obj instanceof PGBinaryObject) {
                    PGBinaryObject binObj = (PGBinaryObject)((Object)obj);
                    binObj.setByteValue(byteValue, 0);
                } else {
                    obj.setValue(value);
                }
            } else {
                obj = new PGobject();
                obj.setType(type);
                obj.setValue(value);
            }
            return obj;
        }
        catch (SQLException sx) {
            throw sx;
        }
        catch (Exception ex) {
            throw new PSQLException(GT.tr("Failed to create object for: {0}.", type), PSQLState.CONNECTION_FAILURE, (Throwable)ex);
        }
    }

    protected TypeInfo createTypeInfo(BaseConnection conn, int unknownLength) {
        return new TypeInfoCache(conn, unknownLength);
    }

    @Override
    public TypeInfo getTypeInfo() {
        return this._typeCache;
    }

    @Override
    public void addDataType(String type, String name) {
        try {
            this.addDataType(type, Class.forName(name).asSubclass(PGobject.class));
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot register new type: " + e);
        }
    }

    @Override
    public void addDataType(String type, Class<? extends PGobject> klass) throws SQLException {
        this.checkClosed();
        this._typeCache.addDataType(type, klass);
    }

    private void initObjectTypes(Properties info) throws SQLException {
        this.addDataType("box", PGbox.class);
        this.addDataType("circle", PGcircle.class);
        this.addDataType("line", PGline.class);
        this.addDataType("lseg", PGlseg.class);
        this.addDataType("path", PGpath.class);
        this.addDataType("point", PGpoint.class);
        this.addDataType("polygon", PGpolygon.class);
        this.addDataType("money", PGmoney.class);
        this.addDataType("interval", PGInterval.class);
        Enumeration<?> e = info.propertyNames();
        while (e.hasMoreElements()) {
            Class<?> klass;
            String propertyName = (String)e.nextElement();
            if (!propertyName.startsWith("datatype.")) continue;
            String typeName = propertyName.substring(9);
            String className = info.getProperty(propertyName);
            try {
                klass = Class.forName(className);
            }
            catch (ClassNotFoundException cnfe) {
                throw new PSQLException(GT.tr("Unable to load the class {0} responsible for the datatype {1}", className, typeName), PSQLState.SYSTEM_ERROR, (Throwable)cnfe);
            }
            this.addDataType(typeName, klass.asSubclass(PGobject.class));
        }
    }

    @Override
    public ClientLogic getClientLogic() {
        return this.clientLogic;
    }

    @Override
    public void close() throws SQLException {
        if (this.clientLogic != null) {
            this.clientLogic.close();
            this.clientLogic = null;
        }
        if (this.queryExecutor == null) {
            return;
        }
        this.releaseTimer();
        this.queryExecutor.close();
        this.openStackTrace = null;
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.checkClosed();
        CachedQuery cachedQuery = this.queryExecutor.createQuery(sql, false, true, new String[0]);
        return cachedQuery.query.getNativeSql();
    }

    @Override
    public synchronized SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        SQLWarning newWarnings = this.queryExecutor.getWarnings();
        if (this.firstWarning == null) {
            this.firstWarning = newWarnings;
        } else {
            this.firstWarning.setNextWarning(newWarnings);
        }
        return this.firstWarning;
    }

    @Override
    public synchronized void clearWarnings() throws SQLException {
        this.checkClosed();
        this.queryExecutor.getWarnings();
        this.firstWarning = null;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.checkClosed();
        if (this.queryExecutor.getTransactionState() != TransactionState.IDLE) {
            throw new PSQLException(GT.tr("Cannot change transaction read-only property in the middle of a transaction.", new Object[0]), PSQLState.ACTIVE_SQL_TRANSACTION);
        }
        if (this.allowReadOnly) {
            if (readOnly != this.readOnly) {
                String readOnlySql = "SET SESSION CHARACTERISTICS AS TRANSACTION " + (readOnly ? "READ ONLY" : "READ WRITE");
                this.execSQLUpdate(readOnlySql);
            }
            this.readOnly = readOnly;
            LOGGER.debug("  setReadOnly = " + readOnly);
        } else {
            LOGGER.debug("Cannot change transaction read-only property when the property allowReadOnly is set to false");
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.checkClosed();
        return this.readOnly;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkClosed();
        if (this.autoCommit == autoCommit) {
            return;
        }
        if (!this.autoCommit) {
            this.commit();
        }
        this.autoCommit = autoCommit;
        LOGGER.debug("  setAutoCommit = " + autoCommit);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.checkClosed();
        return this.autoCommit;
    }

    private void executeTransactionCommand(Query query) throws SQLException {
        try {
            this.getQueryExecutor().execute(query, null, new TransactionCommandHandler(), 0, 0, 22);
        }
        catch (SQLException e) {
            if (query.getSubqueries() != null || !this.queryExecutor.willHealOnRetry(e)) {
                throw e;
            }
            query.close();
            this.getQueryExecutor().execute(query, null, new TransactionCommandHandler(), 0, 0, 22);
        }
    }

    @Override
    public void commit() throws SQLException {
        this.checkClosed();
        if (this.autoCommit) {
            throw new PSQLException(GT.tr("Cannot commit when autoCommit is enabled.", new Object[0]), PSQLState.NO_ACTIVE_SQL_TRANSACTION);
        }
        if (this.queryExecutor.getTransactionState() != TransactionState.IDLE) {
            this.executeTransactionCommand(this.commitQuery);
        }
    }

    protected void checkClosed() throws SQLException {
        if (this.isClosed()) {
            throw new PSQLException(GT.tr("This connection has been closed.", new Object[0]), PSQLState.CONNECTION_DOES_NOT_EXIST);
        }
    }

    @Override
    public void rollback() throws SQLException {
        this.checkClosed();
        if (this.autoCommit) {
            throw new PSQLException(GT.tr("Cannot rollback when autoCommit is enabled.", new Object[0]), PSQLState.NO_ACTIVE_SQL_TRANSACTION);
        }
        if (this.queryExecutor.getTransactionState() != TransactionState.IDLE) {
            this.executeTransactionCommand(this.rollbackQuery);
        }
    }

    @Override
    public TransactionState getTransactionState() {
        return this.queryExecutor.getTransactionState();
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.checkClosed();
        String level = null;
        ResultSet rs = this.execSQLQuery("SHOW TRANSACTION ISOLATION LEVEL");
        if (rs.next()) {
            level = rs.getString(1);
        }
        rs.close();
        if (level == null) {
            return 2;
        }
        if ((level = level.toUpperCase(Locale.US)).equals("READ COMMITTED")) {
            return 2;
        }
        if (level.equals("READ UNCOMMITTED")) {
            return 1;
        }
        if (level.equals("REPEATABLE READ")) {
            return 4;
        }
        if (level.equals("SERIALIZABLE")) {
            return 8;
        }
        return 2;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.checkClosed();
        if (this.queryExecutor.getTransactionState() != TransactionState.IDLE) {
            throw new PSQLException(GT.tr("Cannot change transaction isolation level in the middle of a transaction.", new Object[0]), PSQLState.ACTIVE_SQL_TRANSACTION);
        }
        String isolationLevelName = this.getIsolationLevelName(level);
        if (isolationLevelName == null) {
            throw new PSQLException(GT.tr("Transaction isolation level {0} not supported.", level), PSQLState.NOT_IMPLEMENTED);
        }
        String isolationLevelSQL = "SET SESSION CHARACTERISTICS AS TRANSACTION ISOLATION LEVEL " + isolationLevelName;
        this.execSQLUpdate(isolationLevelSQL);
        LOGGER.debug("  setTransactionIsolation = " + isolationLevelName);
    }

    protected String getIsolationLevelName(int level) {
        switch (level) {
            case 2: {
                return "READ COMMITTED";
            }
            case 8: {
                return "SERIALIZABLE";
            }
            case 1: {
                return "READ UNCOMMITTED";
            }
            case 4: {
                return "REPEATABLE READ";
            }
        }
        return null;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.checkClosed();
    }

    @Override
    public String getCatalog() throws SQLException {
        this.checkClosed();
        return this.queryExecutor.getDatabase();
    }

    protected void finalize() throws Throwable {
        if (this.openStackTrace != null) {
            LOGGER.warn(GT.tr("Finalizing a Connection that was never closed:", new Object[0]), this.openStackTrace);
        }
        this.close();
    }

    public String getDBVersionNumber() {
        return this.queryExecutor.getServerVersion();
    }

    public int getServerMajorVersion() {
        try {
            StringTokenizer versionTokens = new StringTokenizer(this.queryExecutor.getServerVersion(), ".");
            return PgConnection.integerPart(versionTokens.nextToken());
        }
        catch (NoSuchElementException e) {
            return 0;
        }
    }

    public int getServerMinorVersion() {
        try {
            StringTokenizer versionTokens = new StringTokenizer(this.queryExecutor.getServerVersion(), ".");
            versionTokens.nextToken();
            return PgConnection.integerPart(versionTokens.nextToken());
        }
        catch (NoSuchElementException e) {
            return 0;
        }
    }

    @Override
    public boolean haveMinimumServerVersion(int ver) {
        return this.queryExecutor.getServerVersionNum() >= ver;
    }

    @Override
    public boolean haveMinimumServerVersion(Version ver) {
        return this.haveMinimumServerVersion(ver.getVersionNum());
    }

    @Override
    public Encoding getEncoding() {
        return this.queryExecutor.getEncoding();
    }

    @Override
    public byte[] encodeString(String str) throws SQLException {
        try {
            return this.getEncoding().encode(str);
        }
        catch (IOException ioe) {
            throw new PSQLException(GT.tr("Unable to translate data into the desired encoding.", new Object[0]), PSQLState.DATA_ERROR, (Throwable)ioe);
        }
    }

    @Override
    public String escapeString(String str) throws SQLException {
        return Utils.escapeLiteral(null, str, this.queryExecutor.getStandardConformingStrings()).toString();
    }

    @Override
    public boolean getStandardConformingStrings() {
        return this.queryExecutor.getStandardConformingStrings();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.queryExecutor.isClosed();
    }

    @Override
    public void cancelQuery() throws SQLException {
        this.checkClosed();
        try {
            this.queryExecutor.sendQueryCancel();
        }
        catch (SQLException e) {
            this.queryExecutor.close();
        }
    }

    @Override
    public PGNotification[] getNotifications() throws SQLException {
        return this.getNotifications(-1);
    }

    @Override
    public PGNotification[] getNotifications(int timeoutMillis) throws SQLException {
        this.checkClosed();
        this.getQueryExecutor().processNotifies(timeoutMillis);
        PGNotification[] notifications = this.queryExecutor.getNotifications();
        return notifications.length == 0 ? null : notifications;
    }

    @Override
    public boolean getBitToString() {
        return this.bitToString;
    }

    @Override
    public int getPrepareThreshold() {
        return this.prepareThreshold;
    }

    @Override
    public void setDefaultFetchSize(int fetchSize) throws SQLException {
        if (fetchSize < 0) {
            throw new PSQLException(GT.tr("Fetch size must be a value greater to or equal to 0.", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE);
        }
        this.defaultFetchSize = fetchSize;
    }

    @Override
    public int getDefaultFetchSize() {
        return this.defaultFetchSize;
    }

    @Override
    public void setPrepareThreshold(int newThreshold) {
        this.prepareThreshold = newThreshold;
    }

    public boolean getForceBinary() {
        return this.forcebinary;
    }

    public void setForceBinary(boolean newValue) {
        this.forcebinary = newValue;
    }

    public void setTypeMapImpl(Map<String, Class<?>> map) throws SQLException {
        this.typemap = map;
    }

    @Override
    public Log getLogger() {
        return LOGGER;
    }

    public int getProtocolVersion() {
        return this.queryExecutor.getProtocolVersion();
    }

    @Override
    public boolean getStringVarcharFlag() {
        return this.bindStringAsVarchar;
    }

    @Override
    public CopyManager getCopyAPI() throws SQLException {
        this.checkClosed();
        if (this.copyManager == null) {
            this.copyManager = new CopyManager(this);
        }
        return this.copyManager;
    }

    @Override
    public boolean binaryTransferSend(int oid) {
        return this.queryExecutor.useBinaryForSend(oid);
    }

    @Override
    public boolean isColumnSanitiserDisabled() {
        return this.disableColumnSanitiser;
    }

    public void setDisableColumnSanitiser(boolean disableColumnSanitiser) {
        this.disableColumnSanitiser = disableColumnSanitiser;
        LOGGER.debug("  setDisableColumnSanitiser = " + disableColumnSanitiser);
    }

    @Override
    public PreferQueryMode getPreferQueryMode() {
        return this.queryExecutor.getPreferQueryMode();
    }

    @Override
    public AutoSave getAutosave() {
        return this.queryExecutor.getAutoSave();
    }

    @Override
    public void setAutosave(AutoSave autoSave) {
        this.queryExecutor.setAutoSave(autoSave);
        LOGGER.debug("  setAutosave = " + autoSave.value());
    }

    protected void abort() {
        this.queryExecutor.abort();
    }

    private synchronized Timer getTimer() {
        if (this.cancelTimer == null) {
            this.cancelTimer = Driver.getSharedTimer().getTimer();
        }
        return this.cancelTimer;
    }

    private synchronized void releaseTimer() {
        if (this.cancelTimer != null) {
            this.cancelTimer = null;
            Driver.getSharedTimer().releaseTimer();
        }
    }

    @Override
    public void addTimerTask(TimerTask timerTask, long milliSeconds) {
        Timer timer = this.getTimer();
        timer.schedule(timerTask, milliSeconds);
    }

    @Override
    public void purgeTimerTasks() {
        Timer timer = this.cancelTimer;
        if (timer != null) {
            timer.purge();
        }
    }

    @Override
    public String escapeIdentifier(String identifier) throws SQLException {
        return Utils.escapeIdentifier(null, identifier).toString();
    }

    @Override
    public String escapeLiteral(String literal) throws SQLException {
        return Utils.escapeLiteral(null, literal, this.queryExecutor.getStandardConformingStrings()).toString();
    }

    @Override
    public LruCache<FieldMetadata.Key, FieldMetadata> getFieldMetadataCache() {
        return this.fieldMetadataCache;
    }

    @Override
    public PGReplicationConnection getReplicationAPI() {
        return new PGReplicationConnectionImpl(this);
    }

    private static void appendArray(StringBuilder sb, Object elements, char delim) {
        sb.append('{');
        int nElements = Array.getLength(elements);
        for (int i = 0; i < nElements; ++i) {
            Object o;
            if (i > 0) {
                sb.append(delim);
            }
            if ((o = Array.get(elements, i)) == null) {
                sb.append("NULL");
                continue;
            }
            if (o.getClass().isArray()) {
                PrimitiveArraySupport<Object> arraySupport = PrimitiveArraySupport.getArraySupport(o);
                if (arraySupport != null) {
                    arraySupport.appendArray(sb, delim, o);
                    continue;
                }
                PgConnection.appendArray(sb, o, delim);
                continue;
            }
            String s = o.toString();
            PgArray.escapeArrayElement(sb, s);
        }
        sb.append('}');
    }

    private static int integerPart(String dirtyString) {
        int end;
        int start;
        for (start = 0; start < dirtyString.length() && !Character.isDigit(dirtyString.charAt(start)); ++start) {
        }
        for (end = start; end < dirtyString.length() && Character.isDigit(dirtyString.charAt(end)); ++end) {
        }
        if (start == end) {
            return 0;
        }
        return Integer.parseInt(dirtyString.substring(start, end));
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        return new PgStatement(this, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        return new PgPreparedStatement(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        return new PgCallableStatement(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkClosed();
        if (this.metadata == null) {
            this.metadata = new PgDatabaseMetaData(this);
        }
        return this.metadata;
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.setTypeMapImpl(map);
        LOGGER.debug("  setTypeMap = " + map);
    }

    protected java.sql.Array makeArray(int oid, String fieldString) throws SQLException {
        return new PgArray((BaseConnection)this, oid, fieldString);
    }

    protected Blob makeBlob(long oid) throws SQLException {
        return new PgBlob(this, oid);
    }

    protected Clob makeClob(long oid) throws SQLException {
        return new PgClob(this, oid);
    }

    protected SQLXML makeSQLXML() throws SQLException {
        return new PgSQLXML(this);
    }

    @Override
    public Clob createClob() throws SQLException {
        this.checkClosed();
        return new PGClob();
    }

    @Override
    public Blob createBlob() throws SQLException {
        this.checkClosed();
        return new PGBlob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        this.checkClosed();
        throw Driver.notImplemented(this.getClass(), "createNClob()");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        this.checkClosed();
        return this.makeSQLXML();
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        this.checkClosed();
        throw Driver.notImplemented(this.getClass(), "createStruct(String, Object[])");
    }

    @Override
    public java.sql.Array createArrayOf(String typeName, Object elements) throws SQLException {
        String arrayString;
        this.checkClosed();
        TypeInfo typeInfo = this.getTypeInfo();
        int oid = typeInfo.getPGArrayType(typeName);
        char delim = typeInfo.getArrayDelimiter(oid);
        if (oid == 0) {
            throw new PSQLException(GT.tr("Unable to find server array type for provided name {0}.", typeName), PSQLState.INVALID_NAME);
        }
        if (elements == null) {
            return this.makeArray(oid, null);
        }
        PrimitiveArraySupport<Object> arraySupport = PrimitiveArraySupport.getArraySupport(elements);
        if (arraySupport != null) {
            if (oid == arraySupport.getDefaultArrayTypeOid(typeInfo) && arraySupport.supportBinaryRepresentation() && this.getPreferQueryMode() != PreferQueryMode.SIMPLE) {
                return new PgArray((BaseConnection)this, oid, arraySupport.toBinaryRepresentation(this, elements));
            }
            arrayString = arraySupport.toArrayString(delim, elements);
        } else {
            Class<?> clazz = elements.getClass();
            if (!clazz.isArray()) {
                throw new PSQLException(GT.tr("Invalid elements {0}", elements), PSQLState.INVALID_PARAMETER_TYPE);
            }
            StringBuilder sb = new StringBuilder();
            PgConnection.appendArray(sb, elements, delim);
            arrayString = sb.toString();
        }
        return this.makeArray(oid, arrayString);
    }

    @Override
    public java.sql.Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        this.checkClosed();
        int oid = this.getTypeInfo().getPGArrayType(typeName);
        if (oid == 0) {
            throw new PSQLException(GT.tr("Unable to find server array type for provided name {0}.", typeName), PSQLState.INVALID_NAME);
        }
        if (elements == null) {
            return this.makeArray(oid, null);
        }
        char delim = this.getTypeInfo().getArrayDelimiter(oid);
        StringBuilder sb = new StringBuilder();
        PgConnection.appendArray(sb, elements, delim);
        return this.makeArray(oid, sb.toString());
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        if (timeout < 0) {
            throw new PSQLException(GT.tr("Invalid timeout ({0}<0).", timeout), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (this.isClosed()) {
            return false;
        }
        try {
            if (this.replicationConnection) {
                Statement statement = this.createStatement();
                statement.execute("IDENTIFY_SYSTEM");
                statement.close();
            } else {
                if (this.checkConnectionQuery == null) {
                    this.checkConnectionQuery = this.prepareStatement("");
                }
                this.checkConnectionQuery.setQueryTimeout(timeout);
                this.checkConnectionQuery.executeUpdate();
            }
            return true;
        }
        catch (SQLException e) {
            if (PSQLState.IN_FAILED_SQL_TRANSACTION.getState().equals(e.getSQLState())) {
                return true;
            }
            LOGGER.debug(GT.tr("Validating connection.", new Object[0]), e);
            return false;
        }
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        try {
            this.checkClosed();
        }
        catch (SQLException cause) {
            HashMap<String, ClientInfoStatus> failures = new HashMap<String, ClientInfoStatus>();
            failures.put(name, ClientInfoStatus.REASON_UNKNOWN);
            throw new SQLClientInfoException(GT.tr("This connection has been closed.", new Object[0]), failures, (Throwable)cause);
        }
        if (this.haveMinimumServerVersion(ServerVersion.v9_0) && "ApplicationName".equals(name) || "ApplicationType".equals(name)) {
            String oldValue;
            HashMap<String, String> appInfo = new HashMap<String, String>();
            appInfo.put("ApplicationName", "application_name");
            appInfo.put("ApplicationType", "application_type");
            if (value == null) {
                value = "";
            }
            String string = oldValue = "ApplicationName".equals(name) ? this.queryExecutor.getApplicationName() : this.queryExecutor.getApplicationType();
            if (value.equals(oldValue)) {
                return;
            }
            try {
                StringBuilder sql = new StringBuilder(String.format("SET %s = '", appInfo.get(name)));
                Utils.escapeLiteral(sql, value, this.getStandardConformingStrings());
                sql.append("'");
                this.execSQLUpdate(sql.toString());
            }
            catch (SQLException sqle) {
                HashMap<String, ClientInfoStatus> failures = new HashMap<String, ClientInfoStatus>();
                failures.put(name, ClientInfoStatus.REASON_UNKNOWN);
                throw new SQLClientInfoException(GT.tr("Failed to set ClientInfo property: " + name, new Object[0]), sqle.getSQLState(), failures, (Throwable)sqle);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("  setClientInfo = " + name + " " + value);
            }
            this._clientInfo.put(name, value);
            return;
        }
        this.addWarning(new SQLWarning(GT.tr("ClientInfo property not supported.", new Object[0]), PSQLState.NOT_IMPLEMENTED.getState()));
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        try {
            this.checkClosed();
        }
        catch (SQLException cause) {
            HashMap<String, ClientInfoStatus> failures = new HashMap<String, ClientInfoStatus>();
            for (Map.Entry<Object, Object> e : properties.entrySet()) {
                failures.put((String)e.getKey(), ClientInfoStatus.REASON_UNKNOWN);
            }
            throw new SQLClientInfoException(GT.tr("This connection has been closed.", new Object[0]), failures, (Throwable)cause);
        }
        String gaussdbVersion = this.queryExecutor.getGaussdbVersion();
        String[] result = gaussdbVersion.equals("GaussDBKernel") ? new String[]{"ApplicationName", "ApplicationType"} : new String[]{"ApplicationName"};
        HashMap<String, ClientInfoStatus> failures = new HashMap<String, ClientInfoStatus>();
        for (String name : result) {
            try {
                if ("ApplicationType".equals(name) && properties.getProperty(name) == null) continue;
                this.setClientInfo(name, properties.getProperty(name, null));
            }
            catch (SQLClientInfoException e) {
                failures.putAll(e.getFailedProperties());
            }
        }
        if (!failures.isEmpty()) {
            throw new SQLClientInfoException(GT.tr("One or more ClientInfo failed.", new Object[0]), PSQLState.NOT_IMPLEMENTED.getState(), failures);
        }
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        this.checkClosed();
        this._clientInfo.put("ApplicationName", this.queryExecutor.getApplicationName());
        this._clientInfo.put("ApplicationType", this.queryExecutor.getApplicationType());
        return this._clientInfo.getProperty(name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.checkClosed();
        this._clientInfo.put("ApplicationName", this.queryExecutor.getApplicationName());
        this._clientInfo.put("ApplicationType", this.queryExecutor.getApplicationType());
        return this._clientInfo;
    }

    public <T> T createQueryObject(Class<T> ifc) throws SQLException {
        this.checkClosed();
        throw Driver.notImplemented(this.getClass(), "createQueryObject(Class<T>)");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        this.checkClosed();
        return iface.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        this.checkClosed();
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        throw Driver.notImplemented(this.getClass(), "unwrap(Class<T>)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSchema() throws SQLException {
        this.checkClosed();
        try (Statement stmt = this.createStatement();){
            ResultSet rs;
            block8: {
                String string;
                rs = stmt.executeQuery("select current_schema()");
                try {
                    if (rs.next()) break block8;
                    string = null;
                }
                catch (Throwable throwable) {
                    rs.close();
                    throw throwable;
                }
                rs.close();
                return string;
            }
            String string = rs.getString(1);
            rs.close();
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSchema(String schema) throws SQLException {
        this.checkClosed();
        try (Statement stmt = this.createStatement();){
            if (schema == null) {
                stmt.executeUpdate("SET SESSION search_path TO DEFAULT");
            } else {
                StringBuilder sb = new StringBuilder();
                sb.append("SET SESSION search_path TO '");
                Utils.escapeLiteral(sb, schema, this.getStandardConformingStrings());
                sb.append("'");
                stmt.executeUpdate(sb.toString());
                LOGGER.debug("  setSchema = " + schema);
            }
        }
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        if (this.isClosed()) {
            return;
        }
        SQL_PERMISSION_ABORT.checkGuard(this);
        AbortCommand command = new AbortCommand();
        if (executor != null) {
            executor.execute(command);
        } else {
            command.run();
        }
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.checkClosed();
        if (milliseconds < 0) {
            throw new PSQLException(GT.tr("Network timeout must be a value greater than or equal to 0.", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE);
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SQL_PERMISSION_NETWORK_TIMEOUT);
        }
        try {
            this.queryExecutor.setNetworkTimeout(milliseconds);
        }
        catch (IOException ioe) {
            throw new PSQLException(GT.tr("Unable to set network timeout.", new Object[0]), PSQLState.COMMUNICATION_ERROR, (Throwable)ioe);
        }
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        this.checkClosed();
        try {
            return this.queryExecutor.getNetworkTimeout();
        }
        catch (IOException ioe) {
            throw new PSQLException(GT.tr("Unable to get network timeout.", new Object[0]), PSQLState.COMMUNICATION_ERROR, (Throwable)ioe);
        }
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.checkClosed();
        switch (holdability) {
            case 2: {
                this.rsHoldability = holdability;
                break;
            }
            case 1: {
                this.rsHoldability = holdability;
                break;
            }
            default: {
                throw new PSQLException(GT.tr("Unknown ResultSet holdability setting: {0}.", holdability), PSQLState.INVALID_PARAMETER_VALUE);
            }
        }
        LOGGER.debug("  setHoldability = " + holdability);
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkClosed();
        return this.rsHoldability;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.checkClosed();
        if (this.getAutoCommit()) {
            throw new PSQLException(GT.tr("Cannot establish a savepoint in auto-commit mode.", new Object[0]), PSQLState.NO_ACTIVE_SQL_TRANSACTION);
        }
        PSQLSavepoint savepoint = new PSQLSavepoint(this.savepointId++);
        String pgName = savepoint.getPGName();
        Statement stmt = this.createStatement();
        stmt.executeUpdate("SAVEPOINT " + pgName);
        stmt.close();
        return savepoint;
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        this.checkClosed();
        if (this.getAutoCommit()) {
            throw new PSQLException(GT.tr("Cannot establish a savepoint in auto-commit mode.", new Object[0]), PSQLState.NO_ACTIVE_SQL_TRANSACTION);
        }
        PSQLSavepoint savepoint = new PSQLSavepoint(name);
        Statement stmt = this.createStatement();
        stmt.executeUpdate("SAVEPOINT " + savepoint.getPGName());
        stmt.close();
        return savepoint;
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.checkClosed();
        PSQLSavepoint pgSavepoint = (PSQLSavepoint)savepoint;
        this.execSQLUpdate("ROLLBACK TO SAVEPOINT " + pgSavepoint.getPGName());
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.checkClosed();
        PSQLSavepoint pgSavepoint = (PSQLSavepoint)savepoint;
        this.execSQLUpdate("RELEASE SAVEPOINT " + pgSavepoint.getPGName());
        pgSavepoint.invalidate();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkClosed();
        return this.createStatement(resultSetType, resultSetConcurrency, this.getHoldability());
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkClosed();
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency, this.getHoldability());
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkClosed();
        return this.prepareCall(sql, resultSetType, resultSetConcurrency, this.getHoldability());
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        if (autoGeneratedKeys != 1) {
            return this.prepareStatement(sql);
        }
        return this.prepareStatement(sql, (String[])null);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        if (columnIndexes != null && columnIndexes.length == 0) {
            return this.prepareStatement(sql);
        }
        this.checkClosed();
        throw new PSQLException(GT.tr("Returning autogenerated keys is not supported.", new Object[0]), PSQLState.NOT_IMPLEMENTED);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        if (columnNames != null && columnNames.length == 0) {
            return this.prepareStatement(sql);
        }
        CachedQuery cachedQuery = this.borrowReturningQuery(sql, columnNames);
        PgPreparedStatement ps = new PgPreparedStatement(this, cachedQuery, 1003, 1007, this.getHoldability());
        Query query = cachedQuery.query;
        SqlCommand sqlCommand = query.getSqlCommand();
        if (sqlCommand != null) {
            ps.wantsGeneratedKeysAlways = sqlCommand.isReturningKeywordPresent();
        }
        return ps;
    }

    @Override
    public PGXmlFactoryFactory getXmlFactoryFactory() throws SQLException {
        if (this.xmlFactoryFactory == null) {
            if (this.xmlFactoryFactoryClass == null || this.xmlFactoryFactoryClass.equals("")) {
                this.xmlFactoryFactory = DefaultPGXmlFactoryFactory.INSTANCE;
            } else if (this.xmlFactoryFactoryClass.equals("LEGACY_INSECURE")) {
                this.xmlFactoryFactory = LegacyInsecurePGXmlFactoryFactory.INSTANCE;
            } else {
                Class<PGXmlFactoryFactory> clazz;
                try {
                    clazz = Class.forName(this.xmlFactoryFactoryClass);
                }
                catch (ClassNotFoundException ex) {
                    throw new PSQLException(GT.tr("Could not instantiate xmlFactoryFactory: {0}", this.xmlFactoryFactoryClass), PSQLState.INVALID_PARAMETER_VALUE, (Throwable)ex);
                }
                if (!clazz.isAssignableFrom(PGXmlFactoryFactory.class)) {
                    throw new PSQLException(GT.tr("Connection property xmlFactoryFactory must implement PGXmlFactoryFactory: {0}", this.xmlFactoryFactoryClass), PSQLState.INVALID_PARAMETER_VALUE);
                }
                try {
                    this.xmlFactoryFactory = (PGXmlFactoryFactory)clazz.newInstance();
                }
                catch (Exception ex) {
                    throw new PSQLException(GT.tr("Could not instantiate xmlFactoryFactory: {0}", this.xmlFactoryFactoryClass), PSQLState.INVALID_PARAMETER_VALUE, (Throwable)ex);
                }
            }
        }
        return this.xmlFactoryFactory;
    }

    public boolean isBatchInsert() {
        return this.batchInsert;
    }

    public boolean isBlobMode() {
        return this.blobmode;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    @Override
    public String getSocketAddress() {
        return this.socketAddress;
    }

    @Override
    public AtomicReferenceFieldUpdater<PgStatement, TimerTask> getTimerUpdater() {
        return this.CANCEL_TIMER_UPDATER;
    }

    static {
        CONNECTION_INFO_REPORT_BLACK_LIST.put("user", "");
        CONNECTION_INFO_REPORT_BLACK_LIST.put("sslcert", "");
        CONNECTION_INFO_REPORT_BLACK_LIST.put("password", "");
        CONNECTION_INFO_REPORT_BLACK_LIST.put("sslkey", "");
        CONNECTION_INFO_REPORT_BLACK_LIST.put("sslpassword", "");
        CONNECTION_INFO_REPORT_BLACK_LIST.put("PGHOSTURL", "");
        CONNECTION_INFO_REPORT_BLACK_LIST.put("PGPORTURL", "");
        CONNECTION_INFO_REPORT_BLACK_LIST.put("PGPORT", "");
        CONNECTION_INFO_REPORT_BLACK_LIST.put("PGHOST", "");
        CONNECTION_INFO_REPORT_BLACK_LIST.put("PGDBNAME", "");
    }

    public class AbortCommand
    implements Runnable {
        @Override
        public void run() {
            PgConnection.this.abort();
        }
    }

    private class TransactionCommandHandler
    extends ResultHandlerBase {
        private TransactionCommandHandler() {
        }

        @Override
        public void handleCompletion() throws SQLException {
            SQLWarning warning = this.getWarning();
            if (warning != null) {
                PgConnection.this.addWarning(warning);
            }
            super.handleCompletion();
        }
    }
}

