/*
 * Decompiled with CFR 0.152.
 */
package org.gbase.quickautobalance;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Objects;
import java.util.Properties;
import org.gbase.PGProperty;
import org.gbase.core.QueryExecutor;
import org.gbase.core.SetupQueryRunner;
import org.gbase.jdbc.PgConnection;
import org.gbase.jdbc.StatementCancelState;
import org.gbase.log.Log;
import org.gbase.log.Logger;
import org.gbase.util.GT;
import org.gbase.util.HostSpec;
import org.gbase.util.PSQLException;
import org.gbase.util.PSQLState;

public class ConnectionInfo {
    public static final long DEFAULT_MAX_IDLE_TIME_BEFORE_TERMINAL = 30L;
    public static final String ENABLE_QUICK_AUTO_BALANCE_PARAMS = "true";
    private static final long MAX_IDLE_TIME_BEFORE_TERMINAL_MAX_VALUE = 9223372036854775L;
    private static Log LOGGER = Logger.getLogger(ConnectionInfo.class.getName());
    private final PgConnection pgConnection;
    private final long createTimeStamp;
    private final String autoBalance;
    private boolean enableQuickAutoBalance;
    private long maxIdleTimeBeforeTerminal;
    private final HostSpec hostSpec;
    private volatile StatementCancelState connectionState;
    private volatile long stateLastChangedTimeStamp;

    public int hashCode() {
        return Objects.hash(this.pgConnection, this.createTimeStamp, this.autoBalance, this.enableQuickAutoBalance, this.maxIdleTimeBeforeTerminal, this.hostSpec);
    }

    public ConnectionInfo(PgConnection pgConnection, Properties properties, HostSpec hostSpec) throws PSQLException {
        this.pgConnection = pgConnection;
        this.connectionState = StatementCancelState.IDLE;
        this.stateLastChangedTimeStamp = this.createTimeStamp = System.currentTimeMillis();
        this.autoBalance = properties.getProperty("autoBalance", "");
        this.maxIdleTimeBeforeTerminal = 30L;
        this.hostSpec = hostSpec;
        this.maxIdleTimeBeforeTerminal = ConnectionInfo.parseMaxIdleTimeBeforeTerminal(properties);
        this.enableQuickAutoBalance = ConnectionInfo.parseEnableQuickAutoBalance(properties);
    }

    public static boolean parseEnableQuickAutoBalance(Properties properties) throws PSQLException {
        if (EnableQuickAutoBalanceParams.TRUE.getValue().equals(PGProperty.ENABLE_QUICK_AUTO_BALANCE.get(properties))) {
            return true;
        }
        if (EnableQuickAutoBalanceParams.FALSE.getValue().equals(PGProperty.ENABLE_QUICK_AUTO_BALANCE.get(properties))) {
            return false;
        }
        throw new PSQLException(GT.tr("Parameter enableQuickAutoBalance={0} parsed failed, value range: '{true, false'}).", PGProperty.ENABLE_QUICK_AUTO_BALANCE.get(properties)), PSQLState.INVALID_PARAMETER_VALUE);
    }

    public static long parseMaxIdleTimeBeforeTerminal(Properties properties) throws PSQLException {
        long inputMaxIdleTime;
        try {
            String param = PGProperty.MAX_IDLE_TIME_BEFORE_TERMINAL.get(properties);
            inputMaxIdleTime = Long.parseLong(param);
            if (inputMaxIdleTime >= 9223372036854775L) {
                throw new PSQLException(GT.tr("Parameter maxIdleTimeBeforeTerminal={0} can not be bigger than {1}, value range: long & [0,{1}).", inputMaxIdleTime, 9223372036854775L), PSQLState.INVALID_PARAMETER_VALUE);
            }
            if (inputMaxIdleTime < 0L) {
                throw new PSQLException(GT.tr("Parameter maxIdleTimeBeforeTerminal={0} can not be less than 0, value range: long & [0,{1}).", inputMaxIdleTime, 9223372036854775L), PSQLState.INVALID_PARAMETER_VALUE);
            }
        }
        catch (NumberFormatException e) {
            throw new PSQLException(GT.tr("Parameter maxIdleTimeBeforeTerminal parsed failed, value range: long & [0,{0}).", 9223372036854775L), PSQLState.INVALID_PARAMETER_TYPE);
        }
        return inputMaxIdleTime;
    }

    public StatementCancelState getConnectionState() {
        return this.connectionState;
    }

    public synchronized void setConnectionState(StatementCancelState state) {
        if (state != null && !this.connectionState.equals((Object)state)) {
            this.connectionState = state;
            this.stateLastChangedTimeStamp = System.currentTimeMillis();
        }
    }

    public long getMaxIdleTimeBeforeTerminal() {
        return this.maxIdleTimeBeforeTerminal;
    }

    public String getAutoBalance() {
        return this.autoBalance;
    }

    public PgConnection getPgConnection() {
        return this.pgConnection;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectionInfo that = (ConnectionInfo)o;
        return this.createTimeStamp == that.createTimeStamp && this.enableQuickAutoBalance == that.enableQuickAutoBalance && this.maxIdleTimeBeforeTerminal == that.maxIdleTimeBeforeTerminal && this.pgConnection.equals(that.pgConnection) && this.autoBalance.equals(that.autoBalance) && this.hostSpec.equals(that.hostSpec);
    }

    public synchronized boolean checkConnectionCanBeClosed(long quickAutoBalanceStartTime) {
        if (this.pgConnection == null) {
            return false;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(GT.tr("checkConnectionCanBeClosed: server ip={0}, enableQuickAutoBalance={1}, quickAutoBalanceStartTime={2}, createTimeStamp={3}, connectionState={4}, stateLastChangedTimeStamp={5}, currentTimeMillis={6}", new Object[]{this.hostSpec.toString(), this.isEnableQuickAutoBalance(), quickAutoBalanceStartTime, this.createTimeStamp, this.connectionState, this.stateLastChangedTimeStamp, System.currentTimeMillis()}));
        }
        if (!this.isEnableQuickAutoBalance()) {
            return false;
        }
        if (quickAutoBalanceStartTime < this.createTimeStamp) {
            return false;
        }
        if (!this.connectionState.equals((Object)StatementCancelState.IDLE)) {
            return false;
        }
        return System.currentTimeMillis() - this.stateLastChangedTimeStamp > this.maxIdleTimeBeforeTerminal * 1000L;
    }

    public boolean isEnableQuickAutoBalance() {
        return this.enableQuickAutoBalance;
    }

    public boolean checkConnectionIsValid() {
        boolean isConnectionValid;
        try {
            QueryExecutor queryExecutor = this.pgConnection.getQueryExecutor();
            byte[][] bit = SetupQueryRunner.run(queryExecutor, "select 1", true);
            if (bit == null) {
                return false;
            }
            String result = queryExecutor.getEncoding().decode(bit[0]);
            isConnectionValid = result != null && result.equals("1");
        }
        catch (IOException | SQLException e) {
            LOGGER.info(GT.tr("Check connection isValid failed.", new Object[0]));
            isConnectionValid = false;
        }
        return isConnectionValid;
    }

    public HostSpec getHostSpec() {
        return this.hostSpec;
    }

    static enum EnableQuickAutoBalanceParams {
        TRUE("true"),
        FALSE("false");

        private final String value;

        private EnableQuickAutoBalanceParams(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

