/*
 * Decompiled with CFR 0.152.
 */
package org.gbase.quickautobalance;

import java.util.List;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.gbase.PGProperty;
import org.gbase.log.Log;
import org.gbase.log.Logger;
import org.gbase.quickautobalance.ConnectionManager;
import org.gbase.util.GT;

public class LoadBalanceHeartBeating {
    private static final int INITIAL_DELAY = 1000;
    private static final int CHECK_CLUSTER_STATE_PERIOD = 20000;
    private static final int CLOSE_CONNECTION_PERIOD = 5000;
    private static final ScheduledExecutorService checkClusterStateScheduledExecutorService = Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, "loadBalanceHeartBeatingThread"));
    private static final ScheduledExecutorService closeConnectionExecutorService = Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, "closeConnectionsHeartBeatingThread"));
    private static Log LOGGER = Logger.getLogger(LoadBalanceHeartBeating.class.getName());
    private static volatile ScheduledFuture<?> checkClusterStateScheduledFuture = null;
    private static volatile ScheduledFuture<?> closeConnectionScheduledFuture = null;
    private static volatile boolean leastConnStarted = false;
    private static volatile boolean quickAutoBalanceStarted = false;

    public static boolean isLoadBalanceHeartBeatingStarted() {
        return leastConnStarted && quickAutoBalanceStarted;
    }

    public static boolean isQuickAutoBalanceStarted() {
        return quickAutoBalanceStarted;
    }

    public static boolean isLeastConnStarted() {
        return leastConnStarted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void startScheduledExecutorService(Properties properties) {
        Class<LoadBalanceHeartBeating> clazz;
        if (!leastConnStarted && ConnectionManager.checkEnableLeastConn(properties)) {
            clazz = LoadBalanceHeartBeating.class;
            // MONITORENTER : org.gbase.quickautobalance.LoadBalanceHeartBeating.class
            if (!leastConnStarted) {
                leastConnStarted = true;
                checkClusterStateScheduledFuture = checkClusterStateScheduledExecutorService.scheduleAtFixedRate(LoadBalanceHeartBeating::checkClusterStateScheduleTask, 1000L, 20000L, TimeUnit.MILLISECONDS);
                LOGGER.info(GT.tr("Start scheduleExecutorService, period:{0} milliseconds.", 20000));
            }
            // MONITOREXIT : clazz
        }
        if (quickAutoBalanceStarted) return;
        if (!ConnectionManager.checkEnableLeastConn(properties)) return;
        if (!"true".equals(PGProperty.ENABLE_QUICK_AUTO_BALANCE.get(properties))) return;
        clazz = LoadBalanceHeartBeating.class;
        // MONITORENTER : org.gbase.quickautobalance.LoadBalanceHeartBeating.class
        if (!quickAutoBalanceStarted) {
            quickAutoBalanceStarted = true;
            closeConnectionScheduledFuture = closeConnectionExecutorService.scheduleAtFixedRate(LoadBalanceHeartBeating::closeAbandonedConnections, 1000L, 5000L, TimeUnit.MILLISECONDS);
            LOGGER.info(GT.tr("Start closeConnectionScheduledFuture, period:{0} milliseconds.", 5000));
        }
        // MONITOREXIT : clazz
    }

    private static void checkClusterStateScheduleTask() {
        LoadBalanceHeartBeating.checkClusterState();
        LoadBalanceHeartBeating.checkConnectionValidity();
    }

    private static void closeAbandonedConnections() {
        List<Integer> closedConnections = ConnectionManager.getInstance().closeConnections();
        int sum = closedConnections.stream().mapToInt(Integer::intValue).sum();
        LOGGER.info(GT.tr("Scheduled task: closeAbandonedConnections(), thread id: {0}, amount of closed connections: {1}.", Thread.currentThread().getId(), sum));
    }

    private static void checkClusterState() {
        int invalidDataNodes = ConnectionManager.getInstance().checkClusterStates();
        LOGGER.info(GT.tr("Scheduled task: checkClusterState(), thread id: {0}, amount of invalid data nodes: {1}.", Thread.currentThread().getId(), invalidDataNodes));
    }

    private static void checkConnectionValidity() {
        List<Integer> removes = ConnectionManager.getInstance().checkConnectionsValidity();
        int sum = removes.stream().mapToInt(Integer::intValue).sum();
        LOGGER.info(GT.tr("Scheduled task: checkConnectionValidity(), thread id: {0}, amount of removed connections: {1}.", Thread.currentThread().getId(), sum));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void stop() {
        if (checkClusterStateScheduledFuture == null && closeConnectionScheduledFuture == null) return;
        Class<LoadBalanceHeartBeating> clazz = LoadBalanceHeartBeating.class;
        synchronized (LoadBalanceHeartBeating.class) {
            if (checkClusterStateScheduledFuture != null) {
                checkClusterStateScheduledFuture.cancel(true);
                leastConnStarted = false;
            }
            if (closeConnectionScheduledFuture == null) return;
            closeConnectionScheduledFuture.cancel(true);
            quickAutoBalanceStarted = false;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

