/*
 * Decompiled with CFR 0.152.
 */
package org.gbase.ssl;

import java.net.IDN;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.gbase.log.Log;
import org.gbase.log.Logger;
import org.gbase.util.GT;

public class PGjdbcHostnameVerifier
implements HostnameVerifier {
    private static Log LOGGER = Logger.getLogger(PGjdbcHostnameVerifier.class.getName());
    public static final PGjdbcHostnameVerifier INSTANCE = new PGjdbcHostnameVerifier();
    private static final int TYPE_DNS_NAME = 2;
    private static final int TYPE_IP_ADDRESS = 7;
    public static Comparator<String> HOSTNAME_PATTERN_COMPARATOR = new Comparator<String>(){

        private int countChars(String value, char ch) {
            int count = 0;
            int pos = -1;
            while ((pos = value.indexOf(ch, pos + 1)) != -1) {
                ++count;
            }
            return count;
        }

        @Override
        public int compare(String o1, String o2) {
            int l2;
            int s2;
            int d2;
            int d1 = this.countChars(o1, '.');
            if (d1 != (d2 = this.countChars(o2, '.'))) {
                return d1 > d2 ? 1 : -1;
            }
            int s1 = this.countChars(o1, '*');
            if (s1 != (s2 = this.countChars(o2, '*'))) {
                return s1 < s2 ? 1 : -1;
            }
            int l1 = o1.length();
            if (l1 != (l2 = o2.length())) {
                return l1 > l2 ? 1 : -1;
            }
            return 0;
        }
    };

    @Override
    public boolean verify(String hostname, SSLSession session) {
        String commonName;
        boolean result;
        LdapName DN;
        Collection<List<?>> subjectAltNames;
        String canonicalHostname;
        X509Certificate[] peerCerts;
        try {
            peerCerts = (X509Certificate[])session.getPeerCertificates();
        }
        catch (SSLPeerUnverifiedException e) {
            LOGGER.error(GT.tr("Unable to parse X509Certificate for hostname " + hostname, new Object[0]), e);
            return false;
        }
        if (peerCerts == null || peerCerts.length == 0) {
            LOGGER.error(GT.tr("No certificates found for hostname " + hostname, new Object[0]));
            return false;
        }
        if (hostname.startsWith("[") && hostname.endsWith("]")) {
            canonicalHostname = hostname.substring(1, hostname.length() - 1);
        } else {
            try {
                canonicalHostname = IDN.toASCII(hostname);
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Canonical host name for " + hostname + " is " + canonicalHostname);
                }
            }
            catch (IllegalArgumentException e) {
                LOGGER.error(GT.tr("Hostname " + hostname + " is invalid", new Object[0]), e);
                return false;
            }
        }
        X509Certificate serverCert = peerCerts[0];
        try {
            subjectAltNames = serverCert.getSubjectAlternativeNames();
            if (subjectAltNames == null) {
                subjectAltNames = Collections.emptyList();
            }
        }
        catch (CertificateParsingException e) {
            LOGGER.error(GT.tr("Unable to parse certificates for hostname " + hostname, new Object[0]), e);
            return false;
        }
        boolean anyDnsSan = false;
        for (List<?> sanItem : subjectAltNames) {
            Object sanType;
            if (sanItem.size() != 2 || (sanType = (Integer)sanItem.get(0)) == null || (Integer)sanType != 7 && (Integer)sanType != 2) continue;
            String san = (String)sanItem.get(1);
            if ((Integer)sanType == 7 && san.startsWith("*")) continue;
            anyDnsSan |= (Integer)sanType == 2;
            if (!this.verifyHostName(canonicalHostname, san)) continue;
            if (LOGGER.isTraceEnabled()) {
                LOGGER.error(GT.tr("Server name validation pass for " + hostname + ", subjectAltName " + san, new Object[0]));
            }
            return true;
        }
        if (anyDnsSan) {
            LOGGER.error(GT.tr("Server name validation failed: certificate for host " + hostname + " dNSName entries subjectAltName, but none of them match. Assuming server name validation failed", new Object[0]));
            return false;
        }
        try {
            DN = new LdapName(serverCert.getSubjectX500Principal().getName("RFC2253"));
        }
        catch (InvalidNameException e) {
            LOGGER.error(GT.tr("Server name validation failed: unable to extract common name from X509Certificate for hostname " + hostname, new Object[0]), e);
            return false;
        }
        ArrayList<String> commonNames = new ArrayList<String>(1);
        for (Rdn rdn : DN.getRdns()) {
            if (!"CN".equals(rdn.getType())) continue;
            commonNames.add((String)rdn.getValue());
        }
        if (commonNames.isEmpty()) {
            LOGGER.error(GT.tr("Server name validation failed: certificate for hostname " + hostname + " has no DNS subjectAltNames, and it CommonName is missing as well", new Object[0]));
            return false;
        }
        if (commonNames.size() > 1) {
            Collections.sort(commonNames, HOSTNAME_PATTERN_COMPARATOR);
        }
        if (!(result = this.verifyHostName(canonicalHostname, commonName = (String)commonNames.get(commonNames.size() - 1)))) {
            LOGGER.error(GT.tr("Server name validation failed: hostname " + hostname + " does not match common name " + commonName, new Object[0]));
        }
        return result;
    }

    public boolean verifyHostName(String hostname, String pattern) {
        if (hostname == null || pattern == null) {
            return false;
        }
        int lastStar = pattern.lastIndexOf(42);
        if (lastStar == -1) {
            return hostname.equalsIgnoreCase(pattern);
        }
        if (lastStar > 0) {
            return false;
        }
        if (pattern.indexOf(46) == -1) {
            return false;
        }
        if (hostname.length() < pattern.length() - 1) {
            return false;
        }
        boolean ignoreCase = true;
        int toffset = hostname.length() - pattern.length() + 1;
        if (hostname.lastIndexOf(46, toffset - 1) >= 0) {
            return false;
        }
        return hostname.regionMatches(true, toffset, pattern, 1, pattern.length() - 1);
    }
}

