/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.internal.com.read.dao;

import com.oceanbase.jdbc.JDBC4ResultSet;
import com.oceanbase.jdbc.OceanBaseStatement;
import com.oceanbase.jdbc.internal.com.read.dao.CmdInformation;
import com.oceanbase.jdbc.internal.com.read.dao.CmdInformationBatch;
import com.oceanbase.jdbc.internal.com.read.dao.CmdInformationMultiple;
import com.oceanbase.jdbc.internal.com.read.dao.CmdInformationSingle;
import com.oceanbase.jdbc.internal.com.read.resultset.SelectResultSet;
import com.oceanbase.jdbc.internal.com.send.parameters.ParameterHolder;
import com.oceanbase.jdbc.internal.logging.Logger;
import com.oceanbase.jdbc.internal.logging.LoggerFactory;
import com.oceanbase.jdbc.internal.protocol.Protocol;
import com.oceanbase.jdbc.internal.util.Utils;
import com.oceanbase.jdbc.internal.util.exceptions.ExceptionFactory;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.locks.ReentrantLock;

public class Results {
    private int statementId = 0;
    private OceanBaseStatement statement;
    private String sql;
    private ParameterHolder[] parameters;
    private int resultSetScrollType;
    private int resultSetConcurrency;
    private int fetchSize;
    private SelectResultSet resultSet;
    private SelectResultSet callableResultSet;
    private Deque<SelectResultSet> executionResults;
    private boolean toCursorFetch;
    private boolean toPrepareExecute;
    private boolean internalResult;
    private boolean returning;
    private boolean batch;
    private int expectedSize;
    private boolean binaryFormat;
    private int autoGeneratedKeys;
    private int maxFieldSize;
    private int autoIncrement;
    private boolean rewritten;
    private CmdInformation cmdInformation;
    private boolean batchSucceed = false;
    protected static final Logger lockLogger = LoggerFactory.getLogger("JDBC-COST-LOGGER");
    private boolean executeBatchStmt = false;

    public boolean isExecuteBatchStmt() {
        return this.executeBatchStmt;
    }

    public void setExecuteBatchStmt(boolean executeBatchStmt) {
        this.executeBatchStmt = executeBatchStmt;
    }

    public Results() {
        this.statement = null;
        this.fetchSize = 0;
        this.maxFieldSize = 0;
        this.batch = false;
        this.expectedSize = 1;
        this.cmdInformation = null;
        this.binaryFormat = false;
        this.resultSetScrollType = 1003;
        this.resultSetConcurrency = 1007;
        this.autoIncrement = 1;
        this.autoGeneratedKeys = 2;
        this.sql = null;
        this.toCursorFetch = false;
    }

    public Results(OceanBaseStatement statement, int fetchSize, boolean batch, int expectedSize, boolean binaryFormat, int resultSetScrollType, int resultSetConcurrency, int autoGeneratedKeys, int autoIncrement, String sql, ParameterHolder[] parameters) {
        this.statement = statement;
        this.fetchSize = fetchSize;
        this.batch = batch;
        this.maxFieldSize = statement.getMaxFieldSize();
        this.expectedSize = expectedSize;
        this.cmdInformation = null;
        this.binaryFormat = binaryFormat;
        this.resultSetScrollType = resultSetScrollType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.autoIncrement = autoIncrement;
        this.autoGeneratedKeys = autoGeneratedKeys;
        this.sql = sql;
        this.parameters = parameters;
        this.toCursorFetch = false;
    }

    boolean containOnDuplicateKey(String sql, Protocol protocol) {
        if (sql == null || sql.length() == 0) {
            return false;
        }
        if (protocol == null) {
            return false;
        }
        Utils.TrimSQLInfo trimSQLInfo = Utils.trimSQLStringInternal(sql, protocol.noBackslashEscapes(), protocol.isOracleMode(), true);
        return trimSQLInfo.getOnDuplicateKeyUpdateIndex() != -1;
    }

    public void addStats(long updateCount, long insertId, boolean moreResultAvailable, String serverInfo) {
        if (this.cmdInformation == null) {
            if (this.batch) {
                this.cmdInformation = new CmdInformationBatch(this.expectedSize, this.autoIncrement);
            } else if (moreResultAvailable) {
                this.cmdInformation = new CmdInformationMultiple(this.expectedSize, this.autoIncrement);
            } else {
                this.cmdInformation = new CmdInformationSingle(insertId, updateCount, this.autoIncrement, serverInfo);
                return;
            }
        }
        this.cmdInformation.addSuccessStat(updateCount, insertId, this.containOnDuplicateKey(this.statement.getActualSql(), this.statement.getConnection().getProtocol()), serverInfo);
    }

    public void addStatsError(boolean moreResultAvailable) {
        if (this.cmdInformation == null) {
            if (this.batch) {
                this.cmdInformation = new CmdInformationBatch(this.expectedSize, this.autoIncrement);
            } else if (moreResultAvailable) {
                this.cmdInformation = new CmdInformationMultiple(this.expectedSize, this.autoIncrement);
            } else {
                this.cmdInformation = new CmdInformationSingle(0L, -3L, this.autoIncrement);
                return;
            }
        }
        this.cmdInformation.addErrorStat();
    }

    public int getCurrentStatNumber() {
        return this.cmdInformation == null ? 0 : this.cmdInformation.getCurrentStatNumber();
    }

    public void addResultSet(SelectResultSet resultSet, boolean moreResultAvailable) {
        if (resultSet.isCallableResult()) {
            this.callableResultSet = resultSet;
            return;
        }
        if (this.executionResults == null) {
            this.executionResults = new ArrayDeque<SelectResultSet>();
        }
        this.executionResults.add(resultSet);
        if (this.cmdInformation == null) {
            if (this.batch) {
                this.cmdInformation = new CmdInformationBatch(this.expectedSize, this.autoIncrement);
            } else if (moreResultAvailable) {
                this.cmdInformation = new CmdInformationMultiple(this.expectedSize, this.autoIncrement);
            } else {
                this.cmdInformation = new CmdInformationSingle(0L, -1L, this.autoIncrement);
                return;
            }
        }
        this.cmdInformation.addResultSetStat();
    }

    public boolean isToCursorFetch() {
        return this.toCursorFetch;
    }

    public void setToCursorFetch(boolean val) {
        this.toCursorFetch = val;
    }

    public boolean isToPrepareExecute() {
        return this.toPrepareExecute;
    }

    public void setToPrepareExecute(boolean val) {
        this.toPrepareExecute = val;
    }

    public boolean isInternalResult() {
        return this.internalResult;
    }

    public void setInternalResult(boolean internalResult) {
        this.internalResult = internalResult;
    }

    public CmdInformation getCmdInformation() {
        return this.cmdInformation;
    }

    protected void setCmdInformation(CmdInformation cmdInformation) {
        this.cmdInformation = cmdInformation;
    }

    public boolean commandEnd() {
        if (this.cmdInformation != null) {
            this.resultSet = this.executionResults != null && !this.cmdInformation.isCurrentUpdateCount() ? this.executionResults.poll() : null;
            this.cmdInformation.setRewrite(this.rewritten);
        } else {
            this.resultSet = null;
        }
        return this.cmdInformation != null;
    }

    public SelectResultSet getResultSet() {
        return this.resultSet;
    }

    public SelectResultSet getCallableResultSet() {
        return this.callableResultSet;
    }

    public void loadFully(boolean skip, Protocol protocol) throws SQLException {
        if (this.fetchSize != 0) {
            this.fetchSize = 0;
            if (this.resultSet != null) {
                if (skip) {
                    this.resultSet.close();
                } else {
                    this.resultSet.fetchRemaining();
                }
            } else {
                SelectResultSet firstResult = this.executionResults.peekFirst();
                if (firstResult != null) {
                    if (skip) {
                        firstResult.close();
                    } else {
                        firstResult.fetchRemaining();
                    }
                }
            }
        }
        if (protocol.hasMoreResults()) {
            protocol.getResult(this);
        }
    }

    public void abort() throws SQLException {
        if (this.fetchSize != 0) {
            this.fetchSize = 0;
            if (this.resultSet != null) {
                this.resultSet.abort();
            } else {
                SelectResultSet firstResult = this.executionResults.peekFirst();
                if (firstResult != null) {
                    firstResult.abort();
                }
            }
        }
    }

    public boolean isFullyLoaded(Protocol protocol) {
        if (this.fetchSize == 0 || this.resultSet == null) {
            return true;
        }
        return this.resultSet.isFullyLoaded() && this.executionResults.isEmpty() && !protocol.hasMoreResults();
    }

    public boolean getMoreResults(int current, Protocol protocol) throws SQLException {
        if (this.fetchSize != 0 && this.resultSet != null) {
            ReentrantLock curLock = protocol.getLock();
            curLock.lock();
            try {
                lockLogger.debug("Results.getMoreResults locked");
                if (current == 1 && this.resultSet != null) {
                    this.resultSet.close();
                } else {
                    this.resultSet.fetchRemaining();
                }
                if (protocol.hasMoreResults()) {
                    protocol.getResult(this);
                }
            }
            catch (SQLException e) {
                throw ExceptionFactory.INSTANCE.create(e);
            }
            finally {
                curLock.unlock();
                lockLogger.debug("Results.getMoreResults unlocked");
            }
        }
        if (this.cmdInformation != null && this.cmdInformation.moreResults() && !this.batch) {
            if (current == 1 && this.resultSet != null) {
                this.resultSet.close();
            }
            if (this.executionResults != null) {
                this.resultSet = this.executionResults.poll();
            }
            return this.resultSet != null;
        }
        if (current == 1 && this.resultSet != null) {
            this.resultSet.close();
        }
        this.resultSet = null;
        protocol.removeActiveStreamingResult();
        return false;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public OceanBaseStatement getStatement() {
        return this.statement;
    }

    public boolean isBatch() {
        return this.batch;
    }

    public int getExpectedSize() {
        return this.expectedSize;
    }

    public boolean isBinaryFormat() {
        return this.binaryFormat;
    }

    public void removeFetchSize() {
        this.fetchSize = 0;
    }

    public int getResultSetScrollType() {
        return this.resultSetScrollType;
    }

    public String getSql() {
        return this.sql;
    }

    public ParameterHolder[] getParameters() {
        return this.parameters;
    }

    public ResultSet getGeneratedKeys(Protocol protocol) throws SQLException {
        if (this.autoGeneratedKeys != 1) {
            throw new SQLException("Cannot return generated keys : query was not set with Statement.RETURN_GENERATED_KEYS");
        }
        if (this.cmdInformation != null) {
            if (this.batch) {
                return this.cmdInformation.getBatchGeneratedKeys(protocol);
            }
            return this.cmdInformation.getGeneratedKeys(protocol, this.sql);
        }
        return SelectResultSet.createEmptyResultSet();
    }

    public void close() throws SQLException {
        this.statement = null;
        this.statementId = 0;
        this.fetchSize = 0;
        this.resultSet = null;
        this.callableResultSet = null;
        this.executionResults = null;
    }

    public void closeAllOpenResults() throws SQLException {
        if (this.executionResults != null) {
            for (JDBC4ResultSet jDBC4ResultSet : this.executionResults) {
                jDBC4ResultSet.realClose(false);
            }
            this.executionResults.clear();
        }
    }

    public int getMaxFieldSize() {
        return this.maxFieldSize;
    }

    public void setAutoIncrement(int autoIncrement) {
        this.autoIncrement = autoIncrement;
    }

    public int getResultSetConcurrency() {
        return this.resultSetConcurrency;
    }

    public int getAutoGeneratedKeys() {
        return this.autoGeneratedKeys;
    }

    public boolean isRewritten() {
        return this.rewritten;
    }

    public void setRewritten(boolean rewritten) {
        this.rewritten = rewritten;
    }

    public void setStatementId(int statementId) {
        this.statementId = statementId;
    }

    public int getStatementId() {
        return this.statementId;
    }

    public void setParameters(ParameterHolder[] parameters) {
        this.parameters = parameters;
    }

    public boolean getBatchSucceed() {
        return this.batchSucceed;
    }

    public void setBatchSucceed(boolean succeed) {
        this.batchSucceed = succeed;
    }

    public Deque<SelectResultSet> getExecutionResults() {
        return this.executionResults;
    }

    public void setReturning(boolean isReturning) {
        this.returning = isReturning;
    }

    public boolean isReturning() {
        return this.returning;
    }
}

