/*
 * Decompiled with CFR 0.152.
 */
package com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql;

import com.tencentcloud.tdsql.mysql.cj.conf.PropertyKey;
import com.tencentcloud.tdsql.mysql.cj.jdbc.JdbcPropertySetImpl;
import com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.TdsqlHostInfo;
import com.tencentcloud.tdsql.mysql.cj.log.Log;
import com.tencentcloud.tdsql.mysql.cj.log.LogFactory;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;

public final class TdsqlLoggerFactory {
    public static final AtomicBoolean loggerInitialized = new AtomicBoolean(false);
    private static Log log;

    private TdsqlLoggerFactory() {
    }

    public static void setLogger(TdsqlHostInfo tdsqlHostInfo) {
        Properties properties = tdsqlHostInfo.exposeAsProperties();
        properties.remove(PropertyKey.tdsqlLoadBalanceStrategy.getKeyName());
        properties.remove(PropertyKey.tdsqlLoadBalanceWeightFactor.getKeyName());
        properties.remove(PropertyKey.tdsqlLoadBalanceHeartbeatMonitorEnable.getKeyName());
        properties.remove(PropertyKey.tdsqlLoadBalanceHeartbeatIntervalTimeMillis.getKeyName());
        properties.remove(PropertyKey.tdsqlLoadBalanceHeartbeatMaxErrorRetries.getKeyName());
        properties.remove(PropertyKey.tdsqlLoadBalanceHeartbeatErrorRetryIntervalTimeMillis.getKeyName());
        JdbcPropertySetImpl propertySet = new JdbcPropertySetImpl();
        propertySet.initializeProperties(properties);
        log = LogFactory.getLogger(propertySet.getStringProperty(PropertyKey.logger).getStringValue(), "[TDSQL-MySQL Connector/J JAVA8]");
    }

    public static void logDebug(Object msg) {
        if (log != null && log.isDebugEnabled()) {
            log.logDebug(TdsqlLoggerFactory.printThreadId() + msg);
        }
    }

    public static void logInfo(Object msg) {
        if (log != null && log.isInfoEnabled()) {
            log.logInfo(TdsqlLoggerFactory.printThreadId() + msg);
        }
    }

    public static void logWarn(Object msg) {
        if (log != null && log.isWarnEnabled()) {
            log.logWarn(msg);
        }
    }

    public static void logError(Object msg) {
        if (log != null && log.isErrorEnabled()) {
            log.logError(TdsqlLoggerFactory.printThreadId() + msg);
        }
    }

    public static void logError(Object msg, Throwable thrown) {
        if (log != null && log.isErrorEnabled()) {
            log.logError(TdsqlLoggerFactory.printThreadId() + msg, thrown);
        }
    }

    public static void logFatal(Object msg) {
        if (log != null && log.isFatalEnabled()) {
            log.logFatal(TdsqlLoggerFactory.printThreadId() + msg);
        }
    }

    private static String printThreadId() {
        return "[TID: " + Thread.currentThread().getId() + "] ";
    }
}

