/*
 * Decompiled with CFR 0.152.
 */
package com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql;

import com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.TdsqlHostInfo;
import com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.TdsqlLoadBalanceStrategy;
import com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.TdsqlLoggerFactory;
import com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.loadbalance.TdsqlLoadBalanceBlacklistHolder;
import com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.loadbalance.TdsqlLoadBalanceConnectionCounter;
import com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.util.TdsqlAtomicLongMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class TdsqlSedBalanceStrategy
implements TdsqlLoadBalanceStrategy {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TdsqlHostInfo choice(TdsqlAtomicLongMap<TdsqlHostInfo> scheduleQueue) {
        Iterator<Map.Entry<TdsqlHostInfo, Long>> iterator;
        if (scheduleQueue == null || scheduleQueue.isEmpty()) {
            return null;
        }
        Map<TdsqlHostInfo, Long> tdsqlHostInfoLongMap = scheduleQueue.asMap();
        if (scheduleQueue.size() == 1 && (iterator = tdsqlHostInfoLongMap.entrySet().iterator()).hasNext()) {
            Map.Entry<TdsqlHostInfo, Long> entry = iterator.next();
            return entry.getKey();
        }
        int numHosts = tdsqlHostInfoLongMap.size();
        ReentrantReadWriteLock counterLock = TdsqlLoadBalanceConnectionCounter.getInstance().getCounterLock();
        counterLock.readLock().lock();
        try {
            ArrayList<Map.Entry<TdsqlHostInfo, Long>> counterList = new ArrayList<Map.Entry<TdsqlHostInfo, Long>>(tdsqlHostInfoLongMap.entrySet());
            for (int i = 0; i < numHosts; ++i) {
                Map.Entry curr = (Map.Entry)counterList.get(i);
                int currWf = ((TdsqlHostInfo)curr.getKey()).getWeightFactor();
                if (currWf <= 0) continue;
                long currCount = (Long)curr.getValue() + 1L;
                for (int j = i + 1; j < numHosts; ++j) {
                    long nextCount;
                    Map.Entry next = (Map.Entry)counterList.get(j);
                    int nextWf = ((TdsqlHostInfo)next.getKey()).getWeightFactor();
                    if (nextWf <= 0 || currCount * (long)nextWf < (nextCount = (Long)next.getValue() + 1L) * (long)currWf) continue;
                    i = j;
                }
                TdsqlHostInfo choice = (TdsqlHostInfo)((Map.Entry)counterList.get(i)).getKey();
                TdsqlLoggerFactory.logDebug("SED algorithm choice [" + choice.getHostPortPair() + "], current counter [" + scheduleQueue + "], current blacklist [" + TdsqlLoadBalanceBlacklistHolder.getInstance().printBlacklist() + "]");
                TdsqlHostInfo tdsqlHostInfo = choice;
                return tdsqlHostInfo;
            }
        }
        finally {
            counterLock.readLock().unlock();
        }
        return null;
    }
}

