/*
 * Decompiled with CFR 0.152.
 */
package com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.direct;

import com.tencentcloud.tdsql.mysql.cj.conf.ConnectionUrl;
import com.tencentcloud.tdsql.mysql.cj.conf.HostInfo;
import com.tencentcloud.tdsql.mysql.cj.jdbc.JdbcConnection;
import com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.TdsqlHostInfo;
import com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.direct.TdsqlDirectConnectionManager;
import com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.direct.TdsqlDirectLoadBalanceStrategy;
import com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.direct.TdsqlDirectLoggerFactory;
import com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.direct.TdsqlDirectReadWriteMode;
import com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.direct.TdsqlDirectTopoServer;
import com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.direct.cluster.TdsqlDataSetCache;
import com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.direct.cluster.TdsqlDataSetInfo;
import com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.direct.exception.TdsqlNoBackendInstanceException;
import com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.util.TdsqlAtomicLongMap;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class TdsqlDirectConnectionFactory {
    public static boolean directMode = false;

    private TdsqlDirectConnectionFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JdbcConnection createConnection(ConnectionUrl connectionUrl) throws SQLException {
        JdbcConnection newConnection;
        directMode = true;
        TdsqlDirectTopoServer topoServer = TdsqlDirectTopoServer.getInstance();
        ReentrantReadWriteLock refreshLock = topoServer.getRefreshLock();
        topoServer.initialize(connectionUrl);
        TdsqlDirectReadWriteMode readWriteMode = TdsqlDirectReadWriteMode.convert(topoServer.getTdsqlDirectReadWriteMode());
        List<TdsqlDataSetInfo> masters = TdsqlDataSetCache.getInstance().getMasters();
        List<TdsqlDataSetInfo> slaves = TdsqlDataSetCache.getInstance().getSlaves();
        if (TdsqlDirectReadWriteMode.RW.equals((Object)readWriteMode) && masters.isEmpty()) {
            throw new TdsqlNoBackendInstanceException("No master instance found, master size: 0");
        }
        if (TdsqlDirectReadWriteMode.RO.equals((Object)readWriteMode) && slaves.isEmpty()) {
            throw new TdsqlNoBackendInstanceException("No slave instance found");
        }
        TdsqlDirectLoggerFactory.logDebug("New create connection request received, now master: " + masters + ", now slaves: " + slaves);
        refreshLock.readLock().lock();
        try {
            newConnection = TdsqlDirectConnectionManager.getInstance().createNewConnection(new TdsqlDirectLoadBalanceStrategy());
        }
        finally {
            refreshLock.readLock().unlock();
        }
        return newConnection;
    }

    public void closeConnection(JdbcConnection jdbcConnection, HostInfo hostInfo) {
        TdsqlHostInfo tdsqlHostInfo = new TdsqlHostInfo(hostInfo);
        TdsqlDirectConnectionManager.getInstance().getConnectionList(tdsqlHostInfo).removeIf(cachedConnection -> cachedConnection.equals(jdbcConnection));
        TdsqlAtomicLongMap<TdsqlHostInfo> scheduleQueue = TdsqlDirectTopoServer.getInstance().getScheduleQueue();
        if (scheduleQueue.containsKey(tdsqlHostInfo)) {
            scheduleQueue.decrementAndGet(tdsqlHostInfo);
        }
    }

    public static TdsqlDirectConnectionFactory getInstance() {
        return SingletonInstance.INSTANCE;
    }

    private static class SingletonInstance {
        private static final TdsqlDirectConnectionFactory INSTANCE = new TdsqlDirectConnectionFactory();

        private SingletonInstance() {
        }
    }
}

