/*
 * Decompiled with CFR 0.152.
 */
package com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.direct;

import com.tencentcloud.tdsql.mysql.cj.jdbc.ConnectionImpl;
import com.tencentcloud.tdsql.mysql.cj.jdbc.JdbcConnection;
import com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.TdsqlHostInfo;
import com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.TdsqlLoadBalanceStrategy;
import com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.direct.TdsqlDirectLoggerFactory;
import com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.direct.TdsqlDirectTopoServer;
import com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.util.AbstractTdsqlCaughtRunnable;
import com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.util.TdsqlAtomicLongMap;
import com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.util.TdsqlSynchronousExecutor;
import com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.util.TdsqlThreadFactoryBuilder;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class TdsqlDirectConnectionManager {
    private final ConcurrentHashMap<TdsqlHostInfo, List<JdbcConnection>> connectionHolder = new ConcurrentHashMap();
    private ThreadPoolExecutor recycler;

    private TdsqlDirectConnectionManager() {
        this.initializeCompensator();
        this.initializeRecycler();
    }

    public static TdsqlDirectConnectionManager getInstance() {
        return SingletonInstance.INSTANCE;
    }

    public synchronized JdbcConnection createNewConnection(TdsqlLoadBalanceStrategy balancer) throws SQLException {
        TdsqlDirectTopoServer topoServer = TdsqlDirectTopoServer.getInstance();
        TdsqlAtomicLongMap<TdsqlHostInfo> scheduleQueue = topoServer.getScheduleQueue();
        TdsqlHostInfo tdsqlHostInfo = balancer.choice(scheduleQueue);
        JdbcConnection connection = ConnectionImpl.getInstance(tdsqlHostInfo);
        List holderList = this.connectionHolder.getOrDefault(tdsqlHostInfo, new CopyOnWriteArrayList());
        holderList.add(connection);
        this.connectionHolder.put(tdsqlHostInfo, holderList);
        scheduleQueue.incrementAndGet(tdsqlHostInfo);
        return connection;
    }

    public ConcurrentHashMap<TdsqlHostInfo, List<JdbcConnection>> getAllConnection() {
        return this.connectionHolder;
    }

    public synchronized void close(List<String> toCloseList) {
        if (toCloseList == null || toCloseList.isEmpty()) {
            TdsqlDirectLoggerFactory.logDebug("To close list is empty, close operation ignore!");
            return;
        }
        this.recycler.submit(new RecyclerTask(toCloseList));
    }

    private void initializeCompensator() {
        ScheduledThreadPoolExecutor compensator = new ScheduledThreadPoolExecutor(1, new TdsqlThreadFactoryBuilder().setDaemon(true).setNameFormat("Compensator-pool-").build());
        compensator.scheduleWithFixedDelay(new CompensatorTask(), 0L, 1L, TimeUnit.SECONDS);
    }

    private void initializeRecycler() {
        this.recycler = new ThreadPoolExecutor(1, 1, 5L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(100), new TdsqlThreadFactoryBuilder().setDaemon(true).setNameFormat("Recycler-pool-").build(), new ThreadPoolExecutor.AbortPolicy());
        this.recycler.allowCoreThreadTimeOut(true);
    }

    public List<JdbcConnection> getConnectionList(TdsqlHostInfo tdsqlHostInfo) {
        return this.connectionHolder.getOrDefault(tdsqlHostInfo, new CopyOnWriteArrayList());
    }

    private static class SingletonInstance {
        private static final TdsqlDirectConnectionManager INSTANCE = new TdsqlDirectConnectionManager();

        private SingletonInstance() {
        }
    }

    private static class RecyclerTask
    extends AbstractTdsqlCaughtRunnable {
        private final List<String> recycleList;
        private final Executor netTimeoutExecutor = new TdsqlSynchronousExecutor();

        private RecyclerTask(List<String> recycleList) {
            this.recycleList = recycleList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void caughtAndRun() {
            ConcurrentHashMap<TdsqlHostInfo, List<JdbcConnection>> allConnection = TdsqlDirectConnectionManager.getInstance().getAllConnection();
            Iterator<Map.Entry<TdsqlHostInfo, List<JdbcConnection>>> entryIterator = allConnection.entrySet().iterator();
            while (entryIterator.hasNext()) {
                Map.Entry<TdsqlHostInfo, List<JdbcConnection>> entry = entryIterator.next();
                String holdHostPortPair = entry.getKey().getHostPortPair();
                if (this.recycleList.contains(holdHostPortPair)) {
                    TdsqlDirectLoggerFactory.logDebug("Start close [" + holdHostPortPair + "]'s connections!");
                    for (JdbcConnection jdbcConnection : entry.getValue()) {
                        ConnectionImpl connection = (ConnectionImpl)jdbcConnection;
                        if (connection == null || connection.isClosed()) continue;
                        try {
                            connection.setNetworkTimeout(this.netTimeoutExecutor, TdsqlDirectTopoServer.getInstance().getTdsqlDirectCloseConnTimeoutMillis());
                        }
                        catch (Exception e) {}
                        continue;
                        finally {
                            try {
                                connection.close();
                            }
                            catch (Exception e) {
                                TdsqlDirectLoggerFactory.logError("Closing [" + holdHostPortPair + "] connection failed!");
                            }
                        }
                    }
                    entryIterator.remove();
                    TdsqlDirectLoggerFactory.logDebug("Finish close [" + holdHostPortPair + "]'s connections!");
                    continue;
                }
                TdsqlDirectLoggerFactory.logDebug("To closes not in connection holder! NOOP!");
            }
        }
    }

    private static class CompensatorTask
    extends AbstractTdsqlCaughtRunnable {
        private CompensatorTask() {
        }

        @Override
        public void caughtAndRun() {
            TdsqlAtomicLongMap<TdsqlHostInfo> scheduleQueue = TdsqlDirectTopoServer.getInstance().getScheduleQueue();
            ConcurrentHashMap<TdsqlHostInfo, List<JdbcConnection>> connectionHolder = TdsqlDirectConnectionManager.getInstance().getAllConnection();
            for (Map.Entry<TdsqlHostInfo, List<JdbcConnection>> entry : connectionHolder.entrySet()) {
                TdsqlHostInfo tdsqlHostInfo = entry.getKey();
                int realCount = entry.getValue().size();
                if (!scheduleQueue.containsKey(tdsqlHostInfo)) {
                    return;
                }
                long currentCount = scheduleQueue.get(tdsqlHostInfo);
                if ((long)realCount == currentCount) continue;
                scheduleQueue.put(tdsqlHostInfo, realCount);
            }
        }
    }
}

