/*
 * Decompiled with CFR 0.152.
 */
package com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.direct;

import com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.direct.TdsqlDirectConnectionManager;
import com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.direct.TdsqlDirectLoggerFactory;
import com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.direct.TdsqlDirectMasterSlaveSwitchMode;
import com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.direct.TdsqlDirectReadWriteMode;
import java.util.List;

public class TdsqlDirectFailoverOperator {
    private TdsqlDirectFailoverOperator() {
    }

    public static void subsequentOperation(TdsqlDirectReadWriteMode rwMode, TdsqlDirectMasterSlaveSwitchMode switchMode, List<String> toCloseList) {
        TdsqlDirectLoggerFactory.logDebug("Because current direct read write mode is: " + (Object)((Object)rwMode));
        switch (rwMode) {
            case RW: {
                TdsqlDirectFailoverOperator.optOfReadWriteMode(switchMode, toCloseList);
                break;
            }
            case RO: {
                TdsqlDirectFailoverOperator.optOfReadOnlyMode(switchMode, toCloseList);
                break;
            }
            default: {
                TdsqlDirectLoggerFactory.logError("Unknown direct read write mode: " + (Object)((Object)rwMode) + "! NOOP!");
            }
        }
    }

    private static void optOfReadWriteMode(TdsqlDirectMasterSlaveSwitchMode switchMode, List<String> toCloseList) {
        TdsqlDirectLoggerFactory.logDebug("Because current switch mode is: " + (Object)((Object)switchMode));
        switch (switchMode) {
            case MASTER_SLAVE_SWITCH: {
                TdsqlDirectFailoverOperator.optOfReadWriteModeInMasterSlaveSwitch(toCloseList);
                break;
            }
            case SLAVE_ONLINE: {
                TdsqlDirectFailoverOperator.optOfReadWriteModeInSlaveOnline();
                break;
            }
            case SLAVE_OFFLINE: {
                TdsqlDirectFailoverOperator.optOfReadWriteModeInSlaveOffline();
                break;
            }
            default: {
                TdsqlDirectLoggerFactory.logError("Unknown switch mode: " + (Object)((Object)switchMode) + "! NOOP!");
            }
        }
    }

    private static void optOfReadOnlyMode(TdsqlDirectMasterSlaveSwitchMode switchMode, List<String> toCloseList) {
        TdsqlDirectLoggerFactory.logDebug("Because current switch mode is: " + (Object)((Object)switchMode));
        switch (switchMode) {
            case MASTER_SLAVE_SWITCH: {
                TdsqlDirectFailoverOperator.optOfReadOnlyModeInMasterSlaveSwitch(toCloseList);
                break;
            }
            case SLAVE_ONLINE: {
                TdsqlDirectFailoverOperator.optOfReadOnlyModeInSlaveOnline();
                break;
            }
            case SLAVE_OFFLINE: {
                TdsqlDirectFailoverOperator.optOfReadOnlyModeInSlaveOffline(toCloseList);
                break;
            }
            default: {
                TdsqlDirectLoggerFactory.logError("Unknown switch mode: " + (Object)((Object)switchMode) + "! NOOP!");
            }
        }
    }

    private static void optOfReadWriteModeInMasterSlaveSwitch(List<String> toCloseList) {
        TdsqlDirectLoggerFactory.logDebug("So we will close [" + toCloseList + "]'s connections!");
        TdsqlDirectConnectionManager.getInstance().close(toCloseList);
    }

    private static void optOfReadWriteModeInSlaveOnline() {
        TdsqlDirectLoggerFactory.logDebug("So NOOP!");
    }

    private static void optOfReadWriteModeInSlaveOffline() {
        TdsqlDirectLoggerFactory.logDebug("So NOOP!");
    }

    private static void optOfReadOnlyModeInMasterSlaveSwitch(List<String> toCloseList) {
        TdsqlDirectLoggerFactory.logDebug("So we will close [" + toCloseList + "]'s connections!");
        TdsqlDirectConnectionManager.getInstance().close(toCloseList);
    }

    private static void optOfReadOnlyModeInSlaveOnline() {
        TdsqlDirectLoggerFactory.logDebug("So NOOP!");
    }

    private static void optOfReadOnlyModeInSlaveOffline(List<String> toCloseList) {
        TdsqlDirectLoggerFactory.logDebug("So we will close [" + toCloseList + "]'s connections!");
        TdsqlDirectConnectionManager.getInstance().close(toCloseList);
    }
}

