/*
 * Decompiled with CFR 0.152.
 */
package com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.direct;

import com.tencentcloud.tdsql.mysql.cj.Messages;
import com.tencentcloud.tdsql.mysql.cj.conf.ConnectionUrl;
import com.tencentcloud.tdsql.mysql.cj.conf.PropertyKey;
import com.tencentcloud.tdsql.mysql.cj.conf.url.LoadBalanceConnectionUrl;
import com.tencentcloud.tdsql.mysql.cj.jdbc.JdbcConnection;
import com.tencentcloud.tdsql.mysql.cj.jdbc.JdbcPropertySetImpl;
import com.tencentcloud.tdsql.mysql.cj.jdbc.exceptions.SQLError;
import com.tencentcloud.tdsql.mysql.cj.jdbc.ha.LoadBalancedConnectionProxy;
import com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.TdsqlHostInfo;
import com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.direct.TdsqlDirectConst;
import com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.direct.TdsqlDirectLoggerFactory;
import com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.direct.cluster.TdsqlDataSetCache;
import com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.direct.cluster.TdsqlDataSetCluster;
import com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.direct.cluster.TdsqlDataSetInfo;
import com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.direct.cluster.TdsqlDataSetUtil;
import com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.direct.exception.TdsqlSyncBackendTopoException;
import com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.direct.listener.TdsqlFailoverTdsqlCacheListener;
import com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.direct.listener.TdsqlScheduleTdsqlCacheListener;
import com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.util.AbstractTdsqlCaughtRunnable;
import com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.util.TdsqlAtomicLongMap;
import com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.util.TdsqlSynchronousExecutor;
import com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.util.TdsqlThreadFactoryBuilder;
import com.tencentcloud.tdsql.mysql.cj.util.StringUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class TdsqlDirectTopoServer {
    private ScheduledThreadPoolExecutor topoServerScheduler = null;
    private String tdsqlDirectReadWriteMode = "rw";
    private Integer tdsqlDirectMaxSlaveDelaySeconds = TdsqlDirectConst.TDSQL_DIRECT_MAX_SLAVE_DELAY_SECONDS;
    private Integer tdsqlDirectTopoRefreshIntervalMillis = TdsqlDirectConst.TDSQL_DIRECT_TOPO_REFRESH_INTERVAL_MILLIS;
    private Integer tdsqlDirectTopoRefreshConnTimeoutMillis = TdsqlDirectConst.TDSQL_DIRECT_TOPO_REFRESH_CONN_TIMEOUT_MILLIS;
    private Integer tdsqlDirectTopoRefreshStmtTimeoutSeconds = TdsqlDirectConst.TDSQL_DIRECT_TOPO_REFRESH_STMT_TIMEOUT_SECONDS;
    private Integer tdsqlDirectCloseConnTimeoutMillis = TdsqlDirectConst.TDSQL_DIRECT_CLOSE_CONN_TIMEOUT_MILLIS;
    private Connection proxyConnection;
    private ConnectionUrl connectionUrl = null;
    private final TdsqlAtomicLongMap<TdsqlHostInfo> scheduleQueue = TdsqlAtomicLongMap.create();
    private final ReentrantReadWriteLock refreshLock = new ReentrantReadWriteLock();
    private final AtomicBoolean topoServerInitialized = new AtomicBoolean(false);
    private final Executor netTimeoutExecutor = new TdsqlSynchronousExecutor();

    private TdsqlDirectTopoServer() {
    }

    public static TdsqlDirectTopoServer getInstance() {
        return SingletonInstance.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(ConnectionUrl connectionUrl) throws SQLException {
        this.refreshLock.writeLock().lock();
        try {
            Integer newTdsqlDirectCloseConnTimeoutMillis;
            Integer newTdsqlDirectTopoRefreshStmtTimeoutSeconds;
            Integer newTdsqlDirectTopoRefreshConnTimeoutMillis;
            Integer newTdsqlProxyTopoRefreshInterval;
            Integer newTdsqlMaxSlaveDelay;
            this.connectionUrl = connectionUrl;
            JdbcPropertySetImpl connProps = new JdbcPropertySetImpl();
            connProps.initializeProperties(connectionUrl.getConnectionArgumentsAsProperties());
            String newTdsqlReadWriteMode = connProps.getStringProperty(PropertyKey.tdsqlDirectReadWriteMode).getValue();
            if (!this.tdsqlDirectReadWriteMode.equalsIgnoreCase(newTdsqlReadWriteMode) && ("rw".equalsIgnoreCase(newTdsqlReadWriteMode) || "ro".equalsIgnoreCase(newTdsqlReadWriteMode))) {
                this.tdsqlDirectReadWriteMode = newTdsqlReadWriteMode;
            }
            if ("ro".equalsIgnoreCase(this.tdsqlDirectReadWriteMode) && !this.tdsqlDirectMaxSlaveDelaySeconds.equals(newTdsqlMaxSlaveDelay = connProps.getIntegerProperty(PropertyKey.tdsqlDirectMaxSlaveDelaySeconds).getValue()) && newTdsqlMaxSlaveDelay > 0 && newTdsqlMaxSlaveDelay < Integer.MAX_VALUE) {
                this.tdsqlDirectMaxSlaveDelaySeconds = newTdsqlMaxSlaveDelay;
            }
            if (!this.tdsqlDirectTopoRefreshIntervalMillis.equals(newTdsqlProxyTopoRefreshInterval = connProps.getIntegerProperty(PropertyKey.tdsqlDirectTopoRefreshIntervalMillis).getValue()) && newTdsqlProxyTopoRefreshInterval > 1000 && newTdsqlProxyTopoRefreshInterval < Integer.MAX_VALUE) {
                this.tdsqlDirectTopoRefreshIntervalMillis = newTdsqlProxyTopoRefreshInterval;
                if (this.topoServerInitialized.compareAndSet(true, false) && this.topoServerScheduler != null) {
                    this.topoServerScheduler.shutdown();
                }
            }
            if (!this.tdsqlDirectTopoRefreshConnTimeoutMillis.equals(newTdsqlDirectTopoRefreshConnTimeoutMillis = connProps.getIntegerProperty(PropertyKey.tdsqlDirectTopoRefreshConnTimeoutMillis).getValue()) && newTdsqlDirectTopoRefreshConnTimeoutMillis > 250 && newTdsqlDirectTopoRefreshConnTimeoutMillis < Integer.MAX_VALUE) {
                this.tdsqlDirectTopoRefreshConnTimeoutMillis = newTdsqlDirectTopoRefreshConnTimeoutMillis;
            }
            if (!this.tdsqlDirectTopoRefreshStmtTimeoutSeconds.equals(newTdsqlDirectTopoRefreshStmtTimeoutSeconds = connProps.getIntegerProperty(PropertyKey.tdsqlDirectTopoRefreshStmtTimeoutSeconds).getValue()) && newTdsqlDirectTopoRefreshStmtTimeoutSeconds > 0 && newTdsqlDirectTopoRefreshStmtTimeoutSeconds < Integer.MAX_VALUE) {
                this.tdsqlDirectTopoRefreshStmtTimeoutSeconds = newTdsqlDirectTopoRefreshStmtTimeoutSeconds;
            }
            if (!this.tdsqlDirectCloseConnTimeoutMillis.equals(newTdsqlDirectCloseConnTimeoutMillis = connProps.getIntegerProperty(PropertyKey.tdsqlDirectCloseConnTimeoutMillis).getValue()) && newTdsqlDirectCloseConnTimeoutMillis > 250 && newTdsqlDirectCloseConnTimeoutMillis < Integer.MAX_VALUE) {
                this.tdsqlDirectCloseConnTimeoutMillis = newTdsqlDirectCloseConnTimeoutMillis;
            }
            if (this.topoServerInitialized.compareAndSet(false, true)) {
                this.createProxyConnection();
                this.initializeScheduler();
                TdsqlDataSetCache.getInstance().addListener(new TdsqlScheduleTdsqlCacheListener(this.tdsqlDirectReadWriteMode, this.scheduleQueue, connectionUrl));
                TdsqlDataSetCache.getInstance().addListener(new TdsqlFailoverTdsqlCacheListener(this.tdsqlDirectReadWriteMode));
            }
        }
        finally {
            this.refreshLock.writeLock().unlock();
        }
        if (!TdsqlDataSetCache.getInstance().waitCached(1, 60)) {
            String errMsg = "wait tdsql topology timeout";
            TdsqlDirectLoggerFactory.logError(errMsg);
            throw new TdsqlSyncBackendTopoException(errMsg);
        }
    }

    private void createProxyConnection() throws SQLException {
        TdsqlDirectLoggerFactory.logDebug("Start create proxy connection for refresh topology!");
        if (this.proxyConnection != null && !this.proxyConnection.isClosed() && this.proxyConnection.isValid(1)) {
            TdsqlDirectLoggerFactory.logDebug("Proxy connection seems perfect, NOOP!");
            return;
        }
        String errMsg = "Create proxy connection for refresh topology error!";
        HashMap<String, String> config = new HashMap<String, String>(8);
        config.put(PropertyKey.connectTimeout.getKeyName(), "2000");
        config.put(PropertyKey.socketTimeout.getKeyName(), "2000");
        config.put(PropertyKey.maxAllowedPacket.getKeyName(), "65535000");
        config.put(PropertyKey.retriesAllDown.getKeyName(), "4");
        config.put(PropertyKey.loadBalanceBlocklistTimeout.getKeyName(), "30000");
        config.put(PropertyKey.loadBalanceAutoCommitStatementThreshold.getKeyName(), "1");
        config.put(PropertyKey.loadBalancePingTimeout.getKeyName(), "1000");
        config.put(PropertyKey.loadBalanceValidateConnectionOnSwapServer.getKeyName(), "true");
        LoadBalanceConnectionUrl myConnUrl = new LoadBalanceConnectionUrl(this.connectionUrl.getHostsList(), config);
        try {
            this.proxyConnection = LoadBalancedConnectionProxy.createProxyInstance(myConnUrl);
            if (this.proxyConnection.isClosed() || !this.proxyConnection.isValid(1)) {
                TdsqlDirectLoggerFactory.logError(errMsg);
                throw SQLError.createSQLException(Messages.getString("Connection.UnableToConnect"), "08001", null);
            }
            TdsqlDirectLoggerFactory.setLogger(((JdbcConnection)this.proxyConnection).getSession().getLog());
        }
        catch (SQLException e) {
            TdsqlDirectLoggerFactory.logError("[" + errMsg + "]" + e.getMessage(), e);
            throw e;
        }
        TdsqlDirectLoggerFactory.logDebug("Finish create proxy connection for refresh topology!");
    }

    private void getTopology() throws SQLException {
        if (this.proxyConnection == null || this.proxyConnection.isClosed() || !this.proxyConnection.isValid(1)) {
            TdsqlDirectLoggerFactory.logDebug("Proxy connection is invalid, reconnection it!");
            try {
                this.proxyConnection.close();
            }
            catch (SQLException sQLException) {
            }
            finally {
                this.createProxyConnection();
            }
        }
        ArrayList<TdsqlDataSetCluster> tdsqlDataSetClusters = new ArrayList<TdsqlDataSetCluster>();
        this.proxyConnection.setNetworkTimeout(this.netTimeoutExecutor, this.tdsqlDirectTopoRefreshConnTimeoutMillis);
        try (Statement stmt = this.proxyConnection.createStatement();){
            stmt.setQueryTimeout(this.tdsqlDirectTopoRefreshStmtTimeoutSeconds);
            try (ResultSet rs = stmt.executeQuery("/*proxy*/ show routes");){
                while (rs.next()) {
                    String slaves;
                    String clusterName = rs.getString("cluster_name");
                    if (StringUtils.isNullOrEmpty(clusterName)) {
                        String errMsg = "Invalid topology info: cluster name is empty!";
                        TdsqlDirectLoggerFactory.logError(errMsg);
                        throw new TdsqlSyncBackendTopoException(errMsg);
                    }
                    String master = rs.getString("master_ip");
                    if (StringUtils.isNullOrEmpty(master) && "rw".equalsIgnoreCase(this.tdsqlDirectReadWriteMode)) {
                        TdsqlDirectLoggerFactory.logWarn("Topology info maybe has some error: In RW mode, master ip is empty!");
                    }
                    if (StringUtils.isNullOrEmpty(slaves = rs.getString("slave_iplist")) && "ro".equalsIgnoreCase(this.tdsqlDirectReadWriteMode)) {
                        TdsqlDirectLoggerFactory.logWarn("Topology info maybe has some error: In RO mode, slave ip list is empty!");
                    }
                    TdsqlDirectLoggerFactory.logInfo("Topo info cluster name: " + clusterName + ", master: " + master + ", slaves: " + slaves);
                    TdsqlDataSetCluster tdsqlDataSetCluster = new TdsqlDataSetCluster(clusterName);
                    tdsqlDataSetCluster.setMaster(TdsqlDataSetUtil.parseMaster(master));
                    tdsqlDataSetCluster.setSlaves(TdsqlDataSetUtil.parseSlaveList(slaves));
                    tdsqlDataSetClusters.add(tdsqlDataSetCluster);
                }
            }
        }
        if (tdsqlDataSetClusters.isEmpty()) {
            String errMsg = "No backend cluster found with command: /*proxy*/ show routes";
            TdsqlDirectLoggerFactory.logError(errMsg);
            throw new TdsqlSyncBackendTopoException(errMsg);
        }
        TdsqlDataSetCache cache = TdsqlDataSetCache.getInstance();
        if (((TdsqlDataSetCluster)tdsqlDataSetClusters.get(0)).getMaster() != null) {
            cache.setMasters(Collections.singletonList(((TdsqlDataSetCluster)tdsqlDataSetClusters.get(0)).getMaster()));
        } else {
            cache.setMasters(new ArrayList<TdsqlDataSetInfo>());
        }
        cache.setSlaves(((TdsqlDataSetCluster)tdsqlDataSetClusters.get(0)).getSlaves());
    }

    private void initializeScheduler() {
        this.topoServerScheduler = new ScheduledThreadPoolExecutor(1, new TdsqlThreadFactoryBuilder().setDaemon(true).setNameFormat("TopoServer-pool-%d").build());
        this.topoServerScheduler.scheduleWithFixedDelay(new TopoRefreshTask(), 0L, this.tdsqlDirectTopoRefreshIntervalMillis.intValue(), TimeUnit.MILLISECONDS);
    }

    public String getTdsqlDirectReadWriteMode() {
        return this.tdsqlDirectReadWriteMode;
    }

    public Integer getTdsqlDirectMaxSlaveDelaySeconds() {
        return this.tdsqlDirectMaxSlaveDelaySeconds;
    }

    public Integer getTdsqlDirectTopoRefreshIntervalMillis() {
        return this.tdsqlDirectTopoRefreshIntervalMillis;
    }

    public ReentrantReadWriteLock getRefreshLock() {
        return this.refreshLock;
    }

    public TdsqlAtomicLongMap<TdsqlHostInfo> getScheduleQueue() {
        return this.scheduleQueue;
    }

    public Integer getTdsqlDirectCloseConnTimeoutMillis() {
        return this.tdsqlDirectCloseConnTimeoutMillis;
    }

    private static class SingletonInstance {
        private static final TdsqlDirectTopoServer INSTANCE = new TdsqlDirectTopoServer();

        private SingletonInstance() {
        }
    }

    private static class TopoRefreshTask
    extends AbstractTdsqlCaughtRunnable {
        private TopoRefreshTask() {
        }

        @Override
        public void caughtAndRun() {
            String proxyHost = ((JdbcConnection)TdsqlDirectTopoServer.getInstance().proxyConnection).getHostPortPair();
            TdsqlDirectLoggerFactory.logDebug("Start topology refresh task. Request proxy: [" + proxyHost + "]");
            try {
                TdsqlDirectTopoServer.getInstance().getTopology();
            }
            catch (Exception e) {
                TdsqlDirectLoggerFactory.logError(e.getMessage(), e);
            }
            TdsqlDirectLoggerFactory.logDebug("Finish topology refresh task. Request proxy: [" + proxyHost + "]");
        }
    }
}

