/*
 * Decompiled with CFR 0.152.
 */
package com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.direct.cluster;

import com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.direct.TdsqlDirectLoggerFactory;
import com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.direct.TdsqlDirectTopoServer;
import com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.direct.cluster.TdsqlDataSetInfo;
import com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.direct.cluster.TdsqlDataSetUtil;
import com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.util.TdsqlWaitUtil;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class TdsqlDataSetCache {
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private final List<TdsqlDataSetInfo> masters = new CopyOnWriteArrayList<TdsqlDataSetInfo>();
    private final List<TdsqlDataSetInfo> slaves = new CopyOnWriteArrayList<TdsqlDataSetInfo>();
    private boolean masterCached = false;
    private boolean slaveCached = false;
    public static final String MASTERS_PROPERTY_NAME = "masters";
    public static final String SLAVES_PROPERTY_NAME = "slaves";

    private TdsqlDataSetCache() {
    }

    public boolean waitCached(int interval, int count) {
        try {
            TdsqlWaitUtil.waitFor(interval, count, this::isCached);
        }
        catch (InterruptedException e) {
            TdsqlDirectLoggerFactory.logError("Wait cached timeout, " + e.getMessage(), e);
        }
        return this.isCached();
    }

    public void addListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public synchronized List<TdsqlDataSetInfo> getMasters() {
        TdsqlDirectTopoServer.getInstance().getRefreshLock().readLock().lock();
        try {
            List<TdsqlDataSetInfo> list = this.masters;
            return list;
        }
        finally {
            TdsqlDirectTopoServer.getInstance().getRefreshLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setMasters(List<TdsqlDataSetInfo> newMasters) {
        TdsqlDirectTopoServer topoServer = TdsqlDirectTopoServer.getInstance();
        topoServer.getRefreshLock().writeLock().lock();
        try {
            String tdsqlDirectReadWriteMode = topoServer.getTdsqlDirectReadWriteMode();
            if (newMasters.isEmpty()) {
                if ("ro".equalsIgnoreCase(tdsqlDirectReadWriteMode)) {
                    TdsqlDirectLoggerFactory.logWarn("After update, master is empty, but we in RO mode, so to be continue!");
                    if (!this.masterCached) {
                        this.masterCached = true;
                    }
                    return;
                }
                if ("rw".equalsIgnoreCase(tdsqlDirectReadWriteMode) && this.masters.isEmpty()) {
                    TdsqlDirectLoggerFactory.logWarn("After update, master is empty, although we in RW mode, cached master also empty, so to be continue!");
                    if (!this.masterCached) {
                        this.masterCached = true;
                    }
                    return;
                }
            }
            if (!newMasters.equals(this.masters)) {
                TdsqlDirectLoggerFactory.logDebug("DataSet master have changed, old: " + this.masters + ", new: " + newMasters);
                this.propertyChangeSupport.firePropertyChange(MASTERS_PROPERTY_NAME, TdsqlDataSetUtil.copyDataSetList(this.masters), TdsqlDataSetUtil.copyDataSetList(newMasters));
                this.masters.clear();
                this.masters.addAll(newMasters);
                if (!this.masterCached) {
                    this.masterCached = true;
                }
                TdsqlDirectLoggerFactory.logDebug("After update, master is: " + this.masters);
            }
        }
        finally {
            topoServer.getRefreshLock().writeLock().unlock();
        }
    }

    public synchronized List<TdsqlDataSetInfo> getSlaves() {
        TdsqlDirectTopoServer.getInstance().getRefreshLock().readLock().lock();
        try {
            List<TdsqlDataSetInfo> list = this.slaves;
            return list;
        }
        finally {
            TdsqlDirectTopoServer.getInstance().getRefreshLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setSlaves(List<TdsqlDataSetInfo> newSlaves) {
        TdsqlDirectTopoServer topoServer = TdsqlDirectTopoServer.getInstance();
        topoServer.getRefreshLock().writeLock().lock();
        try {
            Integer tdsqlMaxSlaveDelay;
            String tdsqlDirectReadWriteMode = topoServer.getTdsqlDirectReadWriteMode();
            if (newSlaves.isEmpty()) {
                if ("rw".equalsIgnoreCase(tdsqlDirectReadWriteMode)) {
                    TdsqlDirectLoggerFactory.logWarn("After update, slaves is empty, but we in RW mode, so to be continue!");
                    if (!this.slaveCached) {
                        this.slaveCached = true;
                    }
                    return;
                }
                if ("ro".equalsIgnoreCase(tdsqlDirectReadWriteMode) && this.slaves.isEmpty()) {
                    TdsqlDirectLoggerFactory.logWarn("After update, slaves is empty, although we in RO mode, cached slaves also empty, so to be continue!");
                    if (!this.slaveCached) {
                        this.slaveCached = true;
                    }
                    return;
                }
            }
            if ((tdsqlMaxSlaveDelay = topoServer.getTdsqlDirectMaxSlaveDelaySeconds()) > 0) {
                newSlaves.removeIf(dsInfo -> dsInfo.getDelay() >= (long)tdsqlMaxSlaveDelay.intValue());
            }
            if (!newSlaves.equals(this.slaves)) {
                TdsqlDirectLoggerFactory.logDebug("DataSet slave have changed, old: " + this.slaves + ", new: " + newSlaves);
                this.propertyChangeSupport.firePropertyChange(SLAVES_PROPERTY_NAME, TdsqlDataSetUtil.copyDataSetList(this.slaves), TdsqlDataSetUtil.copyDataSetList(newSlaves));
                this.slaves.clear();
                this.slaves.addAll(newSlaves);
                if (!this.slaveCached) {
                    this.slaveCached = true;
                }
                TdsqlDirectLoggerFactory.logDebug("After update, slaves is: " + this.slaves);
            }
        }
        finally {
            topoServer.getRefreshLock().writeLock().unlock();
        }
    }

    public boolean isCached() {
        return this.masterCached && this.slaveCached && !TdsqlDirectTopoServer.getInstance().getScheduleQueue().isEmpty();
    }

    public static TdsqlDataSetCache getInstance() {
        return SingletonInstance.INSTANCE;
    }

    private static class SingletonInstance {
        public static final TdsqlDataSetCache INSTANCE = new TdsqlDataSetCache();

        private SingletonInstance() {
        }
    }
}

