/*
 * Decompiled with CFR 0.152.
 */
package com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.direct.listener;

import com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.direct.TdsqlDirectFailoverOperator;
import com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.direct.TdsqlDirectLoggerFactory;
import com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.direct.TdsqlDirectMasterSlaveSwitchMode;
import com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.direct.TdsqlDirectReadWriteMode;
import com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.direct.cluster.TdsqlDataSetInfo;
import com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.direct.listener.AbstractTdsqlCacheListener;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class TdsqlFailoverTdsqlCacheListener
extends AbstractTdsqlCacheListener {
    private final String tdsqlReadWriteMode;

    public TdsqlFailoverTdsqlCacheListener(String tdsqlReadWriteMode) {
        this.tdsqlReadWriteMode = tdsqlReadWriteMode;
    }

    @Override
    public void handleMaster(List<TdsqlDataSetInfo> offLines, List<TdsqlDataSetInfo> onLines) {
        if (!offLines.isEmpty()) {
            TdsqlDirectLoggerFactory.logDebug("Offline master: " + offLines);
            List<String> toCloseList = offLines.stream().map(d -> String.format("%s:%s", d.getIp(), d.getPort())).collect(Collectors.toList());
            TdsqlDirectFailoverOperator.subsequentOperation(TdsqlDirectReadWriteMode.convert(this.tdsqlReadWriteMode), TdsqlDirectMasterSlaveSwitchMode.MASTER_SLAVE_SWITCH, toCloseList);
        }
    }

    @Override
    public void handleSlave(List<TdsqlDataSetInfo> offLines, List<TdsqlDataSetInfo> onLines) {
        ArrayList<String> toCloseList;
        if (!offLines.isEmpty()) {
            TdsqlDirectLoggerFactory.logDebug("Offline slaves: " + offLines);
            toCloseList = offLines.stream().map(d -> String.format("%s:%s", d.getIp(), d.getPort())).collect(Collectors.toList());
            TdsqlDirectFailoverOperator.subsequentOperation(TdsqlDirectReadWriteMode.convert(this.tdsqlReadWriteMode), TdsqlDirectMasterSlaveSwitchMode.SLAVE_OFFLINE, toCloseList);
        }
        if (!onLines.isEmpty()) {
            TdsqlDirectLoggerFactory.logDebug("Online slaves: " + onLines);
            toCloseList = new ArrayList();
            TdsqlDirectFailoverOperator.subsequentOperation(TdsqlDirectReadWriteMode.convert(this.tdsqlReadWriteMode), TdsqlDirectMasterSlaveSwitchMode.SLAVE_ONLINE, toCloseList);
        }
    }
}

