/*
 * Decompiled with CFR 0.152.
 */
package com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.direct.listener;

import com.tencentcloud.tdsql.mysql.cj.conf.ConnectionUrl;
import com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.TdsqlHostInfo;
import com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.direct.TdsqlDirectReadWriteMode;
import com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.direct.cluster.TdsqlDataSetInfo;
import com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.direct.cluster.TdsqlDataSetUtil;
import com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.direct.listener.AbstractTdsqlCacheListener;
import com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.util.TdsqlAtomicLongMap;
import java.util.List;

public class TdsqlScheduleTdsqlCacheListener
extends AbstractTdsqlCacheListener {
    private final TdsqlAtomicLongMap<TdsqlHostInfo> scheduleQueue;
    private final String tdsqlReadWriteMode;
    private final ConnectionUrl connectionUrl;

    public TdsqlScheduleTdsqlCacheListener(String tdsqlReadWriteMode, TdsqlAtomicLongMap<TdsqlHostInfo> scheduleQueue, ConnectionUrl connectionUrl) {
        this.tdsqlReadWriteMode = tdsqlReadWriteMode;
        this.scheduleQueue = scheduleQueue;
        this.connectionUrl = connectionUrl;
    }

    @Override
    public void handleMaster(List<TdsqlDataSetInfo> offLines, List<TdsqlDataSetInfo> onLines) {
        if (TdsqlDirectReadWriteMode.RW.equals((Object)TdsqlDirectReadWriteMode.convert(this.tdsqlReadWriteMode))) {
            TdsqlHostInfo tdsqlHostInfo;
            for (TdsqlDataSetInfo newMaster : onLines) {
                tdsqlHostInfo = TdsqlDataSetUtil.convertDataSetInfo(newMaster, this.connectionUrl);
                if (this.scheduleQueue.containsKey(tdsqlHostInfo)) continue;
                this.scheduleQueue.put(tdsqlHostInfo, 0L);
            }
            for (TdsqlDataSetInfo offLine : offLines) {
                tdsqlHostInfo = TdsqlDataSetUtil.convertDataSetInfo(offLine, this.connectionUrl);
                if (!this.scheduleQueue.containsKey(tdsqlHostInfo)) continue;
                this.scheduleQueue.remove(tdsqlHostInfo);
            }
        }
    }

    @Override
    public void handleSlave(List<TdsqlDataSetInfo> offLines, List<TdsqlDataSetInfo> onLines) {
        if (TdsqlDirectReadWriteMode.RW.equals((Object)TdsqlDirectReadWriteMode.convert(this.tdsqlReadWriteMode))) {
            // empty if block
        }
        if (TdsqlDirectReadWriteMode.RO.equals((Object)TdsqlDirectReadWriteMode.convert(this.tdsqlReadWriteMode))) {
            TdsqlHostInfo tdsqlHostInfo;
            for (TdsqlDataSetInfo slave : onLines) {
                tdsqlHostInfo = TdsqlDataSetUtil.convertDataSetInfo(slave, this.connectionUrl);
                if (this.scheduleQueue.containsKey(tdsqlHostInfo)) continue;
                this.scheduleQueue.put(tdsqlHostInfo, 0L);
            }
            for (TdsqlDataSetInfo oldSlave : offLines) {
                tdsqlHostInfo = TdsqlDataSetUtil.convertDataSetInfo(oldSlave, this.connectionUrl);
                if (!this.scheduleQueue.containsKey(tdsqlHostInfo)) continue;
                this.scheduleQueue.remove(tdsqlHostInfo);
            }
        }
    }
}

