/*
 * Decompiled with CFR 0.152.
 */
package com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.loadbalance;

import com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.TdsqlHostInfo;
import com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.TdsqlLoggerFactory;
import com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.loadbalance.TdsqlLoadBalanceConnectionCounter;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class TdsqlLoadBalanceBlacklistHolder {
    private final Set<TdsqlHostInfo> blacklist = new HashSet<TdsqlHostInfo>();
    private final ReentrantReadWriteLock blacklistLock = new ReentrantReadWriteLock();

    private TdsqlLoadBalanceBlacklistHolder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> printBlacklist() {
        this.blacklistLock.readLock().lock();
        try {
            HashSet<String> cloneSet = new HashSet<String>(this.blacklist.size());
            for (TdsqlHostInfo tdsqlHostInfo : this.blacklist) {
                cloneSet.add(tdsqlHostInfo.getHostPortPair());
            }
            Set set = Collections.unmodifiableSet(cloneSet);
            return set;
        }
        finally {
            this.blacklistLock.readLock().unlock();
        }
    }

    public void addBlacklist(TdsqlHostInfo tdsqlHostInfo) {
        this.blacklistLock.writeLock().lock();
        try {
            if (!this.blacklist.contains(tdsqlHostInfo)) {
                this.blacklist.add(tdsqlHostInfo);
                TdsqlLoggerFactory.logInfo("Add host to blacklist success and try remote it in counter, current blacklist [" + this.printBlacklist() + "]");
                TdsqlLoadBalanceConnectionCounter.getInstance().removeCounter(tdsqlHostInfo);
            } else {
                TdsqlLoggerFactory.logWarn("Add host to blacklist failed, because this host is already in blacklist , current blacklist [" + this.printBlacklist() + "]");
            }
        }
        finally {
            this.blacklistLock.writeLock().unlock();
        }
    }

    public void removeBlacklist(TdsqlHostInfo tdsqlHostInfo) {
        this.blacklistLock.writeLock().lock();
        try {
            if (this.blacklist.contains(tdsqlHostInfo)) {
                this.blacklist.remove(tdsqlHostInfo);
                TdsqlLoggerFactory.logInfo("Remove host from blacklist success and try reset it in counter, current blacklist [" + this.printBlacklist() + "]");
                TdsqlLoadBalanceConnectionCounter.getInstance().resetCounter(tdsqlHostInfo);
            } else {
                TdsqlLoggerFactory.logInfo("Don't need to remove host from blacklist, because its not in blacklist, current blacklist [" + this.printBlacklist() + "]");
            }
        }
        finally {
            this.blacklistLock.writeLock().unlock();
        }
    }

    public static TdsqlLoadBalanceBlacklistHolder getInstance() {
        return SingletonInstance.INSTANCE;
    }

    private static class SingletonInstance {
        private static final TdsqlLoadBalanceBlacklistHolder INSTANCE = new TdsqlLoadBalanceBlacklistHolder();

        private SingletonInstance() {
        }
    }
}

