/*
 * Decompiled with CFR 0.152.
 */
package com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.loadbalance;

import com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.TdsqlHostInfo;
import com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.TdsqlLoggerFactory;
import com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.loadbalance.TdsqlLoadBalanceInfo;
import com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.util.TdsqlAtomicLongMap;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class TdsqlLoadBalanceConnectionCounter {
    private final Map<String, TdsqlAtomicLongMap<TdsqlHostInfo>> counterDatasourceMap = new HashMap<String, TdsqlAtomicLongMap<TdsqlHostInfo>>();
    private final ReentrantReadWriteLock counterLock = new ReentrantReadWriteLock();

    private TdsqlLoadBalanceConnectionCounter() {
    }

    public void initialize(TdsqlLoadBalanceInfo tdsqlLoadBalanceInfo) {
        String datasourceUuid = tdsqlLoadBalanceInfo.getDatasourceUuid();
        if (!this.counterDatasourceMap.containsKey(datasourceUuid)) {
            TdsqlAtomicLongMap<TdsqlHostInfo> counter = TdsqlAtomicLongMap.create();
            for (TdsqlHostInfo tdsqlHostInfo : tdsqlLoadBalanceInfo.getTdsqlHostInfoList()) {
                counter.put(tdsqlHostInfo, 0L);
            }
            this.counterDatasourceMap.put(datasourceUuid, counter);
            TdsqlLoggerFactory.logInfo("New datasource add in counter [" + datasourceUuid + "], current counter [" + this.printCounter() + "]");
        }
    }

    public TdsqlAtomicLongMap<TdsqlHostInfo> getCounter(String datasourceUuid) {
        this.counterLock.readLock().lock();
        try {
            TdsqlAtomicLongMap<TdsqlHostInfo> tdsqlAtomicLongMap = this.counterDatasourceMap.get(datasourceUuid);
            return tdsqlAtomicLongMap;
        }
        finally {
            this.counterLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementCounter(TdsqlHostInfo tdsqlHostInfo) {
        this.counterLock.writeLock().lock();
        try {
            TdsqlAtomicLongMap<TdsqlHostInfo> counter = this.counterDatasourceMap.get(tdsqlHostInfo.getOwnerUuid());
            if (!counter.containsKey(tdsqlHostInfo)) {
                counter.put(tdsqlHostInfo, 1L);
                TdsqlLoggerFactory.logInfo("Increment counter to 1 success [" + tdsqlHostInfo.getHostPortPair() + "], current counter [" + this.printCounter() + "]");
            } else {
                long currCount = counter.incrementAndGet(tdsqlHostInfo);
                TdsqlLoggerFactory.logInfo("Increment counter to " + currCount + " success [" + tdsqlHostInfo.getHostPortPair() + "], current counter [" + this.printCounter() + "]");
            }
        }
        finally {
            this.counterLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrementCounter(TdsqlHostInfo tdsqlHostInfo) {
        this.counterLock.writeLock().lock();
        try {
            TdsqlAtomicLongMap<TdsqlHostInfo> counter = this.counterDatasourceMap.get(tdsqlHostInfo.getOwnerUuid());
            if (!counter.containsKey(tdsqlHostInfo)) {
                counter.put(tdsqlHostInfo, 0L);
                TdsqlLoggerFactory.logInfo("Decrement counter to 0 success [" + tdsqlHostInfo.getHostPortPair() + "], current counter [" + this.printCounter() + "]");
            } else {
                long currCount = counter.decrementAndGet(tdsqlHostInfo);
                if (currCount < 0L) {
                    counter.put(tdsqlHostInfo, 0L);
                }
                TdsqlLoggerFactory.logInfo("Decrement counter to " + currCount + " success [" + tdsqlHostInfo.getHostPortPair() + "], current counter [" + this.printCounter() + "]");
            }
        }
        finally {
            this.counterLock.writeLock().unlock();
        }
    }

    public void resetCounter(TdsqlHostInfo tdsqlHostInfo) {
        this.counterLock.writeLock().lock();
        try {
            TdsqlAtomicLongMap<TdsqlHostInfo> counter = this.counterDatasourceMap.get(tdsqlHostInfo.getOwnerUuid());
            counter.put(tdsqlHostInfo, 0L);
            TdsqlLoggerFactory.logInfo("Reset counter to 0 success [" + tdsqlHostInfo.getHostPortPair() + "], current counter [" + this.printCounter() + "]");
        }
        finally {
            this.counterLock.writeLock().unlock();
        }
    }

    public void removeCounter(TdsqlHostInfo tdsqlHostInfo) {
        this.counterLock.writeLock().lock();
        try {
            TdsqlAtomicLongMap<TdsqlHostInfo> counter = this.counterDatasourceMap.get(tdsqlHostInfo.getOwnerUuid());
            if (counter.containsKey(tdsqlHostInfo)) {
                counter.remove(tdsqlHostInfo);
                TdsqlLoggerFactory.logInfo("Remove counter success [" + tdsqlHostInfo.getHostPortPair() + "], current counter [" + this.printCounter() + "]");
            }
        }
        finally {
            this.counterLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String printCounter() {
        this.counterLock.readLock().lock();
        try {
            StringBuilder print = new StringBuilder();
            for (Map.Entry<String, TdsqlAtomicLongMap<TdsqlHostInfo>> entry : this.counterDatasourceMap.entrySet()) {
                String datasourceUuid = entry.getKey();
                TdsqlAtomicLongMap<TdsqlHostInfo> value = entry.getValue();
                StringJoiner hostCount = new StringJoiner(", ");
                for (Map.Entry<TdsqlHostInfo, Long> mapEntry : value.asMap().entrySet()) {
                    String hostPortPair = mapEntry.getKey().getHostPortPair();
                    Long count = mapEntry.getValue();
                    hostCount.add(hostPortPair + "=" + count);
                }
                print.append(datasourceUuid).append("{").append(hostCount).append("}");
            }
            String string = print.toString();
            return string;
        }
        finally {
            this.counterLock.readLock().unlock();
        }
    }

    public ReentrantReadWriteLock getCounterLock() {
        return this.counterLock;
    }

    public static TdsqlLoadBalanceConnectionCounter getInstance() {
        return SingletonInstance.INSTANCE;
    }

    private static class SingletonInstance {
        private static final TdsqlLoadBalanceConnectionCounter INSTANCE = new TdsqlLoadBalanceConnectionCounter();

        private SingletonInstance() {
        }
    }
}

