/*
 * Decompiled with CFR 0.152.
 */
package com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.loadbalance;

import com.tencentcloud.tdsql.mysql.cj.Messages;
import com.tencentcloud.tdsql.mysql.cj.conf.ConnectionUrl;
import com.tencentcloud.tdsql.mysql.cj.conf.HostInfo;
import com.tencentcloud.tdsql.mysql.cj.conf.PropertyKey;
import com.tencentcloud.tdsql.mysql.cj.jdbc.ConnectionImpl;
import com.tencentcloud.tdsql.mysql.cj.jdbc.JdbcConnection;
import com.tencentcloud.tdsql.mysql.cj.jdbc.exceptions.SQLError;
import com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.TdsqlHostInfo;
import com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.TdsqlLoggerFactory;
import com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.TdsqlSedBalanceStrategy;
import com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.loadbalance.TdsqlLoadBalanceBlacklistHolder;
import com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.loadbalance.TdsqlLoadBalanceConnectionCounter;
import com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.loadbalance.TdsqlLoadBalanceConst;
import com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.loadbalance.TdsqlLoadBalanceHeartbeatMonitor;
import com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.loadbalance.TdsqlLoadBalanceInfo;
import com.tencentcloud.tdsql.mysql.cj.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public final class TdsqlLoadBalanceConnectionFactory {
    public static boolean tdsqlLoadBalanceMode = false;

    private TdsqlLoadBalanceConnectionFactory() {
    }

    public JdbcConnection createConnection(ConnectionUrl connectionUrl) throws SQLException {
        tdsqlLoadBalanceMode = true;
        TdsqlLoggerFactory.logDebug("Receive one of create load balance request. [" + connectionUrl + "]");
        Properties props = connectionUrl.getConnectionArgumentsAsProperties();
        List<HostInfo> hostsList = connectionUrl.getHostsList();
        int numHosts = hostsList.size();
        ArrayList<TdsqlHostInfo> tdsqlHostInfoList = new ArrayList<TdsqlHostInfo>(numHosts);
        for (HostInfo hostInfo : hostsList) {
            tdsqlHostInfoList.add(new TdsqlHostInfo(hostInfo));
        }
        TdsqlLoadBalanceInfo tdsqlLoadBalanceInfo = this.validateConnectionAttributes(props, tdsqlHostInfoList, numHosts);
        return this.createNewConnection(tdsqlLoadBalanceInfo);
    }

    private synchronized JdbcConnection createNewConnection(TdsqlLoadBalanceInfo tdsqlLoadBalanceInfo) throws SQLException {
        TdsqlSedBalanceStrategy strategy;
        TdsqlHostInfo choice;
        TdsqlLoadBalanceConnectionCounter.getInstance().initialize(tdsqlLoadBalanceInfo);
        if (tdsqlLoadBalanceInfo.isTdsqlLoadBalanceHeartbeatMonitorEnable()) {
            TdsqlLoadBalanceHeartbeatMonitor.getInstance().initialize(tdsqlLoadBalanceInfo);
            CountDownLatch firstCheckFinished = TdsqlLoadBalanceHeartbeatMonitor.getInstance().getFirstCheckFinished(tdsqlLoadBalanceInfo.getDatasourceUuid());
            if (firstCheckFinished.getCount() != 0L) {
                try {
                    boolean await = firstCheckFinished.await((long)(tdsqlLoadBalanceInfo.getTdsqlHostInfoList().size() * (tdsqlLoadBalanceInfo.getTdsqlLoadBalanceHeartbeatMaxErrorRetries() + 1)) * 2L, TimeUnit.SECONDS);
                    if (!await) {
                        String errMessage = "Wait for first heartbeat check finished timeout!";
                        TdsqlLoggerFactory.logError(errMessage);
                        throw SQLError.createSQLException(errMessage, "08001", null);
                    }
                    TdsqlLoggerFactory.logInfo("All host in current datasource has finished first heartbeat checked! Current blacklist [" + TdsqlLoadBalanceBlacklistHolder.getInstance().printBlacklist() + "]");
                }
                catch (InterruptedException e) {
                    String errMessage = "Wait for first heartbeat check finished timeout!";
                    TdsqlLoggerFactory.logError(errMessage, e);
                    throw SQLError.createSQLException(errMessage, "08001", null);
                }
            }
        }
        if ((choice = (strategy = new TdsqlSedBalanceStrategy()).choice(TdsqlLoadBalanceConnectionCounter.getInstance().getCounter(tdsqlLoadBalanceInfo.getDatasourceUuid()))) == null) {
            String errMessage = "Could not create connection to database server. Because all hosts in blacklist [" + TdsqlLoadBalanceBlacklistHolder.getInstance().printBlacklist() + "]";
            TdsqlLoggerFactory.logFatal(errMessage);
            throw SQLError.createSQLException(errMessage, "08001", null);
        }
        try {
            JdbcConnection connection = ConnectionImpl.getInstance(choice);
            TdsqlLoadBalanceConnectionCounter.getInstance().incrementCounter(choice);
            TdsqlLoggerFactory.logInfo("Create connection success [" + choice.getHostPortPair() + "], return it.");
            return connection;
        }
        catch (SQLException e) {
            TdsqlLoggerFactory.logError("Could not create connection to database server [" + choice.getHostPortPair() + "], try add to blacklist.", e);
            TdsqlLoadBalanceBlacklistHolder.getInstance().addBlacklist(choice);
            throw e;
        }
    }

    public static TdsqlLoadBalanceConnectionFactory getInstance() {
        return SingletonInstance.INSTANCE;
    }

    private TdsqlLoadBalanceInfo validateConnectionAttributes(Properties props, List<TdsqlHostInfo> tdsqlHostInfoList, int numHosts) throws SQLException {
        TdsqlLoadBalanceInfo tdsqlLoadBalanceInfo = new TdsqlLoadBalanceInfo();
        tdsqlLoadBalanceInfo.setTdsqlHostInfoList(tdsqlHostInfoList);
        String tdsqlLoadBalanceStrategyStr = props.getProperty(PropertyKey.tdsqlLoadBalanceStrategy.getKeyName());
        if (!"sed".equalsIgnoreCase(tdsqlLoadBalanceStrategyStr)) {
            String errMessage = Messages.getString("ConnectionProperties.badValueForTdsqlLoadBalanceStrategy", new Object[]{tdsqlLoadBalanceStrategyStr}) + Messages.getString("ConnectionProperties.tdsqlLoadBalanceStrategy");
            TdsqlLoggerFactory.logError(errMessage);
            throw SQLError.createSQLException(errMessage, "01S00", null);
        }
        ArrayList<Integer> tdsqlLoadBalanceWeightFactorList = new ArrayList<Integer>(numHosts);
        for (int i = 0; i < numHosts; ++i) {
            tdsqlLoadBalanceWeightFactorList.add(1);
        }
        String tdsqlLoadBalanceWeightFactorStr = props.getProperty(PropertyKey.tdsqlLoadBalanceWeightFactor.getKeyName(), null);
        if (!StringUtils.isNullOrEmpty(tdsqlLoadBalanceWeightFactorStr)) {
            List<String> factorArray = StringUtils.split(tdsqlLoadBalanceWeightFactorStr, ",", true);
            for (int i = 0; i < factorArray.size() && i < numHosts; ++i) {
                try {
                    int wf = Integer.parseInt(factorArray.get(i));
                    if (wf < 0) {
                        String errMessage = Messages.getString("ConnectionProperties.badValueForTdsqlLoadBalanceWeightFactor", new Object[]{factorArray.get(i)}) + Messages.getString("ConnectionProperties.tdsqlLoadBalanceWeightFactor");
                        TdsqlLoggerFactory.logError(errMessage);
                        throw SQLError.createSQLException(errMessage, "01S00", null);
                    }
                    tdsqlLoadBalanceWeightFactorList.set(i, wf);
                    continue;
                }
                catch (NumberFormatException e) {
                    String errMessage = Messages.getString("ConnectionProperties.badValueForTdsqlLoadBalanceWeightFactor", new Object[]{factorArray.get(i)}) + Messages.getString("ConnectionProperties.tdsqlLoadBalanceWeightFactor");
                    TdsqlLoggerFactory.logError(errMessage, e);
                    throw SQLError.createSQLException(errMessage, "01S00", null);
                }
            }
        }
        tdsqlLoadBalanceInfo.setTdsqlLoadBalanceWeightFactorList(tdsqlLoadBalanceWeightFactorList);
        for (int i = 0; i < numHosts; ++i) {
            tdsqlHostInfoList.get(i).setWeightFactor((Integer)tdsqlLoadBalanceWeightFactorList.get(i));
        }
        String tdsqlLoadBalanceHeartbeatMonitorStr = props.getProperty(PropertyKey.tdsqlLoadBalanceHeartbeatMonitorEnable.getKeyName(), String.valueOf(TdsqlLoadBalanceConst.DEFAULT_TDSQL_LOAD_BALANCE_HEARTBEAT_MONITOR_ENABLE));
        try {
            if (!"true".equalsIgnoreCase(tdsqlLoadBalanceHeartbeatMonitorStr) && !"false".equalsIgnoreCase(tdsqlLoadBalanceHeartbeatMonitorStr)) {
                String errMessage = Messages.getString("ConnectionProperties.badValueForTdsqlLoadBalanceHeartbeatMonitorEnable", new Object[]{tdsqlLoadBalanceHeartbeatMonitorStr}) + Messages.getString("ConnectionProperties.tdsqlLoadBalanceHeartbeatMonitorEnable");
                TdsqlLoggerFactory.logError(errMessage);
                throw SQLError.createSQLException(errMessage, "01S00", null);
            }
            boolean tdsqlLoadBalanceHeartbeatMonitor = Boolean.parseBoolean(tdsqlLoadBalanceHeartbeatMonitorStr);
            tdsqlLoadBalanceInfo.setTdsqlLoadBalanceHeartbeatMonitorEnable(tdsqlLoadBalanceHeartbeatMonitor);
        }
        catch (Exception e) {
            String errMessage = Messages.getString("ConnectionProperties.badValueForTdsqlLoadBalanceHeartbeatMonitorEnable", new Object[]{tdsqlLoadBalanceHeartbeatMonitorStr}) + Messages.getString("ConnectionProperties.tdsqlLoadBalanceHeartbeatMonitorEnable");
            TdsqlLoggerFactory.logError(errMessage, e);
            throw SQLError.createSQLException(errMessage, "01S00", null);
        }
        String tdsqlLoadBalanceHeartbeatIntervalTimeStr = props.getProperty(PropertyKey.tdsqlLoadBalanceHeartbeatIntervalTimeMillis.getKeyName(), String.valueOf(TdsqlLoadBalanceConst.DEFAULT_TDSQL_LOAD_BALANCE_HEARTBEAT_INTERVAL_TIME_MILLIS));
        try {
            int tdsqlLoadBalanceHeartbeatIntervalTime = Integer.parseInt(tdsqlLoadBalanceHeartbeatIntervalTimeStr);
            if (tdsqlLoadBalanceHeartbeatIntervalTime < 1000) {
                String errMessage = Messages.getString("ConnectionProperties.badValueForTdsqlLoadBalanceHeartbeatIntervalTimeMillis", new Object[]{tdsqlLoadBalanceHeartbeatIntervalTimeStr}) + Messages.getString("ConnectionProperties.tdsqlLoadBalanceHeartbeatIntervalTimeMillis");
                TdsqlLoggerFactory.logError(errMessage);
                throw SQLError.createSQLException(errMessage, "01S00", null);
            }
            tdsqlLoadBalanceInfo.setTdsqlLoadBalanceHeartbeatIntervalTimeMillis(tdsqlLoadBalanceHeartbeatIntervalTime);
        }
        catch (NumberFormatException e) {
            String errMessage = Messages.getString("ConnectionProperties.badValueForTdsqlLoadBalanceHeartbeatIntervalTimeMillis", new Object[]{tdsqlLoadBalanceHeartbeatIntervalTimeStr}) + Messages.getString("ConnectionProperties.tdsqlLoadBalanceHeartbeatIntervalTimeMillis");
            TdsqlLoggerFactory.logError(errMessage, e);
            throw SQLError.createSQLException(errMessage, "01S00", null);
        }
        String tdsqlLoadBalanceMaximumErrorRetriesStr = props.getProperty(PropertyKey.tdsqlLoadBalanceHeartbeatMaxErrorRetries.getKeyName(), String.valueOf(TdsqlLoadBalanceConst.DEFAULT_TDSQL_LOAD_BALANCE_HEARTBEAT_MAX_ERROR_RETRIES));
        try {
            int tdsqlLoadBalanceMaximumErrorRetries = Integer.parseInt(tdsqlLoadBalanceMaximumErrorRetriesStr);
            if (tdsqlLoadBalanceMaximumErrorRetries <= 0) {
                String errMessage = Messages.getString("ConnectionProperties.badValueForTdsqlLoadBalanceHeartbeatMaxErrorRetries", new Object[]{tdsqlLoadBalanceMaximumErrorRetriesStr}) + Messages.getString("ConnectionProperties.tdsqlLoadBalanceHeartbeatMaxErrorRetries");
                TdsqlLoggerFactory.logError(errMessage);
                throw SQLError.createSQLException(errMessage, "01S00", null);
            }
            tdsqlLoadBalanceInfo.setTdsqlLoadBalanceHeartbeatMaxErrorRetries(tdsqlLoadBalanceMaximumErrorRetries);
        }
        catch (NumberFormatException e) {
            String errMessage = Messages.getString("ConnectionProperties.badValueForTdsqlLoadBalanceHeartbeatMaxErrorRetries", new Object[]{tdsqlLoadBalanceMaximumErrorRetriesStr}) + Messages.getString("ConnectionProperties.tdsqlLoadBalanceHeartbeatMaxErrorRetries");
            TdsqlLoggerFactory.logError(errMessage, e);
            throw SQLError.createSQLException(errMessage, "01S00", null);
        }
        String tdsqlLoadBalanceHeartbeatErrorRetryIntervalTimeMillisStr = props.getProperty(PropertyKey.tdsqlLoadBalanceHeartbeatErrorRetryIntervalTimeMillis.getKeyName(), String.valueOf(TdsqlLoadBalanceConst.DEFAULT_TDSQL_LOAD_BALANCE_HEARTBEAT_ERROR_RETRY_INTERVAL_TIME_MILLIS));
        try {
            int tdsqlLoadBalanceHeartbeatErrorRetryIntervalTimeMillis = Integer.parseInt(tdsqlLoadBalanceHeartbeatErrorRetryIntervalTimeMillisStr);
            if (tdsqlLoadBalanceHeartbeatErrorRetryIntervalTimeMillis < 0 || tdsqlLoadBalanceHeartbeatErrorRetryIntervalTimeMillis > 0 && tdsqlLoadBalanceHeartbeatErrorRetryIntervalTimeMillis < 100) {
                String errMessage = Messages.getString("ConnectionProperties.badValueForTdsqlLoadBalanceHeartbeatErrorRetryIntervalTimeMillis", new Object[]{tdsqlLoadBalanceHeartbeatErrorRetryIntervalTimeMillisStr}) + Messages.getString("ConnectionProperties.tdsqlLoadBalanceHeartbeatErrorRetryIntervalTimeMillis");
                TdsqlLoggerFactory.logError(errMessage);
                throw SQLError.createSQLException(errMessage, "01S00", null);
            }
            tdsqlLoadBalanceInfo.setTdsqlLoadBalanceHeartbeatErrorRetryIntervalTimeMillis(tdsqlLoadBalanceHeartbeatErrorRetryIntervalTimeMillis);
        }
        catch (NumberFormatException e) {
            String errMessage = Messages.getString("ConnectionProperties.badValueForTdsqlLoadBalanceHeartbeatErrorRetryIntervalTimeMillis", new Object[]{tdsqlLoadBalanceHeartbeatErrorRetryIntervalTimeMillisStr}) + Messages.getString("ConnectionProperties.tdsqlLoadBalanceHeartbeatErrorRetryIntervalTimeMillis");
            TdsqlLoggerFactory.logError(errMessage, e);
            throw SQLError.createSQLException(errMessage, "01S00", null);
        }
        return tdsqlLoadBalanceInfo;
    }

    public void closeConnection(TdsqlHostInfo tdsqlHostInfo) {
        TdsqlLoggerFactory.logInfo("Close method called. [" + tdsqlHostInfo.getHostPortPair() + "]");
        TdsqlLoadBalanceConnectionCounter.getInstance().decrementCounter(tdsqlHostInfo);
    }

    private static class SingletonInstance {
        private static final TdsqlLoadBalanceConnectionFactory INSTANCE = new TdsqlLoadBalanceConnectionFactory();

        private SingletonInstance() {
        }
    }
}

