/*
 * Decompiled with CFR 0.152.
 */
package com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.loadbalance;

import com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.TdsqlHostInfo;
import com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.TdsqlLoggerFactory;
import com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.loadbalance.TdsqlLoadBalanceInfo;
import com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.util.TdsqlThreadFactoryBuilder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class TdsqlLoadBalanceHeartbeatMonitor {
    private boolean heartbeatMonitorInitialized = false;
    private ScheduledThreadPoolExecutor heartbeatMonitor;
    private Set<TdsqlHostInfo> monitoredTdsqlHostInfoSet;
    private volatile Map<String, CountDownLatch> firstCheckFinishedMap;

    private TdsqlLoadBalanceHeartbeatMonitor() {
    }

    public void initialize(TdsqlLoadBalanceInfo tdsqlLoadBalanceInfo) {
        String datasourceUuid;
        if (!this.heartbeatMonitorInitialized) {
            TdsqlLoggerFactory.logInfo("Heartbeat monitor initializing.");
            this.heartbeatMonitor = new ScheduledThreadPoolExecutor(10, new TdsqlThreadFactoryBuilder().setDaemon(true).setNameFormat("Heartbeat-pool-%d").build());
            this.monitoredTdsqlHostInfoSet = new HashSet<TdsqlHostInfo>();
            this.firstCheckFinishedMap = new HashMap<String, CountDownLatch>();
            this.heartbeatMonitorInitialized = true;
            TdsqlLoggerFactory.logInfo("Heartbeat monitor initialized.");
        }
        if (!this.firstCheckFinishedMap.containsKey(datasourceUuid = tdsqlLoadBalanceInfo.getDatasourceUuid())) {
            this.firstCheckFinishedMap.put(datasourceUuid, new CountDownLatch(tdsqlLoadBalanceInfo.getTdsqlHostInfoList().size()));
            TdsqlLoggerFactory.logInfo("Found new datasource [" + datasourceUuid + "]");
        }
        for (TdsqlHostInfo tdsqlHostInfo : tdsqlLoadBalanceInfo.getTdsqlHostInfoList()) {
            if (this.monitoredTdsqlHostInfoSet.contains(tdsqlHostInfo)) continue;
            this.heartbeatMonitor.scheduleWithFixedDelay(new HeartbeatMonitorTask(tdsqlHostInfo, tdsqlLoadBalanceInfo.getTdsqlLoadBalanceHeartbeatMaxErrorRetries(), tdsqlLoadBalanceInfo.getTdsqlLoadBalanceHeartbeatErrorRetryIntervalTimeMillis(), this.firstCheckFinishedMap), 0L, tdsqlLoadBalanceInfo.getTdsqlLoadBalanceHeartbeatIntervalTimeMillis(), TimeUnit.MILLISECONDS);
            this.monitoredTdsqlHostInfoSet.add(tdsqlHostInfo);
            TdsqlLoggerFactory.logInfo("Add new host to heartbeat monitor. [ds: " + datasourceUuid + ", host:" + tdsqlHostInfo.getHostPortPair() + "]");
        }
    }

    public CountDownLatch getFirstCheckFinished(String datasourceUuid) {
        return this.firstCheckFinishedMap.get(datasourceUuid);
    }

    public static TdsqlLoadBalanceHeartbeatMonitor getInstance() {
        return SingletonInstance.INSTANCE;
    }

    private static class SingletonInstance {
        private static final TdsqlLoadBalanceHeartbeatMonitor INSTANCE = new TdsqlLoadBalanceHeartbeatMonitor();

        private SingletonInstance() {
        }
    }

    private static class HeartbeatMonitorTask
    implements Runnable {
        private final TdsqlHostInfo tdsqlHostInfo;
        private final int retries;
        private final int retryIntervalMs;
        private final Map<String, CountDownLatch> firstCheckFinishedMap;
        private boolean isFirstCheck = true;

        public HeartbeatMonitorTask(TdsqlHostInfo tdsqlHostInfo, int retries, int retryIntervalMs, Map<String, CountDownLatch> firstCheckFinishedMap) {
            this.tdsqlHostInfo = tdsqlHostInfo;
            this.retries = retries;
            this.retryIntervalMs = retryIntervalMs;
            this.firstCheckFinishedMap = firstCheckFinishedMap;
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

