/*
 * Decompiled with CFR 0.152.
 */
package com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.loadbalance;

import com.tencentcloud.tdsql.mysql.cj.jdbc.tdsql.TdsqlHostInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

public class TdsqlLoadBalanceInfo {
    private String datasourceUuid;
    private List<TdsqlHostInfo> tdsqlHostInfoList;
    private List<Integer> tdsqlLoadBalanceWeightFactorList;
    private boolean tdsqlLoadBalanceHeartbeatMonitorEnable;
    private int tdsqlLoadBalanceHeartbeatIntervalTimeMillis;
    private int tdsqlLoadBalanceHeartbeatMaxErrorRetries;
    private int tdsqlLoadBalanceHeartbeatErrorRetryIntervalTimeMillis;

    public String getDatasourceUuid() {
        return this.datasourceUuid;
    }

    public List<TdsqlHostInfo> getTdsqlHostInfoList() {
        return this.tdsqlHostInfoList;
    }

    public void setTdsqlHostInfoList(List<TdsqlHostInfo> tdsqlHostInfoList) {
        ArrayList<String> hostPortPairList = new ArrayList<String>(tdsqlHostInfoList.size());
        for (TdsqlHostInfo tdsqlHostInfo : tdsqlHostInfoList) {
            hostPortPairList.add(tdsqlHostInfo.getHostPortPair());
        }
        Collections.sort(hostPortPairList);
        StringJoiner uuidJoiner = new StringJoiner("+");
        for (String hostPort : hostPortPairList) {
            uuidJoiner.add(hostPort);
        }
        this.tdsqlHostInfoList = tdsqlHostInfoList;
        this.datasourceUuid = uuidJoiner.toString();
        for (TdsqlHostInfo tdsqlHostInfo : this.tdsqlHostInfoList) {
            tdsqlHostInfo.setOwnerUuid(this.datasourceUuid);
        }
    }

    public void setTdsqlLoadBalanceWeightFactorList(List<Integer> tdsqlLoadBalanceWeightFactorList) {
        this.tdsqlLoadBalanceWeightFactorList = tdsqlLoadBalanceWeightFactorList;
    }

    public boolean isTdsqlLoadBalanceHeartbeatMonitorEnable() {
        return this.tdsqlLoadBalanceHeartbeatMonitorEnable;
    }

    public void setTdsqlLoadBalanceHeartbeatMonitorEnable(boolean tdsqlLoadBalanceHeartbeatMonitorEnable) {
        this.tdsqlLoadBalanceHeartbeatMonitorEnable = tdsqlLoadBalanceHeartbeatMonitorEnable;
    }

    public int getTdsqlLoadBalanceHeartbeatIntervalTimeMillis() {
        return this.tdsqlLoadBalanceHeartbeatIntervalTimeMillis;
    }

    public void setTdsqlLoadBalanceHeartbeatIntervalTimeMillis(int tdsqlLoadBalanceHeartbeatIntervalTimeMillis) {
        this.tdsqlLoadBalanceHeartbeatIntervalTimeMillis = tdsqlLoadBalanceHeartbeatIntervalTimeMillis;
    }

    public int getTdsqlLoadBalanceHeartbeatMaxErrorRetries() {
        return this.tdsqlLoadBalanceHeartbeatMaxErrorRetries;
    }

    public void setTdsqlLoadBalanceHeartbeatMaxErrorRetries(int tdsqlLoadBalanceHeartbeatMaxErrorRetries) {
        this.tdsqlLoadBalanceHeartbeatMaxErrorRetries = tdsqlLoadBalanceHeartbeatMaxErrorRetries;
    }

    public int getTdsqlLoadBalanceHeartbeatErrorRetryIntervalTimeMillis() {
        return this.tdsqlLoadBalanceHeartbeatErrorRetryIntervalTimeMillis;
    }

    public void setTdsqlLoadBalanceHeartbeatErrorRetryIntervalTimeMillis(int tdsqlLoadBalanceHeartbeatErrorRetryIntervalTimeMillis) {
        this.tdsqlLoadBalanceHeartbeatErrorRetryIntervalTimeMillis = tdsqlLoadBalanceHeartbeatErrorRetryIntervalTimeMillis;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TdsqlLoadBalanceInfo that = (TdsqlLoadBalanceInfo)o;
        return this.tdsqlLoadBalanceHeartbeatMonitorEnable == that.tdsqlLoadBalanceHeartbeatMonitorEnable && this.tdsqlLoadBalanceHeartbeatIntervalTimeMillis == that.tdsqlLoadBalanceHeartbeatIntervalTimeMillis && this.tdsqlLoadBalanceHeartbeatMaxErrorRetries == that.tdsqlLoadBalanceHeartbeatMaxErrorRetries && this.tdsqlLoadBalanceHeartbeatErrorRetryIntervalTimeMillis == that.tdsqlLoadBalanceHeartbeatErrorRetryIntervalTimeMillis && this.datasourceUuid.equals(that.datasourceUuid) && this.tdsqlHostInfoList.equals(that.tdsqlHostInfoList) && this.tdsqlLoadBalanceWeightFactorList.equals(that.tdsqlLoadBalanceWeightFactorList);
    }

    public int hashCode() {
        return Objects.hash(this.datasourceUuid, this.tdsqlHostInfoList, this.tdsqlLoadBalanceWeightFactorList, this.tdsqlLoadBalanceHeartbeatMonitorEnable, this.tdsqlLoadBalanceHeartbeatIntervalTimeMillis, this.tdsqlLoadBalanceHeartbeatMaxErrorRetries, this.tdsqlLoadBalanceHeartbeatErrorRetryIntervalTimeMillis);
    }

    public String toString() {
        return "TdsqlLoadBalanceInfo{datasourceUuid='" + this.datasourceUuid + '\'' + ", tdsqlHostInfoList=" + this.tdsqlHostInfoList + ", tdsqlLoadBalanceWeightFactorList=" + this.tdsqlLoadBalanceWeightFactorList + ", tdsqlLoadBalanceHeartbeatMonitorEnable=" + this.tdsqlLoadBalanceHeartbeatMonitorEnable + ", tdsqlLoadBalanceHeartbeatIntervalTimeMillis=" + this.tdsqlLoadBalanceHeartbeatIntervalTimeMillis + ", tdsqlLoadBalanceHeartbeatMaxErrorRetries=" + this.tdsqlLoadBalanceHeartbeatMaxErrorRetries + ", tdsqlLoadBalanceHeartbeatErrorRetryIntervalTimeMillis=" + this.tdsqlLoadBalanceHeartbeatErrorRetryIntervalTimeMillis + '}';
    }
}

