/*
 * Decompiled with CFR 0.152.
 */
package com.tencentcloud.tdsql.mysql.cj.protocol.a;

import com.tencentcloud.tdsql.mysql.cj.BindValue;
import com.tencentcloud.tdsql.mysql.cj.Messages;
import com.tencentcloud.tdsql.mysql.cj.exceptions.ExceptionFactory;
import com.tencentcloud.tdsql.mysql.cj.exceptions.WrongArgumentException;
import com.tencentcloud.tdsql.mysql.cj.protocol.InternalTime;
import com.tencentcloud.tdsql.mysql.cj.protocol.Message;
import com.tencentcloud.tdsql.mysql.cj.protocol.a.AbstractValueEncoder;
import com.tencentcloud.tdsql.mysql.cj.protocol.a.NativeConstants;
import com.tencentcloud.tdsql.mysql.cj.protocol.a.NativePacketPayload;
import com.tencentcloud.tdsql.mysql.cj.util.StringUtils;
import com.tencentcloud.tdsql.mysql.cj.util.TimeUtil;
import java.time.LocalTime;

public class LocalTimeValueEncoder
extends AbstractValueEncoder {
    @Override
    public String getString(BindValue binding) {
        switch (binding.getMysqlType()) {
            case NULL: {
                return "null";
            }
            case TIME: {
                StringBuilder sb = new StringBuilder("'");
                sb.append(this.adjustLocalTime(LocalTime.ofNanoOfDay(((LocalTime)binding.getValue()).toNanoOfDay()), binding.getField()).format(TimeUtil.TIME_FORMATTER_WITH_OPTIONAL_MICROS));
                sb.append("'");
                return sb.toString();
            }
            case CHAR: 
            case VARCHAR: 
            case TINYTEXT: 
            case TEXT: 
            case MEDIUMTEXT: 
            case LONGTEXT: {
                StringBuilder sb = new StringBuilder("'");
                sb.append(((LocalTime)binding.getValue()).format((Boolean)this.sendFractionalSeconds.getValue() != false && ((LocalTime)binding.getValue()).getNano() > 0 ? TimeUtil.TIME_FORMATTER_WITH_NANOS_NO_OFFSET : TimeUtil.TIME_FORMATTER_NO_FRACT_NO_OFFSET));
                sb.append("'");
                return sb.toString();
            }
        }
        throw ExceptionFactory.createException(WrongArgumentException.class, Messages.getString("PreparedStatement.67", new Object[]{binding.getValue().getClass().getName(), binding.getMysqlType().toString()}), this.exceptionInterceptor);
    }

    @Override
    public void encodeAsBinary(Message msg, BindValue binding) {
        NativePacketPayload intoPacket = (NativePacketPayload)msg;
        switch (binding.getMysqlType()) {
            case TIME: {
                this.writeTime(msg, InternalTime.from(this.adjustLocalTime(LocalTime.ofNanoOfDay(((LocalTime)binding.getValue()).toNanoOfDay()), binding.getField())));
                return;
            }
            case CHAR: 
            case VARCHAR: 
            case TINYTEXT: 
            case TEXT: 
            case MEDIUMTEXT: 
            case LONGTEXT: {
                intoPacket.writeBytes(NativeConstants.StringSelfDataType.STRING_LENENC, StringUtils.getBytes(((LocalTime)binding.getValue()).format((Boolean)this.sendFractionalSeconds.getValue() != false && ((LocalTime)binding.getValue()).getNano() > 0 ? TimeUtil.TIME_FORMATTER_WITH_NANOS_NO_OFFSET : TimeUtil.TIME_FORMATTER_NO_FRACT_NO_OFFSET), (String)this.charEncoding.getValue()));
                return;
            }
        }
        throw ExceptionFactory.createException(WrongArgumentException.class, Messages.getString("PreparedStatement.67", new Object[]{binding.getValue().getClass().getName(), binding.getMysqlType().toString()}), this.exceptionInterceptor);
    }

    @Override
    public void encodeAsQueryAttribute(Message msg, BindValue binding) {
        this.writeTime(msg, InternalTime.from((LocalTime)binding.getValue()));
    }
}

