/*
 * Decompiled with CFR 0.152.
 */
package com.tencentcloud.tdsql.mysql.cj.protocol.a;

import com.tencentcloud.tdsql.mysql.cj.BindValue;
import com.tencentcloud.tdsql.mysql.cj.conf.PropertyKey;
import com.tencentcloud.tdsql.mysql.cj.exceptions.CJOperationNotSupportedException;
import com.tencentcloud.tdsql.mysql.cj.exceptions.ExceptionFactory;
import com.tencentcloud.tdsql.mysql.cj.exceptions.WrongArgumentException;
import com.tencentcloud.tdsql.mysql.cj.protocol.Message;
import com.tencentcloud.tdsql.mysql.cj.protocol.a.AbstractValueEncoder;
import com.tencentcloud.tdsql.mysql.cj.util.StringUtils;
import com.tencentcloud.tdsql.mysql.cj.util.Util;
import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

public class ReaderValueEncoder
extends AbstractValueEncoder {
    @Override
    public byte[] getBytes(BindValue binding) {
        return this.readBytes((Reader)binding.getValue(), binding);
    }

    @Override
    public String getString(BindValue binding) {
        return "'** STREAM DATA **'";
    }

    @Override
    public void encodeAsBinary(Message msg, BindValue binding) {
        throw ExceptionFactory.createException(CJOperationNotSupportedException.class, "Not supported");
    }

    protected byte[] readBytes(Reader reader, BindValue binding) {
        try {
            byte[] bytes;
            char[] c = null;
            int len = 0;
            boolean useLength = this.propertySet.getBooleanProperty(PropertyKey.useStreamLengthsInPrepStmts).getValue();
            String forcedEncoding = binding.isNational() ? null : this.propertySet.getStringProperty(PropertyKey.clobCharacterEncoding).getStringValue();
            long scaleOrLength = binding.getScaleOrLength();
            if (useLength && scaleOrLength != -1L) {
                c = new char[(int)scaleOrLength];
                int numCharsRead = Util.readFully(reader, c, (int)scaleOrLength);
                bytes = StringUtils.getBytes(new String(c, 0, numCharsRead), forcedEncoding);
            } else {
                c = new char[4096];
                StringBuilder buf = new StringBuilder();
                while ((len = reader.read(c)) != -1) {
                    buf.append(c, 0, len);
                }
                bytes = StringUtils.getBytes(buf.toString(), forcedEncoding);
            }
            return this.escapeBytesIfNeeded(bytes);
        }
        catch (UnsupportedEncodingException uec) {
            throw ExceptionFactory.createException(WrongArgumentException.class, uec.toString(), uec, this.exceptionInterceptor);
        }
        catch (IOException ioEx) {
            throw ExceptionFactory.createException(ioEx.toString(), ioEx, this.exceptionInterceptor);
        }
    }
}

