/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.akka;

import akka.actor.ActorSystem;
import akka.remote.transport.netty.ConfigSSLEngineProvider;
import com.typesafe.config.Config;
import io.netty.handler.ssl.util.FingerprintTrustManagerFactory;
import java.util.List;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00154A\u0001D\u0007\u00011!AA\u0005\u0001B\u0001B\u0003%Q\u0005C\u0003,\u0001\u0011\u0005A\u0006C\u00041\u0001\t\u0007I\u0011B\u0019\t\rq\u0002\u0001\u0015!\u00033\u0011\u001di\u0004A1A\u0005\nyBaa\u0012\u0001!\u0002\u0013y\u0004b\u0002%\u0001\u0005\u0004%IA\u0010\u0005\u0007\u0013\u0002\u0001\u000b\u0011B \t\u000f)\u0003!\u0019!C\u0005\u0017\"1!\u000b\u0001Q\u0001\n1CQa\u0015\u0001\u0005RQ\u0013qcQ;ti>l7k\u0015'F]\u001eLg.\u001a)s_ZLG-\u001a:\u000b\u00059y\u0011\u0001B1lW\u0006T!\u0001E\t\u0002\u000fI,h\u000e^5nK*\u0011!cE\u0001\u0006M2Lgn\u001b\u0006\u0003)U\ta!\u00199bG\",'\"\u0001\f\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001I\u0002C\u0001\u000e#\u001b\u0005Y\"B\u0001\u000f\u001e\u0003\u0015qW\r\u001e;z\u0015\tqr$A\u0005ue\u0006t7\u000f]8si*\u0011\u0001%I\u0001\u0007e\u0016lw\u000e^3\u000b\u00039I!aI\u000e\u0003/\r{gNZ5h'NcUI\\4j]\u0016\u0004&o\u001c<jI\u0016\u0014\u0018AB:zgR,W\u000e\u0005\u0002'S5\tqE\u0003\u0002)C\u0005)\u0011m\u0019;pe&\u0011!f\n\u0002\f\u0003\u000e$xN]*zgR,W.\u0001\u0004=S:LGO\u0010\u000b\u0003[=\u0002\"A\f\u0001\u000e\u00035AQ\u0001\n\u0002A\u0002\u0015\nab]3dkJLG/_\"p]\u001aLw-F\u00013!\t\u0019$(D\u00015\u0015\t)d'\u0001\u0004d_:4\u0017n\u001a\u0006\u0003oa\n\u0001\u0002^=qKN\fg-\u001a\u0006\u0002s\u0005\u00191m\\7\n\u0005m\"$AB\"p]\u001aLw-A\btK\u000e,(/\u001b;z\u0007>tg-[4!\u00035\u00196\u000b\u0014+skN$8\u000b^8sKV\tq\b\u0005\u0002A\u000b6\t\u0011I\u0003\u0002C\u0007\u0006!A.\u00198h\u0015\u0005!\u0015\u0001\u00026bm\u0006L!AR!\u0003\rM#(/\u001b8h\u00039\u00196\u000b\u0014+skN$8\u000b^8sK\u0002\nQcU*M)J,8\u000f^*u_J,\u0007+Y:to>\u0014H-\u0001\fT'2#&/^:u'R|'/\u001a)bgN<xN\u001d3!\u0003M\u00196\u000bT\"feR4\u0015N\\4feB\u0014\u0018N\u001c;t+\u0005a\u0005cA'Q\u007f5\taJ\u0003\u0002P\u0007\u0006!Q\u000f^5m\u0013\t\tfJ\u0001\u0003MSN$\u0018\u0001F*T\u0019\u000e+'\u000f\u001e$j]\u001e,'\u000f\u001d:j]R\u001c\b%A\u0007ueV\u001cH/T1oC\u001e,'o]\u000b\u0002+B\u0019a+W.\u000e\u0003]S\u0011\u0001W\u0001\u0006g\u000e\fG.Y\u0005\u00035^\u0013Q!\u0011:sCf\u0004\"\u0001X2\u000e\u0003uS!AX0\u0002\u0007M\u001cHN\u0003\u0002aC\u0006\u0019a.\u001a;\u000b\u0003\t\fQA[1wCbL!\u0001Z/\u0003\u0019Q\u0013Xo\u001d;NC:\fw-\u001a:")
public class CustomSSLEngineProvider
extends ConfigSSLEngineProvider {
    private final Config securityConfig;
    private final String SSLTrustStore;
    private final String SSLTrustStorePassword;
    private final List<String> SSLCertFingerprints;

    private Config securityConfig() {
        return this.securityConfig;
    }

    private String SSLTrustStore() {
        return this.SSLTrustStore;
    }

    private String SSLTrustStorePassword() {
        return this.SSLTrustStorePassword;
    }

    private List<String> SSLCertFingerprints() {
        return this.SSLCertFingerprints;
    }

    public TrustManager[] trustManagers() {
        TrustManagerFactory trustManagerFactory = this.SSLCertFingerprints().isEmpty() ? TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm()) : new FingerprintTrustManagerFactory(this.SSLCertFingerprints());
        trustManagerFactory.init(this.loadKeystore(this.SSLTrustStore(), this.SSLTrustStorePassword()));
        return trustManagerFactory.getTrustManagers();
    }

    public CustomSSLEngineProvider(ActorSystem system) {
        super(system);
        this.securityConfig = system.settings().config().getConfig("akka.remote.netty.ssl.security");
        this.SSLTrustStore = this.securityConfig().getString("trust-store");
        this.SSLTrustStorePassword = this.securityConfig().getString("trust-store-password");
        this.SSLCertFingerprints = this.securityConfig().getStringList("cert-fingerprints");
    }
}

