/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.channel;

import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateByteBuffer;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateSerializer;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.util.Preconditions;

class ChannelStateSerializerImpl
implements ChannelStateSerializer {
    private static final int SERIALIZATION_VERSION = 0;

    ChannelStateSerializerImpl() {
    }

    @Override
    public void writeHeader(DataOutputStream dataStream) throws IOException {
        dataStream.writeInt(0);
    }

    @Override
    public void writeData(DataOutputStream stream, Buffer ... flinkBuffers) throws IOException {
        stream.writeInt(this.getSize(flinkBuffers));
        for (Buffer buffer : flinkBuffers) {
            ByteBuf nettyByteBuf = buffer.asByteBuf();
            nettyByteBuf.getBytes(nettyByteBuf.readerIndex(), (OutputStream)stream, nettyByteBuf.readableBytes());
        }
    }

    private int getSize(Buffer[] buffers) {
        int len = 0;
        for (Buffer buffer : buffers) {
            len = Math.addExact(len, buffer.readableBytes());
        }
        return len;
    }

    @Override
    public void readHeader(InputStream stream) throws IOException {
        int version = ChannelStateSerializerImpl.readInt(stream);
        Preconditions.checkArgument((version == 0 ? 1 : 0) != 0, (Object)("unsupported version: " + version));
    }

    @Override
    public int readLength(InputStream stream) throws IOException {
        int len = ChannelStateSerializerImpl.readInt(stream);
        Preconditions.checkArgument((len >= 0 ? 1 : 0) != 0, (Object)"negative state size");
        return len;
    }

    @Override
    public int readData(InputStream stream, ChannelStateByteBuffer buffer, int bytes) throws IOException {
        return buffer.writeBytes(stream, bytes);
    }

    private static int readInt(InputStream stream) throws IOException {
        return new DataInputStream(stream).readInt();
    }

    @Override
    public byte[] extractAndMerge(byte[] bytes, List<Long> offsets) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(out);
        byte[] merged = this.extractByOffsets(bytes, offsets);
        this.writeHeader(dataOutputStream);
        dataOutputStream.writeInt(merged.length);
        dataOutputStream.write(merged, 0, merged.length);
        dataOutputStream.close();
        return out.toByteArray();
    }

    private byte[] extractByOffsets(byte[] data, List<Long> offsets) throws IOException {
        DataInputStream lengthReadingStream = new DataInputStream(new ByteArrayInputStream(data, 0, data.length));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        long prevOffset = 0L;
        for (long offset : offsets) {
            lengthReadingStream.skipBytes((int)(offset - prevOffset));
            int dataWithLengthOffset = (int)offset + 4;
            out.write(data, dataWithLengthOffset, lengthReadingStream.readInt());
            prevOffset = dataWithLengthOffset;
        }
        return out.toByteArray();
    }

    @Override
    public long getHeaderLength() {
        return 4L;
    }
}

