/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.clusterframework;

import akka.actor.ActorSystem;
import com.google.common.escape.Escaper;
import com.google.common.escape.Escapers;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigMergeable;
import io.netty.channel.ChannelException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.BindException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.cli.CommandLine;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.configuration.AkkaOptions;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.runtime.clusterframework.ContaineredTaskManagerParameters;
import org.apache.flink.runtime.clusterframework.TaskExecutorProcessSpec;
import org.apache.flink.runtime.clusterframework.TaskExecutorProcessUtils;
import org.apache.flink.runtime.entrypoint.parser.CommandLineOptions;
import org.apache.flink.runtime.util.config.memory.ProcessMemoryUtils;
import org.apache.flink.util.NetUtils;
import org.apache.flink.util.OperatingSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;
import scala.Some;
import scala.Tuple2;

public class BootstrapTools {
    private static final ConfigOption<Boolean> USE_LOCAL_DEFAULT_TMP_DIRS = ConfigOptions.key((String)"internal.io.tmpdirs.use-local-default").defaultValue((Object)false);
    private static final Logger LOG = LoggerFactory.getLogger(BootstrapTools.class);
    private static final Escaper UNIX_SINGLE_QUOTE_ESCAPER = Escapers.builder().addEscape('\'', "'\\''").build();
    private static final Escaper WINDOWS_DOUBLE_QUOTE_ESCAPER = Escapers.builder().addEscape('\"', "\\\"").addEscape('^', "\"^^\"").build();
    private static final String DYNAMIC_PROPERTIES_OPT = "D";

    @VisibleForTesting
    public static ActorSystem startRemoteActorSystem(Configuration configuration, String externalAddress, String externalPortRange, Logger logger) throws Exception {
        return BootstrapTools.startRemoteActorSystem(configuration, AkkaUtils.getFlinkActorSystemName(), externalAddress, externalPortRange, NetUtils.getWildcardIPAddress(), Optional.empty(), logger, (ActorSystemExecutorConfiguration)ForkJoinExecutorConfiguration.fromConfiguration(configuration), null);
    }

    public static ActorSystem startRemoteActorSystem(Configuration configuration, String actorSystemName, String externalAddress, String externalPortRange, String bindAddress, Optional<Integer> bindPort, Logger logger, ActorSystemExecutorConfiguration actorSystemExecutorConfiguration, Config customConfig) throws Exception {
        Iterator portsIterator;
        try {
            portsIterator = NetUtils.getPortRangeFromString((String)externalPortRange);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid port range definition: " + externalPortRange);
        }
        while (portsIterator.hasNext()) {
            int externalPort = (Integer)portsIterator.next();
            try {
                return BootstrapTools.startRemoteActorSystem(configuration, actorSystemName, externalAddress, externalPort, bindAddress, bindPort.orElse(externalPort), logger, actorSystemExecutorConfiguration, customConfig);
            }
            catch (Exception e) {
                Throwable cause = e.getCause();
                if (cause instanceof BindException) continue;
                throw e;
            }
        }
        throw new BindException("Could not start actor system on any port in port range " + externalPortRange);
    }

    private static ActorSystem startRemoteActorSystem(Configuration configuration, String actorSystemName, String externalAddress, int externalPort, String bindAddress, int bindPort, Logger logger, ActorSystemExecutorConfiguration actorSystemExecutorConfiguration, Config customConfig) throws Exception {
        String externalHostPortUrl = NetUtils.unresolvedHostAndPortToNormalizedString((String)externalAddress, (int)externalPort);
        String bindHostPortUrl = NetUtils.unresolvedHostAndPortToNormalizedString((String)bindAddress, (int)bindPort);
        logger.info("Trying to start actor system, external address {}, bind address {}.", (Object)externalHostPortUrl, (Object)bindHostPortUrl);
        try {
            Config akkaConfig = AkkaUtils.getAkkaConfig(configuration, (Option<Tuple2<String, Object>>)new Some((Object)new Tuple2((Object)externalAddress, (Object)externalPort)), (Option<Tuple2<String, Object>>)new Some((Object)new Tuple2((Object)bindAddress, (Object)bindPort)), actorSystemExecutorConfiguration.getAkkaConfig());
            if (customConfig != null) {
                akkaConfig = customConfig.withFallback((ConfigMergeable)akkaConfig);
            }
            return BootstrapTools.startActorSystem(akkaConfig, actorSystemName, logger);
        }
        catch (Throwable t) {
            Throwable cause;
            if (t instanceof ChannelException && (cause = t.getCause()) != null && t.getCause() instanceof BindException) {
                throw new IOException("Unable to create ActorSystem at address " + bindHostPortUrl + " : " + cause.getMessage(), t);
            }
            throw new Exception("Could not create actor system", t);
        }
    }

    public static ActorSystem startLocalActorSystem(Configuration configuration, String actorSystemName, Logger logger, ActorSystemExecutorConfiguration actorSystemExecutorConfiguration, Config customConfig) throws Exception {
        logger.info("Trying to start local actor system");
        try {
            Config akkaConfig = AkkaUtils.getAkkaConfig(configuration, (Option<Tuple2<String, Object>>)Option.empty(), (Option<Tuple2<String, Object>>)Option.empty(), actorSystemExecutorConfiguration.getAkkaConfig());
            if (customConfig != null) {
                akkaConfig = customConfig.withFallback((ConfigMergeable)akkaConfig);
            }
            return BootstrapTools.startActorSystem(akkaConfig, actorSystemName, logger);
        }
        catch (Throwable t) {
            throw new Exception("Could not create actor system", t);
        }
    }

    private static ActorSystem startActorSystem(Config akkaConfig, String actorSystemName, Logger logger) {
        logger.debug("Using akka configuration\n {}", (Object)akkaConfig);
        ActorSystem actorSystem = AkkaUtils.createActorSystem(actorSystemName, akkaConfig);
        logger.info("Actor system started at {}", (Object)AkkaUtils.getAddress(actorSystem));
        return actorSystem;
    }

    public static void writeConfiguration(Configuration cfg, File file) throws IOException {
        try (FileWriter fwrt = new FileWriter(file);
             PrintWriter out = new PrintWriter(fwrt);){
            for (Map.Entry entry : cfg.toMap().entrySet()) {
                out.print((String)entry.getKey());
                out.print(": ");
                out.println((String)entry.getValue());
            }
        }
    }

    public static void substituteDeprecatedConfigKey(Configuration config, String deprecated, String designated) {
        String valueForDeprecated;
        if (!config.containsKey(designated) && (valueForDeprecated = config.getString(deprecated, null)) != null) {
            config.setString(designated, valueForDeprecated);
        }
    }

    public static void substituteDeprecatedConfigPrefix(Configuration config, String deprecatedPrefix, String designatedPrefix) {
        int prefixLen = deprecatedPrefix.length();
        Configuration replacement = new Configuration();
        for (String key : config.keySet()) {
            String newKey;
            if (!key.startsWith(deprecatedPrefix) || config.containsKey(newKey = designatedPrefix + key.substring(prefixLen))) continue;
            replacement.setString(newKey, config.getString(key, null));
        }
        config.addAll(replacement);
    }

    public static org.apache.commons.cli.Option newDynamicPropertiesOption() {
        return new org.apache.commons.cli.Option(DYNAMIC_PROPERTIES_OPT, true, "Dynamic properties");
    }

    public static Configuration parseDynamicProperties(CommandLine cmd) {
        Configuration config = new Configuration();
        String[] values = cmd.getOptionValues(DYNAMIC_PROPERTIES_OPT);
        if (values != null) {
            for (String value : values) {
                String[] pair = value.split("=", 2);
                if (pair.length == 1) {
                    config.setString(pair[0], Boolean.TRUE.toString());
                    continue;
                }
                if (pair.length != 2) continue;
                config.setString(pair[0], pair[1]);
            }
        }
        return config;
    }

    public static String getTaskManagerShellCommand(Configuration flinkConfig, ContaineredTaskManagerParameters tmParams, String configDirectory, String logDirectory, boolean hasLogback, boolean hasLog4j, boolean hasKrb5, Class<?> mainClass, String mainArgs) {
        HashMap<String, String> startCommandValues = new HashMap<String, String>();
        startCommandValues.put("java", "$JAVA_HOME/bin/java");
        TaskExecutorProcessSpec taskExecutorProcessSpec = tmParams.getTaskExecutorProcessSpec();
        startCommandValues.put("jvmmem", ProcessMemoryUtils.generateJvmParametersStr(taskExecutorProcessSpec));
        String javaOpts = flinkConfig.getString(CoreOptions.FLINK_JVM_OPTIONS);
        if (flinkConfig.getString(CoreOptions.FLINK_TM_JVM_OPTIONS).length() > 0) {
            javaOpts = javaOpts + " " + flinkConfig.getString(CoreOptions.FLINK_TM_JVM_OPTIONS);
        }
        if (hasKrb5) {
            javaOpts = javaOpts + " -Djava.security.krb5.conf=krb5.conf";
        }
        startCommandValues.put("jvmopts", javaOpts);
        String logging = "";
        if (hasLogback || hasLog4j) {
            logging = "-Dlog.file=" + logDirectory + "/taskmanager.log";
            if (hasLogback) {
                logging = logging + " -Dlogback.configurationFile=file:" + configDirectory + "/logback.xml";
            }
            if (hasLog4j) {
                logging = logging + " -Dlog4j.configuration=file:" + configDirectory + "/log4j.properties";
                logging = logging + " -Dlog4j.configurationFile=file:" + configDirectory + "/log4j.properties";
            }
        }
        startCommandValues.put("logging", logging);
        startCommandValues.put("class", mainClass.getName());
        startCommandValues.put("redirects", "1> " + logDirectory + "/taskmanager.out 2> " + logDirectory + "/taskmanager.err");
        String argsStr = TaskExecutorProcessUtils.generateDynamicConfigsStr(taskExecutorProcessSpec) + " --configDir " + configDirectory;
        if (!mainArgs.isEmpty()) {
            argsStr = argsStr + " " + mainArgs;
        }
        startCommandValues.put("args", argsStr);
        String commandTemplate = flinkConfig.getString("yarn.container-start-command-template", "%java% %jvmmem% %jvmopts% %logging% %class% %args% %redirects%");
        String startCommand = BootstrapTools.getStartCommand(commandTemplate, startCommandValues);
        LOG.debug("TaskManager start command: " + startCommand);
        return startCommand;
    }

    private BootstrapTools() {
    }

    public static String getStartCommand(String template, Map<String, String> startCommandValues) {
        for (Map.Entry<String, String> variable : startCommandValues.entrySet()) {
            template = template.replace("%" + variable.getKey() + "%", variable.getValue()).replace("  ", " ").trim();
        }
        return template;
    }

    public static void updateTmpDirectoriesInConfiguration(Configuration configuration, @Nullable String defaultDirs) {
        if (configuration.contains(CoreOptions.TMP_DIRS)) {
            LOG.info("Overriding Fink's temporary file directories with those specified in the Flink config: {}", (Object)configuration.getValue(CoreOptions.TMP_DIRS));
        } else if (defaultDirs != null) {
            LOG.info("Setting directories for temporary files to: {}", (Object)defaultDirs);
            configuration.setString(CoreOptions.TMP_DIRS, defaultDirs);
            configuration.setBoolean(USE_LOCAL_DEFAULT_TMP_DIRS, true);
        }
    }

    public static Configuration cloneConfiguration(Configuration configuration) {
        Configuration clonedConfiguration = new Configuration(configuration);
        if (clonedConfiguration.getBoolean(USE_LOCAL_DEFAULT_TMP_DIRS)) {
            clonedConfiguration.removeConfig(CoreOptions.TMP_DIRS);
            clonedConfiguration.removeConfig(USE_LOCAL_DEFAULT_TMP_DIRS);
        }
        return clonedConfiguration;
    }

    public static String getDynamicPropertiesAsString(Configuration baseConfig, Configuration targetConfig) {
        CharSequence[] newAddedConfigs = (String[])targetConfig.keySet().stream().flatMap(key -> {
            String baseValue = baseConfig.getString(ConfigOptions.key((String)key).stringType().noDefaultValue());
            String targetValue = targetConfig.getString(ConfigOptions.key((String)key).stringType().noDefaultValue());
            if (!baseConfig.keySet().contains(key) || !baseValue.equals(targetValue)) {
                return Stream.of("-" + CommandLineOptions.DYNAMIC_PROPERTY_OPTION.getOpt() + key + CommandLineOptions.DYNAMIC_PROPERTY_OPTION.getValueSeparator() + BootstrapTools.escapeForDifferentOS(targetValue));
            }
            return Stream.empty();
        }).toArray(String[]::new);
        return String.join((CharSequence)" ", newAddedConfigs);
    }

    public static String escapeForDifferentOS(String value) {
        if (OperatingSystem.isWindows()) {
            return BootstrapTools.escapeWithDoubleQuote(value);
        }
        return BootstrapTools.escapeWithSingleQuote(value);
    }

    public static String escapeWithSingleQuote(String value) {
        return "'" + UNIX_SINGLE_QUOTE_ESCAPER.escape(value) + "'";
    }

    public static String escapeWithDoubleQuote(String value) {
        return "\"" + WINDOWS_DOUBLE_QUOTE_ESCAPER.escape(value) + "\"";
    }

    public static class FixedThreadPoolExecutorConfiguration
    implements ActorSystemExecutorConfiguration {
        private final int minNumThreads;
        private final int maxNumThreads;
        private final int threadPriority;

        public FixedThreadPoolExecutorConfiguration(int minNumThreads, int maxNumThreads, int threadPriority) {
            if (threadPriority < 1 || threadPriority > 10) {
                throw new IllegalArgumentException(String.format("The thread priority must be within (%s, %s) but it was %s.", 1, 10, threadPriority));
            }
            this.minNumThreads = minNumThreads;
            this.maxNumThreads = maxNumThreads;
            this.threadPriority = threadPriority;
        }

        public int getMinNumThreads() {
            return this.minNumThreads;
        }

        public int getMaxNumThreads() {
            return this.maxNumThreads;
        }

        public int getThreadPriority() {
            return this.threadPriority;
        }

        @Override
        public Config getAkkaConfig() {
            return AkkaUtils.getThreadPoolExecutorConfig(this);
        }
    }

    public static class ForkJoinExecutorConfiguration
    implements ActorSystemExecutorConfiguration {
        private final double parallelismFactor;
        private final int minParallelism;
        private final int maxParallelism;

        public ForkJoinExecutorConfiguration(double parallelismFactor, int minParallelism, int maxParallelism) {
            this.parallelismFactor = parallelismFactor;
            this.minParallelism = minParallelism;
            this.maxParallelism = maxParallelism;
        }

        public double getParallelismFactor() {
            return this.parallelismFactor;
        }

        public int getMinParallelism() {
            return this.minParallelism;
        }

        public int getMaxParallelism() {
            return this.maxParallelism;
        }

        @Override
        public Config getAkkaConfig() {
            return AkkaUtils.getForkJoinExecutorConfig(this);
        }

        public static ForkJoinExecutorConfiguration fromConfiguration(Configuration configuration) {
            double parallelismFactor = configuration.getDouble(AkkaOptions.FORK_JOIN_EXECUTOR_PARALLELISM_FACTOR);
            int minParallelism = configuration.getInteger(AkkaOptions.FORK_JOIN_EXECUTOR_PARALLELISM_MIN);
            int maxParallelism = configuration.getInteger(AkkaOptions.FORK_JOIN_EXECUTOR_PARALLELISM_MAX);
            return new ForkJoinExecutorConfiguration(parallelismFactor, minParallelism, maxParallelism);
        }
    }

    public static interface ActorSystemExecutorConfiguration {
        public Config getAkkaConfig();
    }
}

