/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.highavailability.zookeeper;

import javax.annotation.Nonnull;
import org.apache.curator.framework.CuratorFramework;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.highavailability.ClientHighAvailabilityServices;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.runtime.util.ZooKeeperUtils;

public class ZooKeeperClientHAServices
implements ClientHighAvailabilityServices {
    private static final String REST_SERVER_LEADER_PATH = "/rest_server_lock";
    private final CuratorFramework client;
    private final Configuration configuration;

    public ZooKeeperClientHAServices(@Nonnull CuratorFramework client, @Nonnull Configuration configuration) {
        this.client = client;
        this.configuration = configuration;
    }

    @Override
    public LeaderRetrievalService getClusterRestEndpointLeaderRetriever() {
        return ZooKeeperUtils.createLeaderRetrievalService(this.client, this.configuration, REST_SERVER_LEADER_PATH);
    }

    @Override
    public void close() throws Exception {
        this.client.close();
    }
}

