/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.netty;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;

public class ByteBufUtils {
    @Nullable
    public static ByteBuf accumulate(ByteBuf target, ByteBuf source, int targetAccumulationSize, int accumulatedSize) {
        if (accumulatedSize == 0 && source.readableBytes() >= targetAccumulationSize) {
            return source;
        }
        int copyLength = Math.min(source.readableBytes(), targetAccumulationSize - accumulatedSize);
        if (copyLength > 0) {
            target.writeBytes(source, copyLength);
        }
        if (accumulatedSize + copyLength == targetAccumulationSize) {
            return target;
        }
        return null;
    }
}

