/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.CompositeByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelOutboundInvoker;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.ProtocolException;
import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.event.TaskEvent;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.io.network.api.serialization.EventSerializer;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.netty.NetworkBufferAllocator;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannelID;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.Preconditions;

public abstract class NettyMessage {
    static final int FRAME_HEADER_LENGTH = 9;
    static final int MAGIC_NUMBER = -1159983106;

    abstract void write(ChannelOutboundInvoker var1, ChannelPromise var2, ByteBufAllocator var3) throws IOException;

    private static ByteBuf allocateBuffer(ByteBufAllocator allocator, byte id) {
        return NettyMessage.allocateBuffer(allocator, id, -1);
    }

    private static ByteBuf allocateBuffer(ByteBufAllocator allocator, byte id, int contentLength) {
        return NettyMessage.allocateBuffer(allocator, id, 0, contentLength, true);
    }

    private static ByteBuf allocateBuffer(ByteBufAllocator allocator, byte id, int messageHeaderLength, int contentLength, boolean allocateForContent) {
        Preconditions.checkArgument((contentLength <= 0x7FFFFFF6 ? 1 : 0) != 0);
        ByteBuf buffer = !allocateForContent ? allocator.directBuffer(9 + messageHeaderLength) : (contentLength != -1 ? allocator.directBuffer(9 + messageHeaderLength + contentLength) : allocator.directBuffer());
        buffer.writeInt(9 + messageHeaderLength + contentLength);
        buffer.writeInt(-1159983106);
        buffer.writeByte((int)id);
        return buffer;
    }

    void writeToChannel(ChannelOutboundInvoker out, ChannelPromise promise, ByteBufAllocator allocator, Consumer<ByteBuf> consumer, byte id, int length) throws IOException {
        ByteBuf byteBuf = null;
        try {
            byteBuf = NettyMessage.allocateBuffer(allocator, id, length);
            consumer.accept(byteBuf);
            out.write((Object)byteBuf, promise);
        }
        catch (Throwable t) {
            this.handleException(byteBuf, null, t);
        }
    }

    void handleException(@Nullable ByteBuf byteBuf, @Nullable Buffer buffer, Throwable t) throws IOException {
        if (byteBuf != null) {
            byteBuf.release();
        }
        if (buffer != null) {
            buffer.recycleBuffer();
        }
        ExceptionUtils.rethrowIOException((Throwable)t);
    }

    static class ResumeConsumption
    extends NettyMessage {
        private static final byte ID = 7;
        final InputChannelID receiverId;

        ResumeConsumption(InputChannelID receiverId) {
            this.receiverId = receiverId;
        }

        @Override
        void write(ChannelOutboundInvoker out, ChannelPromise promise, ByteBufAllocator allocator) throws IOException {
            this.writeToChannel(out, promise, allocator, this.receiverId::writeTo, (byte)7, InputChannelID.getByteBufLength());
        }

        static ResumeConsumption readFrom(ByteBuf buffer) {
            return new ResumeConsumption(InputChannelID.fromByteBuf(buffer));
        }

        public String toString() {
            return String.format("ResumeConsumption(%s)", new Object[]{this.receiverId});
        }
    }

    static class AddCredit
    extends NettyMessage {
        private static final byte ID = 6;
        final int credit;
        final InputChannelID receiverId;

        AddCredit(int credit, InputChannelID receiverId) {
            Preconditions.checkArgument((credit > 0 ? 1 : 0) != 0, (Object)"The announced credit should be greater than 0");
            this.credit = credit;
            this.receiverId = receiverId;
        }

        @Override
        void write(ChannelOutboundInvoker out, ChannelPromise promise, ByteBufAllocator allocator) throws IOException {
            ByteBuf result = null;
            try {
                result = NettyMessage.allocateBuffer(allocator, (byte)6, 4 + InputChannelID.getByteBufLength());
                result.writeInt(this.credit);
                this.receiverId.writeTo(result);
                out.write((Object)result, promise);
            }
            catch (Throwable t) {
                this.handleException(result, null, t);
            }
        }

        static AddCredit readFrom(ByteBuf buffer) {
            int credit = buffer.readInt();
            InputChannelID receiverId = InputChannelID.fromByteBuf(buffer);
            return new AddCredit(credit, receiverId);
        }

        public String toString() {
            return String.format("AddCredit(%s : %d)", new Object[]{this.receiverId, this.credit});
        }
    }

    static class CloseRequest
    extends NettyMessage {
        private static final byte ID = 5;

        CloseRequest() {
        }

        @Override
        void write(ChannelOutboundInvoker out, ChannelPromise promise, ByteBufAllocator allocator) throws IOException {
            this.writeToChannel(out, promise, allocator, ignored -> {}, (byte)5, 0);
        }

        static CloseRequest readFrom(ByteBuf buffer) throws Exception {
            return new CloseRequest();
        }
    }

    static class CancelPartitionRequest
    extends NettyMessage {
        private static final byte ID = 4;
        final InputChannelID receiverId;

        CancelPartitionRequest(InputChannelID receiverId) {
            this.receiverId = (InputChannelID)((Object)Preconditions.checkNotNull((Object)((Object)receiverId)));
        }

        @Override
        void write(ChannelOutboundInvoker out, ChannelPromise promise, ByteBufAllocator allocator) throws IOException {
            this.writeToChannel(out, promise, allocator, this.receiverId::writeTo, (byte)4, InputChannelID.getByteBufLength());
        }

        static CancelPartitionRequest readFrom(ByteBuf buffer) throws Exception {
            return new CancelPartitionRequest(InputChannelID.fromByteBuf(buffer));
        }
    }

    static class TaskEventRequest
    extends NettyMessage {
        private static final byte ID = 3;
        final TaskEvent event;
        final InputChannelID receiverId;
        final ResultPartitionID partitionId;

        TaskEventRequest(TaskEvent event, ResultPartitionID partitionId, InputChannelID receiverId) {
            this.event = (TaskEvent)Preconditions.checkNotNull((Object)event);
            this.receiverId = (InputChannelID)((Object)Preconditions.checkNotNull((Object)((Object)receiverId)));
            this.partitionId = (ResultPartitionID)Preconditions.checkNotNull((Object)partitionId);
        }

        @Override
        void write(ChannelOutboundInvoker out, ChannelPromise promise, ByteBufAllocator allocator) throws IOException {
            ByteBuffer serializedEvent = EventSerializer.toSerializedEvent(this.event);
            Consumer<ByteBuf> consumer = bb -> {
                bb.writeInt(serializedEvent.remaining());
                bb.writeBytes(serializedEvent);
                this.partitionId.getPartitionId().writeTo((ByteBuf)bb);
                this.partitionId.getProducerId().writeTo((ByteBuf)bb);
                this.receiverId.writeTo((ByteBuf)bb);
            };
            this.writeToChannel(out, promise, allocator, consumer, (byte)3, 4 + serializedEvent.remaining() + IntermediateResultPartitionID.getByteBufLength() + ExecutionAttemptID.getByteBufLength() + InputChannelID.getByteBufLength());
        }

        static TaskEventRequest readFrom(ByteBuf buffer, ClassLoader classLoader) throws IOException {
            int length = buffer.readInt();
            ByteBuffer serializedEvent = buffer.nioBuffer(buffer.readerIndex(), length);
            buffer.readerIndex(buffer.readerIndex() + length);
            TaskEvent event = (TaskEvent)EventSerializer.fromSerializedEvent(serializedEvent, classLoader);
            ResultPartitionID partitionId = new ResultPartitionID(IntermediateResultPartitionID.fromByteBuf(buffer), ExecutionAttemptID.fromByteBuf(buffer));
            InputChannelID receiverId = InputChannelID.fromByteBuf(buffer);
            return new TaskEventRequest(event, partitionId, receiverId);
        }
    }

    static class PartitionRequest
    extends NettyMessage {
        private static final byte ID = 2;
        final ResultPartitionID partitionId;
        final int queueIndex;
        final InputChannelID receiverId;
        final int credit;

        PartitionRequest(ResultPartitionID partitionId, int queueIndex, InputChannelID receiverId, int credit) {
            this.partitionId = (ResultPartitionID)Preconditions.checkNotNull((Object)partitionId);
            this.queueIndex = queueIndex;
            this.receiverId = (InputChannelID)((Object)Preconditions.checkNotNull((Object)((Object)receiverId)));
            this.credit = credit;
        }

        @Override
        void write(ChannelOutboundInvoker out, ChannelPromise promise, ByteBufAllocator allocator) throws IOException {
            Consumer<ByteBuf> consumer = bb -> {
                this.partitionId.getPartitionId().writeTo((ByteBuf)bb);
                this.partitionId.getProducerId().writeTo((ByteBuf)bb);
                bb.writeInt(this.queueIndex);
                this.receiverId.writeTo((ByteBuf)bb);
                bb.writeInt(this.credit);
            };
            this.writeToChannel(out, promise, allocator, consumer, (byte)2, IntermediateResultPartitionID.getByteBufLength() + ExecutionAttemptID.getByteBufLength() + 4 + InputChannelID.getByteBufLength() + 4);
        }

        static PartitionRequest readFrom(ByteBuf buffer) {
            ResultPartitionID partitionId = new ResultPartitionID(IntermediateResultPartitionID.fromByteBuf(buffer), ExecutionAttemptID.fromByteBuf(buffer));
            int queueIndex = buffer.readInt();
            InputChannelID receiverId = InputChannelID.fromByteBuf(buffer);
            int credit = buffer.readInt();
            return new PartitionRequest(partitionId, queueIndex, receiverId, credit);
        }

        public String toString() {
            return String.format("PartitionRequest(%s:%d:%d)", this.partitionId, this.queueIndex, this.credit);
        }
    }

    static class ErrorResponse
    extends NettyMessage {
        static final byte ID = 1;
        final Throwable cause;
        @Nullable
        final InputChannelID receiverId;

        ErrorResponse(Throwable cause) {
            this.cause = (Throwable)Preconditions.checkNotNull((Object)cause);
            this.receiverId = null;
        }

        ErrorResponse(Throwable cause, InputChannelID receiverId) {
            this.cause = (Throwable)Preconditions.checkNotNull((Object)cause);
            this.receiverId = receiverId;
        }

        boolean isFatalError() {
            return this.receiverId == null;
        }

        @Override
        void write(ChannelOutboundInvoker out, ChannelPromise promise, ByteBufAllocator allocator) throws IOException {
            ByteBuf result = NettyMessage.allocateBuffer(allocator, (byte)1);
            try (ObjectOutputStream oos = new ObjectOutputStream((OutputStream)new ByteBufOutputStream(result));){
                oos.writeObject(this.cause);
                if (this.receiverId != null) {
                    result.writeBoolean(true);
                    this.receiverId.writeTo(result);
                } else {
                    result.writeBoolean(false);
                }
                result.setInt(0, result.readableBytes());
                out.write((Object)result, promise);
            }
            catch (Throwable t) {
                this.handleException(result, null, t);
            }
        }

        static ErrorResponse readFrom(ByteBuf buffer) throws Exception {
            try (ObjectInputStream ois = new ObjectInputStream((InputStream)new ByteBufInputStream(buffer));){
                Object obj = ois.readObject();
                if (!(obj instanceof Throwable)) {
                    throw new ClassCastException("Read object expected to be of type Throwable, actual type is " + obj.getClass() + ".");
                }
                if (buffer.readBoolean()) {
                    InputChannelID receiverId = InputChannelID.fromByteBuf(buffer);
                    ErrorResponse errorResponse = new ErrorResponse((Throwable)obj, receiverId);
                    return errorResponse;
                }
                ErrorResponse errorResponse = new ErrorResponse((Throwable)obj);
                return errorResponse;
            }
        }
    }

    static class BufferResponse
    extends NettyMessage {
        static final byte ID = 0;
        static final int MESSAGE_HEADER_LENGTH = InputChannelID.getByteBufLength() + 4 + 4 + 1 + 1 + 4;
        final Buffer buffer;
        final InputChannelID receiverId;
        final int sequenceNumber;
        final int backlog;
        final Buffer.DataType dataType;
        final boolean isCompressed;
        final int bufferSize;

        private BufferResponse(@Nullable Buffer buffer, Buffer.DataType dataType, boolean isCompressed, int sequenceNumber, InputChannelID receiverId, int backlog, int bufferSize) {
            this.buffer = buffer;
            this.dataType = dataType;
            this.isCompressed = isCompressed;
            this.sequenceNumber = sequenceNumber;
            this.receiverId = (InputChannelID)((Object)Preconditions.checkNotNull((Object)((Object)receiverId)));
            this.backlog = backlog;
            this.bufferSize = bufferSize;
        }

        BufferResponse(Buffer buffer, int sequenceNumber, InputChannelID receiverId, int backlog) {
            this.buffer = (Buffer)Preconditions.checkNotNull((Object)buffer);
            Preconditions.checkArgument((buffer.getDataType().ordinal() <= 127 ? 1 : 0) != 0, (Object)"Too many data types defined!");
            this.dataType = buffer.getDataType();
            this.isCompressed = buffer.isCompressed();
            this.sequenceNumber = sequenceNumber;
            this.receiverId = (InputChannelID)((Object)Preconditions.checkNotNull((Object)((Object)receiverId)));
            this.backlog = backlog;
            this.bufferSize = buffer.getSize();
        }

        boolean isBuffer() {
            return this.dataType.isBuffer();
        }

        @Nullable
        public Buffer getBuffer() {
            return this.buffer;
        }

        void releaseBuffer() {
            if (this.buffer != null) {
                this.buffer.recycleBuffer();
            }
        }

        @Override
        void write(ChannelOutboundInvoker out, ChannelPromise promise, ByteBufAllocator allocator) throws IOException {
            ByteBuf headerBuf = null;
            try {
                this.buffer.setAllocator(allocator);
                headerBuf = this.fillHeader(allocator);
                out.write((Object)headerBuf);
                out.write((Object)this.buffer, promise);
            }
            catch (Throwable t) {
                this.handleException(headerBuf, this.buffer, t);
            }
        }

        @VisibleForTesting
        ByteBuf write(ByteBufAllocator allocator) throws IOException {
            ByteBuf headerBuf = null;
            try {
                this.buffer.setAllocator(allocator);
                headerBuf = this.fillHeader(allocator);
                CompositeByteBuf composityBuf = allocator.compositeDirectBuffer();
                composityBuf.addComponent(headerBuf);
                composityBuf.addComponent(this.buffer.asByteBuf());
                composityBuf.writerIndex(headerBuf.writerIndex() + this.buffer.asByteBuf().writerIndex());
                return composityBuf;
            }
            catch (Throwable t) {
                this.handleException(headerBuf, this.buffer, t);
                return null;
            }
        }

        private ByteBuf fillHeader(ByteBufAllocator allocator) {
            ByteBuf headerBuf = NettyMessage.allocateBuffer(allocator, (byte)0, BufferResponse.MESSAGE_HEADER_LENGTH, this.bufferSize, false);
            this.receiverId.writeTo(headerBuf);
            headerBuf.writeInt(this.sequenceNumber);
            headerBuf.writeInt(this.backlog);
            headerBuf.writeByte(this.dataType.ordinal());
            headerBuf.writeBoolean(this.isCompressed);
            headerBuf.writeInt(this.buffer.readableBytes());
            return headerBuf;
        }

        static BufferResponse readFrom(ByteBuf messageHeader, NetworkBufferAllocator bufferAllocator) {
            InputChannelID receiverId = InputChannelID.fromByteBuf(messageHeader);
            int sequenceNumber = messageHeader.readInt();
            int backlog = messageHeader.readInt();
            Buffer.DataType dataType = Buffer.DataType.values()[messageHeader.readByte()];
            boolean isCompressed = messageHeader.readBoolean();
            int size = messageHeader.readInt();
            Buffer dataBuffer = null;
            if (size != 0) {
                dataBuffer = dataType.isBuffer() ? bufferAllocator.allocatePooledNetworkBuffer(receiverId) : bufferAllocator.allocateUnPooledNetworkBuffer(size, dataType);
            }
            if (dataBuffer != null) {
                dataBuffer.setCompressed(isCompressed);
            }
            return new BufferResponse(dataBuffer, dataType, isCompressed, sequenceNumber, receiverId, backlog, size);
        }
    }

    static class NettyMessageDecoder
    extends LengthFieldBasedFrameDecoder {
        NettyMessageDecoder() {
            super(Integer.MAX_VALUE, 0, 4, -4, 4);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object decode(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
            ByteBuf msg = (ByteBuf)super.decode(ctx, in);
            if (msg == null) {
                return null;
            }
            try {
                NettyMessage decodedMsg;
                int magicNumber = msg.readInt();
                if (magicNumber != -1159983106) {
                    throw new IllegalStateException("Network stream corrupted: received incorrect magic number.");
                }
                byte msgId = msg.readByte();
                switch (msgId) {
                    case 2: {
                        decodedMsg = PartitionRequest.readFrom(msg);
                        break;
                    }
                    case 3: {
                        decodedMsg = TaskEventRequest.readFrom(msg, ((Object)((Object)this)).getClass().getClassLoader());
                        break;
                    }
                    case 4: {
                        decodedMsg = CancelPartitionRequest.readFrom(msg);
                        break;
                    }
                    case 5: {
                        decodedMsg = CloseRequest.readFrom(msg);
                        break;
                    }
                    case 6: {
                        decodedMsg = AddCredit.readFrom(msg);
                        break;
                    }
                    case 7: {
                        decodedMsg = ResumeConsumption.readFrom(msg);
                        break;
                    }
                    default: {
                        throw new ProtocolException("Received unknown message from producer: " + msg);
                    }
                }
                NettyMessage nettyMessage = decodedMsg;
                return nettyMessage;
            }
            finally {
                msg.release();
            }
        }
    }

    @ChannelHandler.Sharable
    static class NettyMessageEncoder
    extends ChannelOutboundHandlerAdapter {
        NettyMessageEncoder() {
        }

        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws IOException {
            if (msg instanceof NettyMessage) {
                ((NettyMessage)msg).write((ChannelOutboundInvoker)ctx, promise, ctx.alloc());
            } else {
                ctx.write(msg, promise);
            }
        }
    }
}

