/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import javax.annotation.Nullable;
import org.apache.flink.runtime.io.network.netty.NettyMessage;

abstract class NettyMessageDecoder
implements AutoCloseable {
    protected int msgId;
    protected int messageLength;

    NettyMessageDecoder() {
    }

    abstract void onChannelActive(ChannelHandlerContext var1);

    void onNewMessageReceived(int msgId, int messageLength) {
        this.msgId = msgId;
        this.messageLength = messageLength;
    }

    abstract DecodingResult onChannelRead(ByteBuf var1) throws Exception;

    static class DecodingResult {
        static final DecodingResult NOT_FINISHED = new DecodingResult(false, null);
        private final boolean finished;
        @Nullable
        private final NettyMessage message;

        private DecodingResult(boolean finished, @Nullable NettyMessage message) {
            this.finished = finished;
            this.message = message;
        }

        public boolean isFinished() {
            return this.finished;
        }

        @Nullable
        public NettyMessage getMessage() {
            return this.message;
        }

        static DecodingResult fullMessage(NettyMessage message) {
            return new DecodingResult(true, message);
        }
    }
}

