/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.netty;

import io.netty.channel.ChannelHandler;
import org.apache.flink.runtime.io.network.TaskEventPublisher;
import org.apache.flink.runtime.io.network.netty.CreditBasedPartitionRequestClientHandler;
import org.apache.flink.runtime.io.network.netty.NettyMessage;
import org.apache.flink.runtime.io.network.netty.NettyMessageClientDecoderDelegate;
import org.apache.flink.runtime.io.network.netty.PartitionRequestQueue;
import org.apache.flink.runtime.io.network.netty.PartitionRequestServerHandler;
import org.apache.flink.runtime.io.network.partition.ResultPartitionProvider;

public class NettyProtocol {
    private final NettyMessage.NettyMessageEncoder messageEncoder = new NettyMessage.NettyMessageEncoder();
    private final ResultPartitionProvider partitionProvider;
    private final TaskEventPublisher taskEventPublisher;

    NettyProtocol(ResultPartitionProvider partitionProvider, TaskEventPublisher taskEventPublisher) {
        this.partitionProvider = partitionProvider;
        this.taskEventPublisher = taskEventPublisher;
    }

    public ChannelHandler[] getServerChannelHandlers() {
        PartitionRequestQueue queueOfPartitionQueues = new PartitionRequestQueue();
        PartitionRequestServerHandler serverHandler = new PartitionRequestServerHandler(this.partitionProvider, this.taskEventPublisher, queueOfPartitionQueues);
        return new ChannelHandler[]{this.messageEncoder, new NettyMessage.NettyMessageDecoder(), serverHandler, queueOfPartitionQueues};
    }

    public ChannelHandler[] getClientChannelHandlers() {
        CreditBasedPartitionRequestClientHandler networkClientHandler = new CreditBasedPartitionRequestClientHandler();
        return new ChannelHandler[]{this.messageEncoder, new NettyMessageClientDecoderDelegate(networkClientHandler), networkClientHandler};
    }
}

