/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.netty;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.io.network.NetworkSequenceViewReader;
import org.apache.flink.runtime.io.network.netty.NettyMessage;
import org.apache.flink.runtime.io.network.partition.ProducerFailedException;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannelID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PartitionRequestQueue
extends ChannelInboundHandlerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(PartitionRequestQueue.class);
    private final ChannelFutureListener writeListener = new WriteAndFlushNextMessageIfPossibleListener();
    private final ArrayDeque<NetworkSequenceViewReader> availableReaders = new ArrayDeque();
    private final ConcurrentMap<InputChannelID, NetworkSequenceViewReader> allReaders = new ConcurrentHashMap<InputChannelID, NetworkSequenceViewReader>();
    private boolean fatalError;
    private ChannelHandlerContext ctx;

    PartitionRequestQueue() {
    }

    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        if (this.ctx == null) {
            this.ctx = ctx;
        }
        super.channelRegistered(ctx);
    }

    void notifyReaderNonEmpty(NetworkSequenceViewReader reader) {
        this.ctx.executor().execute(() -> this.ctx.pipeline().fireUserEventTriggered((Object)reader));
    }

    private void enqueueAvailableReader(NetworkSequenceViewReader reader) throws Exception {
        if (reader.isRegisteredAsAvailable() || !reader.isAvailable()) {
            return;
        }
        boolean triggerWrite = this.availableReaders.isEmpty();
        this.registerAvailableReader(reader);
        if (triggerWrite) {
            this.writeAndFlushNextMessageIfPossible(this.ctx.channel());
        }
    }

    @VisibleForTesting
    ArrayDeque<NetworkSequenceViewReader> getAvailableReaders() {
        return this.availableReaders;
    }

    public void notifyReaderCreated(NetworkSequenceViewReader reader) {
        this.allReaders.put(reader.getReceiverId(), reader);
    }

    public void cancel(InputChannelID receiverId) {
        this.ctx.pipeline().fireUserEventTriggered((Object)receiverId);
    }

    public void close() throws IOException {
        if (this.ctx != null) {
            this.ctx.channel().close();
        }
        this.releaseAllResources();
    }

    void addCreditOrResumeConsumption(InputChannelID receiverId, Consumer<NetworkSequenceViewReader> operation) throws Exception {
        if (this.fatalError) {
            return;
        }
        NetworkSequenceViewReader reader = (NetworkSequenceViewReader)this.allReaders.get((Object)receiverId);
        if (reader == null) {
            throw new IllegalStateException("No reader for receiverId = " + (Object)((Object)receiverId) + " exists.");
        }
        operation.accept(reader);
        this.enqueueAvailableReader(reader);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof NetworkSequenceViewReader) {
            this.enqueueAvailableReader((NetworkSequenceViewReader)msg);
        } else if (msg.getClass() == InputChannelID.class) {
            InputChannelID toCancel = (InputChannelID)((Object)msg);
            this.availableReaders.removeIf(reader -> reader.getReceiverId().equals((Object)toCancel));
            NetworkSequenceViewReader toRelease = (NetworkSequenceViewReader)this.allReaders.remove((Object)toCancel);
            if (toRelease != null) {
                this.releaseViewReader(toRelease);
            }
        } else {
            ctx.fireUserEventTriggered(msg);
        }
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        this.writeAndFlushNextMessageIfPossible(ctx.channel());
    }

    private void writeAndFlushNextMessageIfPossible(Channel channel) throws IOException {
        if (this.fatalError || !channel.isWritable()) {
            return;
        }
        InputChannel.BufferAndAvailability next = null;
        try {
            NetworkSequenceViewReader reader;
            while (true) {
                Throwable cause;
                if ((reader = this.pollAvailableReader()) == null) {
                    return;
                }
                next = reader.getNextBuffer();
                if (next != null) break;
                if (!reader.isReleased() || (cause = reader.getFailureCause()) == null) continue;
                NettyMessage.ErrorResponse msg = new NettyMessage.ErrorResponse(new ProducerFailedException(cause), reader.getReceiverId());
                this.ctx.writeAndFlush((Object)msg);
            }
            if (next.moreAvailable()) {
                this.registerAvailableReader(reader);
            }
            NettyMessage.BufferResponse msg = new NettyMessage.BufferResponse(next.buffer(), next.getSequenceNumber(), reader.getReceiverId(), next.buffersInBacklog());
            channel.writeAndFlush((Object)msg).addListener((GenericFutureListener)this.writeListener);
            return;
        }
        catch (Throwable t) {
            if (next != null) {
                next.buffer().recycleBuffer();
            }
            throw new IOException(t.getMessage(), t);
        }
    }

    private void registerAvailableReader(NetworkSequenceViewReader reader) {
        this.availableReaders.add(reader);
        reader.setRegisteredAsAvailable(true);
    }

    @Nullable
    private NetworkSequenceViewReader pollAvailableReader() {
        NetworkSequenceViewReader reader = this.availableReaders.poll();
        if (reader != null) {
            reader.setRegisteredAsAvailable(false);
        }
        return reader;
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.releaseAllResources();
        ctx.fireChannelInactive();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.handleException(ctx.channel(), cause);
    }

    private void handleException(Channel channel, Throwable cause) throws IOException {
        LOG.error("Encountered error while consuming partitions", cause);
        this.fatalError = true;
        this.releaseAllResources();
        if (channel.isActive()) {
            channel.writeAndFlush((Object)new NettyMessage.ErrorResponse(cause)).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    private void releaseAllResources() throws IOException {
        for (NetworkSequenceViewReader reader : this.allReaders.values()) {
            this.releaseViewReader(reader);
        }
        this.availableReaders.clear();
        this.allReaders.clear();
    }

    private void releaseViewReader(NetworkSequenceViewReader reader) throws IOException {
        reader.setRegisteredAsAvailable(false);
        reader.releaseAllResources();
    }

    private class WriteAndFlushNextMessageIfPossibleListener
    implements ChannelFutureListener {
        private WriteAndFlushNextMessageIfPossibleListener() {
        }

        public void operationComplete(ChannelFuture future) throws Exception {
            try {
                if (future.isSuccess()) {
                    PartitionRequestQueue.this.writeAndFlushNextMessageIfPossible(future.channel());
                } else if (future.cause() != null) {
                    PartitionRequestQueue.this.handleException(future.channel(), future.cause());
                } else {
                    PartitionRequestQueue.this.handleException(future.channel(), new IllegalStateException("Sending cancelled by user."));
                }
            }
            catch (Throwable t) {
                PartitionRequestQueue.this.handleException(future.channel(), t);
            }
        }
    }
}

