/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmanager.scheduler;

import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobmanager.scheduler.CoLocationConstraint;
import org.apache.flink.runtime.jobmanager.scheduler.CoLocationGroup;
import org.apache.flink.util.AbstractID;
import org.apache.flink.util.Preconditions;

public class CoLocationGroupImpl
implements CoLocationGroup,
Serializable {
    private static final long serialVersionUID = -2605819490401895297L;
    private final AbstractID id = new AbstractID();
    private final List<JobVertex> vertices = new ArrayList<JobVertex>();

    public CoLocationGroupImpl(JobVertex ... vertices) {
        Collections.addAll(this.vertices, vertices);
    }

    public void addVertex(JobVertex vertex) {
        Preconditions.checkNotNull((Object)vertex);
        this.vertices.add(vertex);
    }

    @Override
    public List<JobVertexID> getVertexIds() {
        return (List)this.vertices.stream().map(JobVertex::getID).collect(ImmutableList.toImmutableList());
    }

    @Override
    public CoLocationConstraint getLocationConstraint(int subTaskIndex) {
        return new CoLocationConstraint(this.id, subTaskIndex);
    }

    public void mergeInto(CoLocationGroupImpl other) {
        Preconditions.checkNotNull((Object)other);
        for (JobVertex v : this.vertices) {
            v.updateCoLocationGroup(other);
        }
        other.vertices.addAll(this.vertices);
        this.vertices.clear();
    }

    @Override
    public AbstractID getId() {
        return this.id;
    }
}

