/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.leaderretrieval;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.UUID;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.UnhandledErrorListener;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.NodeCache;
import org.apache.curator.framework.recipes.cache.NodeCacheListener;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.flink.runtime.leaderelection.LeaderInformation;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalDriver;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalEventHandler;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalException;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperLeaderRetrievalDriver
implements LeaderRetrievalDriver,
NodeCacheListener,
UnhandledErrorListener {
    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeperLeaderRetrievalDriver.class);
    private final CuratorFramework client;
    private final NodeCache cache;
    private final String retrievalPath;
    private final ConnectionStateListener connectionStateListener = (client, newState) -> this.handleStateChange(newState);
    private final LeaderRetrievalEventHandler leaderRetrievalEventHandler;
    private final FatalErrorHandler fatalErrorHandler;
    private volatile boolean running;

    public ZooKeeperLeaderRetrievalDriver(CuratorFramework client2, String retrievalPath, LeaderRetrievalEventHandler leaderRetrievalEventHandler, FatalErrorHandler fatalErrorHandler) throws Exception {
        this.client = (CuratorFramework)Preconditions.checkNotNull((Object)client2, (String)"CuratorFramework client");
        this.cache = new NodeCache(client2, retrievalPath);
        this.retrievalPath = (String)Preconditions.checkNotNull((Object)retrievalPath);
        this.leaderRetrievalEventHandler = (LeaderRetrievalEventHandler)Preconditions.checkNotNull((Object)leaderRetrievalEventHandler);
        this.fatalErrorHandler = (FatalErrorHandler)Preconditions.checkNotNull((Object)fatalErrorHandler);
        client2.getUnhandledErrorListenable().addListener((Object)this);
        this.cache.getListenable().addListener((Object)this);
        this.cache.start();
        client2.getConnectionStateListenable().addListener((Object)this.connectionStateListener);
        this.running = true;
    }

    @Override
    public void close() throws Exception {
        if (!this.running) {
            return;
        }
        this.running = false;
        LOG.info("Closing {}.", (Object)this);
        this.client.getUnhandledErrorListenable().removeListener((Object)this);
        this.client.getConnectionStateListenable().removeListener((Object)this.connectionStateListener);
        try {
            this.cache.close();
        }
        catch (IOException e) {
            throw new Exception("Could not properly stop the ZooKeeperLeaderRetrievalDriver.", e);
        }
    }

    public void nodeChanged() {
        this.retrieveLeaderInformationFromZooKeeper();
    }

    private void retrieveLeaderInformationFromZooKeeper() {
        try {
            byte[] data;
            LOG.debug("Leader node has changed.");
            ChildData childData = this.cache.getCurrentData();
            if (childData != null && (data = childData.getData()) != null && data.length > 0) {
                ByteArrayInputStream bais = new ByteArrayInputStream(data);
                ObjectInputStream ois = new ObjectInputStream(bais);
                String leaderAddress = ois.readUTF();
                UUID leaderSessionID = (UUID)ois.readObject();
                this.leaderRetrievalEventHandler.notifyLeaderAddress(LeaderInformation.known(leaderSessionID, leaderAddress));
                return;
            }
            this.leaderRetrievalEventHandler.notifyLeaderAddress(LeaderInformation.empty());
        }
        catch (Exception e) {
            this.fatalErrorHandler.onFatalError((Throwable)((Object)new LeaderRetrievalException("Could not handle node changed event.", e)));
            ExceptionUtils.checkInterrupted((Throwable)e);
        }
    }

    private void handleStateChange(ConnectionState newState) {
        switch (newState) {
            case CONNECTED: {
                LOG.debug("Connected to ZooKeeper quorum. Leader retrieval can start.");
                break;
            }
            case SUSPENDED: {
                LOG.warn("Connection to ZooKeeper suspended. Can no longer retrieve the leader from ZooKeeper.");
                this.leaderRetrievalEventHandler.notifyLeaderAddress(LeaderInformation.empty());
                break;
            }
            case RECONNECTED: {
                LOG.info("Connection to ZooKeeper was reconnected. Leader retrieval can be restarted.");
                this.onReconnectedConnectionState();
                break;
            }
            case LOST: {
                LOG.warn("Connection to ZooKeeper lost. Can no longer retrieve the leader from ZooKeeper.");
                this.leaderRetrievalEventHandler.notifyLeaderAddress(LeaderInformation.empty());
            }
        }
    }

    private void onReconnectedConnectionState() {
        this.retrieveLeaderInformationFromZooKeeper();
    }

    public void unhandledError(String s, Throwable throwable) {
        this.fatalErrorHandler.onFatalError((Throwable)((Object)new LeaderRetrievalException("Unhandled error in ZooKeeperLeaderRetrievalDriver:" + s, throwable)));
    }

    public String toString() {
        return "ZookeeperLeaderRetrievalDriver{retrievalPath='" + this.retrievalPath + '\'' + '}';
    }
}

