/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.messages.webmonitor;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collection;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.runtime.messages.webmonitor.InfoMessage;
import org.apache.flink.util.Preconditions;

public class JobsOverview
implements InfoMessage {
    private static final long serialVersionUID = -3699051943490133183L;
    public static final String FIELD_NAME_JOBS_RUNNING = "jobs-running";
    public static final String FIELD_NAME_JOBS_FINISHED = "jobs-finished";
    public static final String FIELD_NAME_JOBS_CANCELLED = "jobs-cancelled";
    public static final String FIELD_NAME_JOBS_FAILED = "jobs-failed";
    @JsonProperty(value="jobs-running")
    private final int numJobsRunningOrPending;
    @JsonProperty(value="jobs-finished")
    private final int numJobsFinished;
    @JsonProperty(value="jobs-cancelled")
    private final int numJobsCancelled;
    @JsonProperty(value="jobs-failed")
    private final int numJobsFailed;

    @JsonCreator
    public JobsOverview(@JsonProperty(value="jobs-running") int numJobsRunningOrPending, @JsonProperty(value="jobs-finished") int numJobsFinished, @JsonProperty(value="jobs-cancelled") int numJobsCancelled, @JsonProperty(value="jobs-failed") int numJobsFailed) {
        this.numJobsRunningOrPending = numJobsRunningOrPending;
        this.numJobsFinished = numJobsFinished;
        this.numJobsCancelled = numJobsCancelled;
        this.numJobsFailed = numJobsFailed;
    }

    public JobsOverview(JobsOverview first, JobsOverview second) {
        this.numJobsRunningOrPending = first.numJobsRunningOrPending + second.numJobsRunningOrPending;
        this.numJobsFinished = first.numJobsFinished + second.numJobsFinished;
        this.numJobsCancelled = first.numJobsCancelled + second.numJobsCancelled;
        this.numJobsFailed = first.numJobsFailed + second.numJobsFailed;
    }

    public int getNumJobsRunningOrPending() {
        return this.numJobsRunningOrPending;
    }

    public int getNumJobsFinished() {
        return this.numJobsFinished;
    }

    public int getNumJobsCancelled() {
        return this.numJobsCancelled;
    }

    public int getNumJobsFailed() {
        return this.numJobsFailed;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof JobsOverview) {
            JobsOverview that = (JobsOverview)obj;
            return this.numJobsRunningOrPending == that.numJobsRunningOrPending && this.numJobsFinished == that.numJobsFinished && this.numJobsCancelled == that.numJobsCancelled && this.numJobsFailed == that.numJobsFailed;
        }
        return false;
    }

    public int hashCode() {
        int result = this.numJobsRunningOrPending;
        result = 31 * result + this.numJobsFinished;
        result = 31 * result + this.numJobsCancelled;
        result = 31 * result + this.numJobsFailed;
        return result;
    }

    public String toString() {
        return "JobsOverview {numJobsRunningOrPending=" + this.numJobsRunningOrPending + ", numJobsFinished=" + this.numJobsFinished + ", numJobsCancelled=" + this.numJobsCancelled + ", numJobsFailed=" + this.numJobsFailed + '}';
    }

    public JobsOverview combine(JobsOverview jobsOverview) {
        return new JobsOverview(this, jobsOverview);
    }

    public static JobsOverview create(Collection<JobStatus> allJobsStatus) {
        Preconditions.checkNotNull(allJobsStatus);
        int numberRunningOrPendingJobs = 0;
        int numberFinishedJobs = 0;
        int numberCancelledJobs = 0;
        int numberFailedJobs = 0;
        block5: for (JobStatus status : allJobsStatus) {
            switch (status) {
                case FINISHED: {
                    ++numberFinishedJobs;
                    continue block5;
                }
                case FAILED: {
                    ++numberFailedJobs;
                    continue block5;
                }
                case CANCELED: {
                    ++numberCancelledJobs;
                    continue block5;
                }
            }
            ++numberRunningOrPendingJobs;
        }
        return new JobsOverview(numberRunningOrPendingJobs, numberFinishedJobs, numberCancelledJobs, numberFailedJobs);
    }
}

