/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.runtime.rest.handler.util.HandlerUtils;
import org.apache.flink.runtime.rest.messages.ErrorResponseBody;

public class FlinkHttpObjectAggregator
extends HttpObjectAggregator {
    private final Map<String, String> responseHeaders;

    public FlinkHttpObjectAggregator(int maxContentLength, @Nonnull Map<String, String> responseHeaders) {
        super(maxContentLength);
        this.responseHeaders = responseHeaders;
    }

    protected void decode(ChannelHandlerContext ctx, HttpObject msg, List<Object> out) throws Exception {
        try {
            super.decode(ctx, (Object)msg, out);
        }
        catch (TooLongFrameException e) {
            HandlerUtils.sendErrorResponse(ctx, false, new ErrorResponseBody(String.format(e.getMessage() + " Try to raise [%s]", RestOptions.SERVER_MAX_CONTENT_LENGTH.key())), HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE, this.responseHeaders);
        }
    }
}

