/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler;

import io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.util.FlinkException;

public class RestHandlerException
extends FlinkException {
    private static final long serialVersionUID = -1358206297964070876L;
    private final int responseCode;
    private final LoggingBehavior loggingBehavior;

    public RestHandlerException(String errorMessage, HttpResponseStatus httpResponseStatus) {
        super(errorMessage);
        this.responseCode = httpResponseStatus.code();
        this.loggingBehavior = LoggingBehavior.LOG;
    }

    public RestHandlerException(String errorMessage, HttpResponseStatus httpResponseStatus, LoggingBehavior loggingBehavior) {
        super(errorMessage);
        this.responseCode = httpResponseStatus.code();
        this.loggingBehavior = loggingBehavior;
    }

    public RestHandlerException(String errorMessage, HttpResponseStatus httpResponseStatus, Throwable cause) {
        super(errorMessage, cause);
        this.responseCode = httpResponseStatus.code();
        this.loggingBehavior = LoggingBehavior.LOG;
    }

    public HttpResponseStatus getHttpResponseStatus() {
        return HttpResponseStatus.valueOf((int)this.responseCode);
    }

    public boolean logException() {
        return LoggingBehavior.LOG == this.loggingBehavior;
    }

    public static enum LoggingBehavior {
        LOG,
        IGNORE;

    }
}

