/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job;

import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.Map;
import java.util.concurrent.Executor;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.executiongraph.AccessExecution;
import org.apache.flink.runtime.executiongraph.AccessExecutionVertex;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.handler.job.AbstractSubtaskHandler;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.ResponseBody;
import org.apache.flink.runtime.rest.messages.job.SubtaskAttemptMessageParameters;
import org.apache.flink.runtime.rest.messages.job.SubtaskAttemptPathParameter;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;

public abstract class AbstractSubtaskAttemptHandler<R extends ResponseBody, M extends SubtaskAttemptMessageParameters>
extends AbstractSubtaskHandler<R, M> {
    protected AbstractSubtaskAttemptHandler(GatewayRetriever<? extends RestfulGateway> leaderRetriever, Time timeout, Map<String, String> responseHeaders, MessageHeaders<EmptyRequestBody, R, M> messageHeaders, ExecutionGraphCache executionGraphCache, Executor executor) {
        super(leaderRetriever, timeout, responseHeaders, messageHeaders, executionGraphCache, executor);
    }

    @Override
    protected R handleRequest(HandlerRequest<EmptyRequestBody, M> request, AccessExecutionVertex executionVertex) throws RestHandlerException {
        Integer attemptNumber = (Integer)request.getPathParameter(SubtaskAttemptPathParameter.class);
        AccessExecution currentAttempt = executionVertex.getCurrentExecutionAttempt();
        if (attemptNumber.intValue() == currentAttempt.getAttemptNumber()) {
            return this.handleRequest(request, currentAttempt);
        }
        if (attemptNumber >= 0 && attemptNumber < currentAttempt.getAttemptNumber()) {
            AccessExecution execution = executionVertex.getPriorExecutionAttempt(attemptNumber);
            if (execution != null) {
                return this.handleRequest(request, execution);
            }
            throw new RestHandlerException("Attempt " + attemptNumber + " not found in subtask " + executionVertex.getTaskNameWithSubtaskIndex(), HttpResponseStatus.NOT_FOUND);
        }
        throw new RestHandlerException("Invalid attempt num " + attemptNumber, HttpResponseStatus.NOT_FOUND);
    }

    protected abstract R handleRequest(HandlerRequest<EmptyRequestBody, M> var1, AccessExecution var2) throws RestHandlerException;
}

