/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job.checkpoints;

import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.Map;
import java.util.concurrent.Executor;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.checkpoint.AbstractCheckpointStats;
import org.apache.flink.runtime.checkpoint.CheckpointStatsSnapshot;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.handler.job.AbstractAccessExecutionGraphHandler;
import org.apache.flink.runtime.rest.handler.job.checkpoints.CheckpointStatsCache;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.ResponseBody;
import org.apache.flink.runtime.rest.messages.checkpoints.CheckpointIdPathParameter;
import org.apache.flink.runtime.rest.messages.checkpoints.CheckpointMessageParameters;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.util.Preconditions;

public abstract class AbstractCheckpointHandler<R extends ResponseBody, M extends CheckpointMessageParameters>
extends AbstractAccessExecutionGraphHandler<R, M> {
    private final CheckpointStatsCache checkpointStatsCache;

    protected AbstractCheckpointHandler(GatewayRetriever<? extends RestfulGateway> leaderRetriever, Time timeout, Map<String, String> responseHeaders, MessageHeaders<EmptyRequestBody, R, M> messageHeaders, ExecutionGraphCache executionGraphCache, Executor executor, CheckpointStatsCache checkpointStatsCache) {
        super(leaderRetriever, timeout, responseHeaders, messageHeaders, executionGraphCache, executor);
        this.checkpointStatsCache = (CheckpointStatsCache)Preconditions.checkNotNull((Object)checkpointStatsCache);
    }

    @Override
    protected R handleRequest(HandlerRequest<EmptyRequestBody, M> request, AccessExecutionGraph executionGraph) throws RestHandlerException {
        long checkpointId = (Long)request.getPathParameter(CheckpointIdPathParameter.class);
        CheckpointStatsSnapshot checkpointStatsSnapshot = executionGraph.getCheckpointStatsSnapshot();
        if (checkpointStatsSnapshot != null) {
            AbstractCheckpointStats checkpointStats = checkpointStatsSnapshot.getHistory().getCheckpointById(checkpointId);
            if (checkpointStats != null) {
                this.checkpointStatsCache.tryAdd(checkpointStats);
            } else {
                checkpointStats = this.checkpointStatsCache.tryGet(checkpointId);
            }
            if (checkpointStats != null) {
                return this.handleCheckpointRequest(request, checkpointStats);
            }
            throw new RestHandlerException("Could not find checkpointing statistics for checkpoint " + checkpointId + '.', HttpResponseStatus.NOT_FOUND);
        }
        throw new RestHandlerException("Checkpointing was not enabled for job " + executionGraph.getJobID() + '.', HttpResponseStatus.NOT_FOUND);
    }

    protected abstract R handleCheckpointRequest(HandlerRequest<EmptyRequestBody, M> var1, AbstractCheckpointStats var2) throws RestHandlerException;
}

