/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job.checkpoints;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import javax.annotation.Nullable;
import org.apache.flink.runtime.checkpoint.AbstractCheckpointStats;

public class CheckpointStatsCache {
    @Nullable
    private final Cache<Long, AbstractCheckpointStats> cache;

    public CheckpointStatsCache(int maxNumEntries) {
        this.cache = maxNumEntries > 0 ? CacheBuilder.newBuilder().maximumSize((long)maxNumEntries).build() : null;
    }

    public void tryAdd(AbstractCheckpointStats checkpoint) {
        if (this.cache != null && checkpoint != null && !checkpoint.getStatus().isInProgress()) {
            this.cache.put((Object)checkpoint.getCheckpointId(), (Object)checkpoint);
        }
    }

    public AbstractCheckpointStats tryGet(long checkpointId) {
        if (this.cache != null) {
            return (AbstractCheckpointStats)this.cache.getIfPresent((Object)checkpointId);
        }
        return null;
    }
}

