/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.router;

import io.netty.util.internal.ObjectUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class RouteResult<T> {
    private final String uri;
    private final String decodedPath;
    private final Map<String, String> pathParams;
    private final Map<String, List<String>> queryParams;
    private final T target;

    public RouteResult(String uri, String decodedPath, Map<String, String> pathParams, Map<String, List<String>> queryParams, T target) {
        this.uri = (String)ObjectUtil.checkNotNull((Object)uri, (String)"uri");
        this.decodedPath = (String)ObjectUtil.checkNotNull((Object)decodedPath, (String)"decodedPath");
        this.pathParams = Collections.unmodifiableMap((Map)ObjectUtil.checkNotNull(pathParams, (String)"pathParams"));
        this.queryParams = Collections.unmodifiableMap((Map)ObjectUtil.checkNotNull(queryParams, (String)"queryParams"));
        this.target = ObjectUtil.checkNotNull(target, (String)"target");
    }

    public String uri() {
        return this.uri;
    }

    public String decodedPath() {
        return this.decodedPath;
    }

    public Map<String, String> pathParams() {
        return this.pathParams;
    }

    public Map<String, List<String>> queryParams() {
        return this.queryParams;
    }

    public T target() {
        return this.target;
    }

    public String queryParam(String name) {
        List<String> values = this.queryParams.get(name);
        return values == null ? null : values.get(0);
    }

    public String param(String name) {
        String pathValue = this.pathParams.get(name);
        return pathValue == null ? this.queryParam(name) : pathValue;
    }

    public List<String> params(String name) {
        List<String> values = this.queryParams.get(name);
        String value = this.pathParams.get(name);
        if (values == null) {
            return value == null ? Collections.emptyList() : Collections.singletonList(value);
        }
        if (value == null) {
            return Collections.unmodifiableList(values);
        }
        ArrayList<String> aggregated = new ArrayList<String>(values.size() + 1);
        aggregated.addAll(values);
        aggregated.add(value);
        return Collections.unmodifiableList(aggregated);
    }
}

