/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.util;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import java.nio.charset.Charset;
import javax.annotation.Nullable;
import org.apache.flink.configuration.ConfigConstants;
import org.apache.flink.util.Preconditions;

public class HandlerRedirectUtils {
    public static final Charset ENCODING = ConfigConstants.DEFAULT_CHARSET;

    public static HttpResponse getRedirectResponse(String redirectAddress, String path, HttpResponseStatus code) {
        Preconditions.checkNotNull((Object)redirectAddress, (String)"Redirect address");
        Preconditions.checkNotNull((Object)path, (String)"Path");
        String newLocation = String.format("%s%s", redirectAddress, path);
        DefaultFullHttpResponse redirectResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, code);
        redirectResponse.headers().set("Location", (Object)newLocation);
        redirectResponse.headers().set("Content-Length", (Object)0);
        return redirectResponse;
    }

    public static HttpResponse getResponse(HttpResponseStatus status, @Nullable String message) {
        ByteBuf messageByteBuf = message == null ? Unpooled.buffer((int)0) : Unpooled.wrappedBuffer((byte[])message.getBytes(ENCODING));
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, messageByteBuf);
        response.headers().set("Content-Type", (Object)("text/plain; charset=" + ENCODING.name()));
        response.headers().set("Content-Length", (Object)response.content().readableBytes());
        return response;
    }
}

