/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.ZonedDateTime;
import java.time.format.TextStyle;
import java.util.Locale;
import java.util.Objects;
import org.apache.flink.runtime.rest.messages.ResponseBody;
import org.apache.flink.runtime.util.EnvironmentInformation;
import org.apache.flink.util.Preconditions;

public class DashboardConfiguration
implements ResponseBody {
    public static final String FIELD_NAME_REFRESH_INTERVAL = "refresh-interval";
    public static final String FIELD_NAME_TIMEZONE_OFFSET = "timezone-offset";
    public static final String FIELD_NAME_TIMEZONE_NAME = "timezone-name";
    public static final String FIELD_NAME_FLINK_VERSION = "flink-version";
    public static final String FIELD_NAME_FLINK_REVISION = "flink-revision";
    public static final String FIELD_NAME_FLINK_FEATURES = "features";
    public static final String FIELD_NAME_FEATURE_WEB_SUBMIT = "web-submit";
    @JsonProperty(value="refresh-interval")
    private final long refreshInterval;
    @JsonProperty(value="timezone-name")
    private final String timeZoneName;
    @JsonProperty(value="timezone-offset")
    private final int timeZoneOffset;
    @JsonProperty(value="flink-version")
    private final String flinkVersion;
    @JsonProperty(value="flink-revision")
    private final String flinkRevision;
    @JsonProperty(value="features")
    private final Features features;

    @JsonCreator
    public DashboardConfiguration(@JsonProperty(value="refresh-interval") long refreshInterval, @JsonProperty(value="timezone-name") String timeZoneName, @JsonProperty(value="timezone-offset") int timeZoneOffset, @JsonProperty(value="flink-version") String flinkVersion, @JsonProperty(value="flink-revision") String flinkRevision, @JsonProperty(value="features") Features features) {
        this.refreshInterval = refreshInterval;
        this.timeZoneName = (String)Preconditions.checkNotNull((Object)timeZoneName);
        this.timeZoneOffset = timeZoneOffset;
        this.flinkVersion = (String)Preconditions.checkNotNull((Object)flinkVersion);
        this.flinkRevision = (String)Preconditions.checkNotNull((Object)flinkRevision);
        this.features = features;
    }

    @JsonIgnore
    public long getRefreshInterval() {
        return this.refreshInterval;
    }

    @JsonIgnore
    public int getTimeZoneOffset() {
        return this.timeZoneOffset;
    }

    @JsonIgnore
    public String getTimeZoneName() {
        return this.timeZoneName;
    }

    @JsonIgnore
    public String getFlinkVersion() {
        return this.flinkVersion;
    }

    @JsonIgnore
    public String getFlinkRevision() {
        return this.flinkRevision;
    }

    @JsonIgnore
    public Features getFeatures() {
        return this.features;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DashboardConfiguration that = (DashboardConfiguration)o;
        return this.refreshInterval == that.refreshInterval && this.timeZoneOffset == that.timeZoneOffset && Objects.equals(this.timeZoneName, that.timeZoneName) && Objects.equals(this.flinkVersion, that.flinkVersion) && Objects.equals(this.flinkRevision, that.flinkRevision) && Objects.equals(this.features, that.features);
    }

    public int hashCode() {
        return Objects.hash(this.refreshInterval, this.timeZoneName, this.timeZoneOffset, this.flinkVersion, this.flinkRevision, this.features);
    }

    public static DashboardConfiguration from(long refreshInterval, ZonedDateTime zonedDateTime, boolean webSubmitEnabled) {
        String flinkVersion = EnvironmentInformation.getVersion();
        EnvironmentInformation.RevisionInformation revision = EnvironmentInformation.getRevisionInformation();
        String flinkRevision = revision != null ? revision.commitId + " @ " + revision.commitDate : "unknown revision";
        return new DashboardConfiguration(refreshInterval, zonedDateTime.getZone().getDisplayName(TextStyle.FULL, Locale.getDefault()), zonedDateTime.toOffsetDateTime().getOffset().getTotalSeconds() * 1000, flinkVersion, flinkRevision, new Features(webSubmitEnabled));
    }

    public static final class Features {
        @JsonProperty(value="web-submit")
        private final boolean webSubmitEnabled;

        @JsonCreator
        public Features(@JsonProperty(value="web-submit") boolean webSubmitEnabled) {
            this.webSubmitEnabled = webSubmitEnabled;
        }

        @JsonIgnore
        public boolean isWebSubmitEnabled() {
            return this.webSubmitEnabled;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Features features = (Features)o;
            return this.webSubmitEnabled == features.webSubmitEnabled;
        }

        public int hashCode() {
            return Objects.hash(this.webSubmitEnabled);
        }
    }
}

