/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import org.apache.flink.util.AbstractID;
import org.apache.flink.util.StringUtils;

@JsonSerialize(using=TriggerIdSerializer.class)
@JsonDeserialize(using=TriggerIdDeserializer.class)
public final class TriggerId
extends AbstractID {
    private static final long serialVersionUID = 1L;

    public TriggerId() {
    }

    private TriggerId(byte[] bytes) {
        super(bytes);
    }

    public static TriggerId fromHexString(String hexString) {
        return new TriggerId(StringUtils.hexStringToByte((String)hexString));
    }

    public static class TriggerIdDeserializer
    extends StdDeserializer<TriggerId> {
        private static final long serialVersionUID = 1L;

        protected TriggerIdDeserializer() {
            super(TriggerId.class);
        }

        public TriggerId deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            return TriggerId.fromHexString(p.getValueAsString());
        }
    }

    public static class TriggerIdSerializer
    extends StdSerializer<TriggerId> {
        private static final long serialVersionUID = 1L;

        protected TriggerIdSerializer() {
            super(TriggerId.class);
        }

        public void serialize(TriggerId value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeString(value.toString());
        }
    }
}

