/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages.checkpoints;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.runtime.rest.messages.ResponseBody;
import org.apache.flink.runtime.rest.messages.checkpoints.CheckpointStatistics;
import org.apache.flink.runtime.rest.messages.checkpoints.MinMaxAvgStatistics;
import org.apache.flink.util.Preconditions;

public class CheckpointingStatistics
implements ResponseBody {
    public static final String FIELD_NAME_COUNTS = "counts";
    public static final String FIELD_NAME_SUMMARY = "summary";
    public static final String FIELD_NAME_LATEST_CHECKPOINTS = "latest";
    public static final String FIELD_NAME_HISTORY = "history";
    @JsonProperty(value="counts")
    private final Counts counts;
    @JsonProperty(value="summary")
    private final Summary summary;
    @JsonProperty(value="latest")
    private final LatestCheckpoints latestCheckpoints;
    @JsonProperty(value="history")
    private final List<CheckpointStatistics> history;

    @JsonCreator
    public CheckpointingStatistics(@JsonProperty(value="counts") Counts counts, @JsonProperty(value="summary") Summary summary, @JsonProperty(value="latest") LatestCheckpoints latestCheckpoints, @JsonProperty(value="history") List<CheckpointStatistics> history) {
        this.counts = (Counts)Preconditions.checkNotNull((Object)counts);
        this.summary = (Summary)Preconditions.checkNotNull((Object)summary);
        this.latestCheckpoints = (LatestCheckpoints)Preconditions.checkNotNull((Object)latestCheckpoints);
        this.history = (List)Preconditions.checkNotNull(history);
    }

    public Counts getCounts() {
        return this.counts;
    }

    public Summary getSummary() {
        return this.summary;
    }

    public LatestCheckpoints getLatestCheckpoints() {
        return this.latestCheckpoints;
    }

    public List<CheckpointStatistics> getHistory() {
        return this.history;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CheckpointingStatistics that = (CheckpointingStatistics)o;
        return Objects.equals(this.counts, that.counts) && Objects.equals(this.summary, that.summary) && Objects.equals(this.latestCheckpoints, that.latestCheckpoints) && Objects.equals(this.history, that.history);
    }

    public int hashCode() {
        return Objects.hash(this.counts, this.summary, this.latestCheckpoints, this.history);
    }

    public static final class RestoredCheckpointStatistics {
        public static final String FIELD_NAME_ID = "id";
        public static final String FIELD_NAME_RESTORE_TIMESTAMP = "restore_timestamp";
        public static final String FIELD_NAME_IS_SAVEPOINT = "is_savepoint";
        public static final String FIELD_NAME_EXTERNAL_PATH = "external_path";
        @JsonProperty(value="id")
        private final long id;
        @JsonProperty(value="restore_timestamp")
        private final long restoreTimestamp;
        @JsonProperty(value="is_savepoint")
        private final boolean savepoint;
        @JsonProperty(value="external_path")
        @Nullable
        private final String externalPath;

        @JsonCreator
        public RestoredCheckpointStatistics(@JsonProperty(value="id") long id, @JsonProperty(value="restore_timestamp") long restoreTimestamp, @JsonProperty(value="is_savepoint") boolean savepoint, @JsonProperty(value="external_path") @Nullable String externalPath) {
            this.id = id;
            this.restoreTimestamp = restoreTimestamp;
            this.savepoint = savepoint;
            this.externalPath = externalPath;
        }

        public long getId() {
            return this.id;
        }

        public long getRestoreTimestamp() {
            return this.restoreTimestamp;
        }

        public boolean isSavepoint() {
            return this.savepoint;
        }

        @Nullable
        public String getExternalPath() {
            return this.externalPath;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RestoredCheckpointStatistics that = (RestoredCheckpointStatistics)o;
            return this.id == that.id && this.restoreTimestamp == that.restoreTimestamp && this.savepoint == that.savepoint && Objects.equals(this.externalPath, that.externalPath);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.restoreTimestamp, this.savepoint, this.externalPath);
        }
    }

    public static final class LatestCheckpoints {
        public static final String FIELD_NAME_COMPLETED = "completed";
        public static final String FIELD_NAME_SAVEPOINT = "savepoint";
        public static final String FIELD_NAME_FAILED = "failed";
        public static final String FIELD_NAME_RESTORED = "restored";
        @JsonProperty(value="completed")
        @Nullable
        private final CheckpointStatistics.CompletedCheckpointStatistics completedCheckpointStatistics;
        @JsonProperty(value="savepoint")
        @Nullable
        private final CheckpointStatistics.CompletedCheckpointStatistics savepointStatistics;
        @JsonProperty(value="failed")
        @Nullable
        private final CheckpointStatistics.FailedCheckpointStatistics failedCheckpointStatistics;
        @JsonProperty(value="restored")
        @Nullable
        private final RestoredCheckpointStatistics restoredCheckpointStatistics;

        @JsonCreator
        public LatestCheckpoints(@JsonProperty(value="completed") @Nullable CheckpointStatistics.CompletedCheckpointStatistics completedCheckpointStatistics, @JsonProperty(value="savepoint") @Nullable CheckpointStatistics.CompletedCheckpointStatistics savepointStatistics, @JsonProperty(value="failed") @Nullable CheckpointStatistics.FailedCheckpointStatistics failedCheckpointStatistics, @JsonProperty(value="restored") @Nullable RestoredCheckpointStatistics restoredCheckpointStatistics) {
            this.completedCheckpointStatistics = completedCheckpointStatistics;
            this.savepointStatistics = savepointStatistics;
            this.failedCheckpointStatistics = failedCheckpointStatistics;
            this.restoredCheckpointStatistics = restoredCheckpointStatistics;
        }

        @Nullable
        public CheckpointStatistics.CompletedCheckpointStatistics getCompletedCheckpointStatistics() {
            return this.completedCheckpointStatistics;
        }

        @Nullable
        public CheckpointStatistics.CompletedCheckpointStatistics getSavepointStatistics() {
            return this.savepointStatistics;
        }

        @Nullable
        public CheckpointStatistics.FailedCheckpointStatistics getFailedCheckpointStatistics() {
            return this.failedCheckpointStatistics;
        }

        @Nullable
        public RestoredCheckpointStatistics getRestoredCheckpointStatistics() {
            return this.restoredCheckpointStatistics;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LatestCheckpoints that = (LatestCheckpoints)o;
            return Objects.equals(this.completedCheckpointStatistics, that.completedCheckpointStatistics) && Objects.equals(this.savepointStatistics, that.savepointStatistics) && Objects.equals(this.failedCheckpointStatistics, that.failedCheckpointStatistics) && Objects.equals(this.restoredCheckpointStatistics, that.restoredCheckpointStatistics);
        }

        public int hashCode() {
            return Objects.hash(this.completedCheckpointStatistics, this.savepointStatistics, this.failedCheckpointStatistics, this.restoredCheckpointStatistics);
        }
    }

    public static final class Summary {
        public static final String FIELD_NAME_STATE_SIZE = "state_size";
        public static final String FIELD_NAME_DURATION = "end_to_end_duration";
        public static final String FIELD_NAME_ALIGNMENT_BUFFERED = "alignment_buffered";
        public static final String FIELD_NAME_PROCESSED_DATA = "processed_data";
        public static final String FIELD_NAME_PERSISTED_DATA = "persisted_data";
        @JsonProperty(value="state_size")
        private final MinMaxAvgStatistics stateSize;
        @JsonProperty(value="end_to_end_duration")
        private final MinMaxAvgStatistics duration;
        @JsonProperty(value="alignment_buffered")
        private final MinMaxAvgStatistics alignmentBuffered;
        @JsonProperty(value="processed_data")
        private final MinMaxAvgStatistics processedData;
        @JsonProperty(value="persisted_data")
        private final MinMaxAvgStatistics persistedData;

        @JsonCreator
        public Summary(@JsonProperty(value="state_size") MinMaxAvgStatistics stateSize, @JsonProperty(value="end_to_end_duration") MinMaxAvgStatistics duration, @JsonProperty(value="alignment_buffered") MinMaxAvgStatistics alignmentBuffered, @JsonProperty(value="processed_data") MinMaxAvgStatistics processedData, @JsonProperty(value="persisted_data") MinMaxAvgStatistics persistedData) {
            this.stateSize = stateSize;
            this.duration = duration;
            this.alignmentBuffered = alignmentBuffered;
            this.processedData = processedData;
            this.persistedData = persistedData;
        }

        public MinMaxAvgStatistics getStateSize() {
            return this.stateSize;
        }

        public MinMaxAvgStatistics getDuration() {
            return this.duration;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Summary summary = (Summary)o;
            return Objects.equals(this.stateSize, summary.stateSize) && Objects.equals(this.duration, summary.duration) && Objects.equals(this.alignmentBuffered, summary.alignmentBuffered) && Objects.equals(this.processedData, summary.processedData) && Objects.equals(this.persistedData, summary.persistedData);
        }

        public int hashCode() {
            return Objects.hash(this.stateSize, this.duration, this.alignmentBuffered, this.processedData, this.persistedData);
        }
    }

    public static final class Counts {
        public static final String FIELD_NAME_RESTORED_CHECKPOINTS = "restored";
        public static final String FIELD_NAME_TOTAL_CHECKPOINTS = "total";
        public static final String FIELD_NAME_IN_PROGRESS_CHECKPOINTS = "in_progress";
        public static final String FIELD_NAME_COMPLETED_CHECKPOINTS = "completed";
        public static final String FIELD_NAME_FAILED_CHECKPOINTS = "failed";
        @JsonProperty(value="restored")
        private final long numberRestoredCheckpoints;
        @JsonProperty(value="total")
        private final long totalNumberCheckpoints;
        @JsonProperty(value="in_progress")
        private final int numberInProgressCheckpoints;
        @JsonProperty(value="completed")
        private final long numberCompletedCheckpoints;
        @JsonProperty(value="failed")
        private final long numberFailedCheckpoints;

        @JsonCreator
        public Counts(@JsonProperty(value="restored") long numberRestoredCheckpoints, @JsonProperty(value="total") long totalNumberCheckpoints, @JsonProperty(value="in_progress") int numberInProgressCheckpoints, @JsonProperty(value="completed") long numberCompletedCheckpoints, @JsonProperty(value="failed") long numberFailedCheckpoints) {
            this.numberRestoredCheckpoints = numberRestoredCheckpoints;
            this.totalNumberCheckpoints = totalNumberCheckpoints;
            this.numberInProgressCheckpoints = numberInProgressCheckpoints;
            this.numberCompletedCheckpoints = numberCompletedCheckpoints;
            this.numberFailedCheckpoints = numberFailedCheckpoints;
        }

        public long getNumberRestoredCheckpoints() {
            return this.numberRestoredCheckpoints;
        }

        public long getTotalNumberCheckpoints() {
            return this.totalNumberCheckpoints;
        }

        public int getNumberInProgressCheckpoints() {
            return this.numberInProgressCheckpoints;
        }

        public long getNumberCompletedCheckpoints() {
            return this.numberCompletedCheckpoints;
        }

        public long getNumberFailedCheckpoints() {
            return this.numberFailedCheckpoints;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Counts counts = (Counts)o;
            return this.numberRestoredCheckpoints == counts.numberRestoredCheckpoints && this.totalNumberCheckpoints == counts.totalNumberCheckpoints && this.numberInProgressCheckpoints == counts.numberInProgressCheckpoints && this.numberCompletedCheckpoints == counts.numberCompletedCheckpoints && this.numberFailedCheckpoints == counts.numberFailedCheckpoints;
        }

        public int hashCode() {
            return Objects.hash(this.numberRestoredCheckpoints, this.totalNumberCheckpoints, this.numberInProgressCheckpoints, this.numberCompletedCheckpoints, this.numberFailedCheckpoints);
        }
    }
}

