/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages.dataset;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.runtime.io.network.partition.DataSetMetaInfo;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.rest.messages.ResponseBody;
import org.apache.flink.runtime.rest.messages.dataset.ClusterDataSetEntry;

public class ClusterDataSetListResponseBody
implements ResponseBody {
    private static final String FIELD_NAME_PARTITIONS = "dataSets";
    @JsonProperty(value="dataSets")
    private final List<ClusterDataSetEntry> dataSets;

    @JsonCreator
    private ClusterDataSetListResponseBody(@JsonProperty(value="dataSets") List<ClusterDataSetEntry> dataSets) {
        this.dataSets = dataSets;
    }

    public static ClusterDataSetListResponseBody from(Map<IntermediateDataSetID, DataSetMetaInfo> dataSets) {
        List<ClusterDataSetEntry> convertedInfo = dataSets.entrySet().stream().map(entry -> {
            DataSetMetaInfo metaInfo = (DataSetMetaInfo)entry.getValue();
            int numRegisteredPartitions = metaInfo.getNumRegisteredPartitions().orElse(0);
            int numTotalPartition = metaInfo.getNumTotalPartitions();
            return new ClusterDataSetEntry((IntermediateDataSetID)entry.getKey(), numRegisteredPartitions == numTotalPartition);
        }).collect(Collectors.toList());
        return new ClusterDataSetListResponseBody(convertedInfo);
    }

    @JsonIgnore
    public List<ClusterDataSetEntry> getDataSets() {
        return this.dataSets;
    }
}

