/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages.job.metrics;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public final class IOMetricsInfo {
    private static final String FIELD_NAME_BYTES_READ = "read-bytes";
    private static final String FIELD_NAME_BYTES_READ_COMPLETE = "read-bytes-complete";
    private static final String FIELD_NAME_BYTES_WRITTEN = "write-bytes";
    private static final String FIELD_NAME_BYTES_WRITTEN_COMPLETE = "write-bytes-complete";
    private static final String FIELD_NAME_RECORDS_READ = "read-records";
    private static final String FIELD_NAME_RECORDS_READ_COMPLETE = "read-records-complete";
    private static final String FIELD_NAME_RECORDS_WRITTEN = "write-records";
    private static final String FIELD_NAME_RECORDS_WRITTEN_COMPLETE = "write-records-complete";
    @JsonProperty(value="read-bytes")
    private final long bytesRead;
    @JsonProperty(value="read-bytes-complete")
    private final boolean bytesReadComplete;
    @JsonProperty(value="write-bytes")
    private final long bytesWritten;
    @JsonProperty(value="write-bytes-complete")
    private final boolean bytesWrittenComplete;
    @JsonProperty(value="read-records")
    private final long recordsRead;
    @JsonProperty(value="read-records-complete")
    private final boolean recordsReadComplete;
    @JsonProperty(value="write-records")
    private final long recordsWritten;
    @JsonProperty(value="write-records-complete")
    private final boolean recordsWrittenComplete;

    @JsonCreator
    public IOMetricsInfo(@JsonProperty(value="read-bytes") long bytesRead, @JsonProperty(value="read-bytes-complete") boolean bytesReadComplete, @JsonProperty(value="write-bytes") long bytesWritten, @JsonProperty(value="write-bytes-complete") boolean bytesWrittenComplete, @JsonProperty(value="read-records") long recordsRead, @JsonProperty(value="read-records-complete") boolean recordsReadComplete, @JsonProperty(value="write-records") long recordsWritten, @JsonProperty(value="write-records-complete") boolean recordsWrittenComplete) {
        this.bytesRead = bytesRead;
        this.bytesReadComplete = bytesReadComplete;
        this.bytesWritten = bytesWritten;
        this.bytesWrittenComplete = bytesWrittenComplete;
        this.recordsRead = recordsRead;
        this.recordsReadComplete = recordsReadComplete;
        this.recordsWritten = recordsWritten;
        this.recordsWrittenComplete = recordsWrittenComplete;
    }

    public long getBytesRead() {
        return this.bytesRead;
    }

    public boolean isBytesReadComplete() {
        return this.bytesReadComplete;
    }

    public long getBytesWritten() {
        return this.bytesWritten;
    }

    public boolean isBytesWrittenComplete() {
        return this.bytesWrittenComplete;
    }

    public long getRecordsRead() {
        return this.recordsRead;
    }

    public boolean isRecordsReadComplete() {
        return this.recordsReadComplete;
    }

    public long getRecordsWritten() {
        return this.recordsWritten;
    }

    public boolean isRecordsWrittenComplete() {
        return this.recordsWrittenComplete;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IOMetricsInfo that = (IOMetricsInfo)o;
        return this.bytesRead == that.bytesRead && this.bytesReadComplete == that.bytesReadComplete && this.bytesWritten == that.bytesWritten && this.bytesWrittenComplete == that.bytesWrittenComplete && this.recordsRead == that.recordsRead && this.recordsReadComplete == that.recordsReadComplete && this.recordsWritten == that.recordsWritten && this.recordsWrittenComplete == that.recordsWrittenComplete;
    }

    public int hashCode() {
        return Objects.hash(this.bytesRead, this.bytesReadComplete, this.bytesWritten, this.bytesWrittenComplete, this.recordsRead, this.recordsReadComplete, this.recordsWritten, this.recordsWrittenComplete);
    }
}

