/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.SerializedThrowable;

public class SerializedThrowableDeserializer
extends StdDeserializer<SerializedThrowable> {
    private static final long serialVersionUID = 1L;

    public SerializedThrowableDeserializer() {
        super(SerializedThrowable.class);
    }

    public SerializedThrowable deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonNode root = (JsonNode)p.readValueAsTree();
        byte[] serializedException = root.get("serialized-throwable").binaryValue();
        try {
            return (SerializedThrowable)InstantiationUtil.deserializeObject((byte[])serializedException, (ClassLoader)ClassLoader.getSystemClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Failed to deserialize " + SerializedThrowable.class.getCanonicalName(), e);
        }
    }
}

