/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.SerializedThrowable;

public class SerializedThrowableSerializer
extends StdSerializer<SerializedThrowable> {
    private static final long serialVersionUID = 1L;
    static final String FIELD_NAME_CLASS = "class";
    static final String FIELD_NAME_STACK_TRACE = "stack-trace";
    static final String FIELD_NAME_SERIALIZED_THROWABLE = "serialized-throwable";

    public SerializedThrowableSerializer() {
        super(SerializedThrowable.class);
    }

    public void serialize(SerializedThrowable value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeStartObject();
        gen.writeStringField(FIELD_NAME_CLASS, value.getOriginalErrorClassName());
        gen.writeStringField(FIELD_NAME_STACK_TRACE, value.getFullStringifiedStackTrace());
        gen.writeBinaryField(FIELD_NAME_SERIALIZED_THROWABLE, InstantiationUtil.serializeObject((Object)value));
        gen.writeEndObject();
    }
}

