/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages.taskmanager;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Collection;
import java.util.Objects;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.instance.HardwareDescription;
import org.apache.flink.runtime.resourcemanager.TaskManagerInfoWithSlots;
import org.apache.flink.runtime.rest.messages.ResourceProfileInfo;
import org.apache.flink.runtime.rest.messages.json.ResourceIDDeserializer;
import org.apache.flink.runtime.rest.messages.taskmanager.SlotInfo;
import org.apache.flink.runtime.rest.messages.taskmanager.TaskManagerInfo;
import org.apache.flink.runtime.rest.messages.taskmanager.TaskManagerMetricsInfo;
import org.apache.flink.runtime.taskexecutor.TaskExecutorMemoryConfiguration;
import org.apache.flink.util.Preconditions;

public class TaskManagerDetailsInfo
extends TaskManagerInfo {
    public static final String FIELD_NAME_METRICS = "metrics";
    public static final String FIELD_NAME_ALLOCATED_SLOTS = "allocatedSlots";
    @JsonProperty(value="metrics")
    private final TaskManagerMetricsInfo taskManagerMetrics;
    @JsonProperty(value="allocatedSlots")
    private final Collection<SlotInfo> allocatedSlots;

    @JsonCreator
    public TaskManagerDetailsInfo(@JsonDeserialize(using=ResourceIDDeserializer.class) @JsonProperty(value="id") ResourceID resourceId, @JsonProperty(value="path") String address, @JsonProperty(value="dataPort") int dataPort, @JsonProperty(value="jmxPort") int jmxPort, @JsonProperty(value="timeSinceLastHeartbeat") long lastHeartbeat, @JsonProperty(value="slotsNumber") int numberSlots, @JsonProperty(value="freeSlots") int numberAvailableSlots, @JsonProperty(value="totalResource") ResourceProfileInfo totalResource, @JsonProperty(value="freeResource") ResourceProfileInfo freeResource, @JsonProperty(value="hardware") HardwareDescription hardwareDescription, @JsonProperty(value="memoryConfiguration") TaskExecutorMemoryConfiguration memoryConfiguration, @JsonProperty(value="allocatedSlots") Collection<SlotInfo> allocatedSlots, @JsonProperty(value="metrics") TaskManagerMetricsInfo taskManagerMetrics) {
        super(resourceId, address, dataPort, jmxPort, lastHeartbeat, numberSlots, numberAvailableSlots, totalResource, freeResource, hardwareDescription, memoryConfiguration);
        this.taskManagerMetrics = (TaskManagerMetricsInfo)Preconditions.checkNotNull((Object)taskManagerMetrics);
        this.allocatedSlots = (Collection)Preconditions.checkNotNull(allocatedSlots);
    }

    public TaskManagerDetailsInfo(TaskManagerInfoWithSlots taskManagerInfoWithSlots, TaskManagerMetricsInfo taskManagerMetrics) {
        this(taskManagerInfoWithSlots.getTaskManagerInfo().getResourceId(), taskManagerInfoWithSlots.getTaskManagerInfo().getAddress(), taskManagerInfoWithSlots.getTaskManagerInfo().getDataPort(), taskManagerInfoWithSlots.getTaskManagerInfo().getJmxPort(), taskManagerInfoWithSlots.getTaskManagerInfo().getLastHeartbeat(), taskManagerInfoWithSlots.getTaskManagerInfo().getNumberSlots(), taskManagerInfoWithSlots.getTaskManagerInfo().getNumberAvailableSlots(), taskManagerInfoWithSlots.getTaskManagerInfo().getTotalResource(), taskManagerInfoWithSlots.getTaskManagerInfo().getFreeResource(), taskManagerInfoWithSlots.getTaskManagerInfo().getHardwareDescription(), taskManagerInfoWithSlots.getTaskManagerInfo().getMemoryConfiguration(), taskManagerInfoWithSlots.getAllocatedSlots(), taskManagerMetrics);
    }

    @JsonIgnore
    @VisibleForTesting
    public final TaskManagerMetricsInfo getTaskManagerMetricsInfo() {
        return this.taskManagerMetrics;
    }

    @JsonIgnore
    public Collection<SlotInfo> getAllocatedSlots() {
        return this.allocatedSlots;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TaskManagerDetailsInfo that = (TaskManagerDetailsInfo)o;
        return Objects.equals(this.taskManagerMetrics, that.taskManagerMetrics);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.taskManagerMetrics);
    }
}

